/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.common.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.concurrent.atomic.AtomicLong;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.modeshape.common.annotation.Immutable;
import org.modeshape.common.util.CheckArg;

@Immutable
public class FileUtil {
    private static FilenameFilter ACCEPT_ALL = new FilenameFilter(){

        @Override
        public boolean accept(File dir, String name) {
            return true;
        }
    };

    public static boolean delete(String path) {
        if (path == null || path.trim().length() == 0) {
            return false;
        }
        return FileUtil.delete(new File(path));
    }

    public static boolean delete(File fileOrDirectory) {
        File[] files;
        if (fileOrDirectory == null) {
            return false;
        }
        if (!fileOrDirectory.exists()) {
            return false;
        }
        if (fileOrDirectory.isDirectory() && (files = fileOrDirectory.listFiles()) != null) {
            for (File childFile : files) {
                FileUtil.delete(childFile);
            }
        }
        return fileOrDirectory.delete();
    }

    public static int copy(File sourceFileOrDirectory, File destinationFileOrDirectory) throws IOException {
        return FileUtil.copy(sourceFileOrDirectory, destinationFileOrDirectory, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int copy(File sourceFileOrDirectory, File destinationFileOrDirectory, FilenameFilter exclusionFilter) throws IOException {
        if (exclusionFilter == null) {
            exclusionFilter = ACCEPT_ALL;
        }
        int numberOfFilesCopied = 0;
        if (sourceFileOrDirectory.isDirectory()) {
            destinationFileOrDirectory.mkdirs();
            String[] list = sourceFileOrDirectory.list(exclusionFilter);
            for (int i = 0; i < list.length; ++i) {
                String dest1 = destinationFileOrDirectory.getPath() + File.separator + list[i];
                String src1 = sourceFileOrDirectory.getPath() + File.separator + list[i];
                numberOfFilesCopied += FileUtil.copy(new File(src1), new File(dest1), exclusionFilter);
            }
        } else {
            InputStream fin = new FileInputStream(sourceFileOrDirectory);
            fin = new BufferedInputStream(fin);
            try {
                OutputStream fout = new FileOutputStream(destinationFileOrDirectory);
                fout = new BufferedOutputStream(fout);
                try {
                    int c;
                    while ((c = fin.read()) >= 0) {
                        fout.write(c);
                    }
                }
                finally {
                    fout.close();
                }
            }
            finally {
                fin.close();
            }
            ++numberOfFilesCopied;
        }
        return numberOfFilesCopied;
    }

    public static URL convertFileToURL(String filePath) throws MalformedURLException {
        CheckArg.isNotEmpty(filePath, "filePath");
        File file = new File(filePath.trim());
        return file.toURI().toURL();
    }

    public static long size(String filePath) throws IOException {
        CheckArg.isNotEmpty(filePath, "filePath");
        File file = new File(filePath);
        if (!file.exists()) {
            return 0L;
        }
        if (file.isFile()) {
            return file.length();
        }
        final AtomicLong size = new AtomicLong();
        Files.walkFileTree(Paths.get(filePath, new String[0]), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
                size.addAndGet(attrs.size());
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFileFailed(Path file, IOException exc) {
                return FileVisitResult.CONTINUE;
            }
        });
        return size.get();
    }

    public static void unzip(InputStream zipFile, String dest) throws IOException {
        byte[] buffer = new byte[1024];
        File folder = new File(dest);
        if (folder.exists()) {
            FileUtil.delete(folder);
        }
        folder.mkdir();
        ZipInputStream zis = new ZipInputStream(zipFile);
        ZipEntry ze = zis.getNextEntry();
        while (ze != null) {
            int len;
            String fileName = ze.getName();
            File newFile = new File(fileName);
            new File(newFile.getParent()).mkdirs();
            FileOutputStream fos = new FileOutputStream(newFile);
            while ((len = zis.read(buffer)) > 0) {
                fos.write(buffer, 0, len);
            }
            fos.close();
            ze = zis.getNextEntry();
        }
        zis.closeEntry();
        zis.close();
    }

    public static void zipDir(String dirName, String nameZipFile) throws IOException {
        ZipOutputStream zip = null;
        FileOutputStream fW = null;
        fW = new FileOutputStream(nameZipFile);
        zip = new ZipOutputStream(fW);
        FileUtil.addFolderToZip("", dirName, zip);
        zip.close();
        fW.close();
    }

    public static void addFolderToZip(String path, String srcFolder, ZipOutputStream zip) throws IOException {
        File folder = new File(srcFolder);
        if (folder.list().length == 0) {
            FileUtil.addFileToZip(path, srcFolder, zip, true);
        } else {
            for (String fileName : folder.list()) {
                if (path.equals("")) {
                    FileUtil.addFileToZip(folder.getName(), srcFolder + "/" + fileName, zip, false);
                    continue;
                }
                FileUtil.addFileToZip(path + "/" + folder.getName(), srcFolder + "/" + fileName, zip, false);
            }
        }
    }

    public static void addFileToZip(String path, String srcFile, ZipOutputStream zip, boolean flag) throws IOException {
        File folder = new File(srcFile);
        if (flag) {
            zip.putNextEntry(new ZipEntry(path + "/" + folder.getName() + "/"));
        } else if (folder.isDirectory()) {
            FileUtil.addFolderToZip(path, srcFile, zip);
        } else {
            int len;
            byte[] buf = new byte[1024];
            FileInputStream in = new FileInputStream(srcFile);
            zip.putNextEntry(new ZipEntry(path + "/" + folder.getName()));
            while ((len = in.read(buf)) > 0) {
                zip.write(buf, 0, len);
            }
        }
    }

    private FileUtil() {
    }
}

