/*
 * Decompiled with CFR 0.152.
 */
package org.rzo.yajsw.cache;

import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.vfs2.AllFileSelector;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSelector;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileType;
import org.apache.commons.vfs2.VFS;
import org.apache.commons.vfs2.impl.DefaultFileSystemManager;
import org.rzo.yajsw.config.YajswConfigurationImpl;
import org.rzo.yajsw.util.VFSUtils;

public class Cache {
    boolean _loaded = false;
    Logger _logger;
    int _debug;

    public Cache(Logger logger, int debug) {
        this._logger = logger;
        this._debug = debug;
    }

    public Cache() {
        this(null, 0);
    }

    public boolean load(YajswConfigurationImpl config) {
        try {
            boolean reload = config.getBoolean("wrapper.restart.reload_configuration", false);
            if (!reload && this._loaded) {
                return true;
            }
            String workingDir = config.getString("wrapper.working.dir", ".");
            String base = config.getString("wrapper.codebase", workingDir);
            String cache = config.getCache();
            DefaultFileSystemManager fsManager = (DefaultFileSystemManager)VFS.getManager();
            FileObject basef = VFSUtils.resolveFile(".", base);
            FileObject cachef = VFSUtils.resolveFile(".", cache);
            if (!VFSUtils.isLocal(cachef)) {
                this.log("cache must be a local folder -> abort");
                return false;
            }
            if (!cachef.exists()) {
                cachef.createFolder();
            }
            if (cachef.getType() != FileType.FOLDER) {
                this.log("cache must be a folder -> abort");
                return false;
            }
            boolean cacheLocal = config.getBoolean("wrapper.cache.local", false);
            Configuration resources = config.subset("wrapper.resource");
            Iterator it = resources.getKeys();
            while (it.hasNext()) {
                String key = (String)it.next();
                this.loadFiles("wrapper.resource." + key, config, basef, cachef, cacheLocal, fsManager);
            }
            Configuration classpath = config.subset("wrapper.java.classpath");
            Iterator it2 = classpath.getKeys();
            while (it2.hasNext()) {
                String key = (String)it2.next();
                this.loadFiles("wrapper.java.classpath." + key, config, basef, cachef, cacheLocal, fsManager);
            }
            this._loaded = true;
            return true;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
    }

    private void loadFiles(String key, YajswConfigurationImpl config, FileObject basef, FileObject cachef, boolean cacheLocal, DefaultFileSystemManager fsManager) {
        try {
            String value = config.getString(key);
            List<FileObject> files = VFSUtils.resolveFiles(basef, value, fsManager);
            int count = 0;
            for (FileObject source : files) {
                FileObject destination = this.loadFile(value, source, basef, cachef, cacheLocal, fsManager);
                if (destination == null) continue;
                config.getFileConfiguration().setProperty(key + "$" + count++, (Object)destination.getURL().getFile().substring(2));
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private FileObject loadFile(String value, FileObject source, FileObject basef, FileObject cachef, boolean cacheLocal, DefaultFileSystemManager fsManager) {
        try {
            boolean isLocal = VFSUtils.isLocal(source);
            if (isLocal && !cacheLocal) {
                return null;
            }
            FileObject destination = null;
            boolean absolute = false;
            try {
                destination = VFSUtils.resolveFile((String)null, value);
                absolute = true;
            }
            catch (Exception ex) {
                // empty catch block
            }
            if (!absolute) {
                destination = VFSUtils.resolveFile(cachef, basef.getName().getRelativeName(source.getName()));
            } else {
                String fileName = destination.getName().getBaseName();
                destination = VFSUtils.resolveFile(cachef, fileName);
            }
            if (this.fileChanged(source, destination)) {
                destination.copyFrom(source, (FileSelector)new AllFileSelector());
                if (source.getContent().getLastModifiedTime() != 0L) {
                    destination.getContent().setLastModifiedTime(source.getContent().getLastModifiedTime());
                }
                if (this._debug > 1) {
                    this.log("cache file loaded " + source.getName() + " -> " + destination.getName());
                }
            } else if (this._debug > 2) {
                this.log("cache file up to date: " + destination.getName());
            }
            return destination;
        }
        catch (Exception ex) {
            this.log("error in cache.loadFile: " + (source == null ? "null" : source.getName()));
            ex.printStackTrace();
            return null;
        }
    }

    private boolean fileChanged(FileObject source, FileObject destination) {
        try {
            return !destination.exists() || source.getContent().getLastModifiedTime() == 0L || source.getContent().getLastModifiedTime() != destination.getContent().getLastModifiedTime();
        }
        catch (FileSystemException e) {
            e.printStackTrace();
            return true;
        }
    }

    private void log(String msg) {
        if (this._logger == null) {
            System.out.println(msg);
        } else {
            this._logger.info(msg);
        }
    }

    public static void main(String[] args) {
        Cache c = new Cache();
        System.setProperty("wrapper.config", "http://localhost:8080/wrapper.helloworld.conf");
        YajswConfigurationImpl config = new YajswConfigurationImpl();
        c.load(config);
    }
}

