/*
 * Decompiled with CFR 0.152.
 */
package org.rzo.yajsw.config;

import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.configuration.CompositeConfiguration;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationConverter;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.FileOptionsProvider;
import org.apache.commons.configuration.FileSystem;
import org.apache.commons.configuration.Interpolator;
import org.apache.commons.configuration.MapConfiguration;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.configuration.VFSFileSystem;
import org.apache.commons.logging.Log;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.VFS;
import org.apache.commons.vfs2.impl.DefaultFileSystemManager;
import org.rzo.yajsw.config.YajswConfiguration;
import org.rzo.yajsw.config.jnlp.JnlpSupport;
import org.rzo.yajsw.os.OperatingSystem;
import org.rzo.yajsw.script.GroovyScript;
import org.rzo.yajsw.util.CaseInsensitiveMap;
import org.rzo.yajsw.util.CommonsLoggingAdapter;
import org.rzo.yajsw.util.VFSUtils;

public class YajswConfigurationImpl
extends CompositeConfiguration
implements YajswConfiguration {
    InternalLogger log = InternalLoggerFactory.getInstance(this.getClass().getName());
    Configuration _systemProperties;
    Configuration _localConfiguration;
    CompositeConfiguration _systemConfiguration = new CompositeConfiguration();
    boolean debug = false;
    boolean _useSystemProperties = true;
    boolean _isStopper = false;
    boolean _init = false;
    PropertiesConfiguration _fileConfiguration = null;
    Interpolator _interpolator;
    Set _interpolated = new HashSet();
    Map _scriptUtils = null;
    boolean _isJavaDebug = false;

    public YajswConfigurationImpl() {
        this.init();
    }

    public YajswConfigurationImpl(boolean debug) {
        this.setDebug(debug);
        this.init();
    }

    public YajswConfigurationImpl(Configuration localConfiguration, boolean useSystemProperties) {
        this(localConfiguration, useSystemProperties, null);
    }

    public YajswConfigurationImpl(Configuration localConfiguration, boolean useSystemProperties, Map scriptUtils) {
        this._localConfiguration = localConfiguration;
        this._useSystemProperties = useSystemProperties;
        this._scriptUtils = scriptUtils;
        this.init();
    }

    public Interpolator getYajswInterpolator() {
        return this._interpolator;
    }

    @Override
    public void init() {
        if (this._init) {
            return;
        }
        if (this._scriptUtils == null) {
            this._scriptUtils = new HashMap();
        }
        try {
            this._interpolator = this.createGInterpolatornew((Configuration)this, true, null, this._scriptUtils);
            this.setInterpolator(this._interpolator);
        }
        catch (Exception e1) {
            this.log.warn("WARNING: could not instatiate groovy in wrapper configuration.");
        }
        if (this._localConfiguration != null) {
            this._systemConfiguration.addConfiguration(this._localConfiguration);
            if (this.debug) {
                this.log.debug("added local configuration ");
            }
        }
        if (this._useSystemProperties) {
            this._systemProperties = ConfigurationConverter.getConfiguration((Properties)((Properties)System.getProperties().clone()));
            this._systemConfiguration.addConfiguration(this._systemProperties);
            if (this.debug) {
                this.log.debug("added system configuration ");
            }
        }
        this._systemConfiguration.addConfiguration((Configuration)new MapConfiguration((Map)(!OperatingSystem.instance().isPosix() ? new CaseInsensitiveMap(System.getenv()) : new HashMap<String, String>(System.getenv()))));
        this.addConfiguration((Configuration)this._systemConfiguration);
        String configFile = (String)this.getProperty("wrapper.config");
        if (configFile != null && configFile.contains("\"")) {
            configFile = configFile.replaceAll("\"", "");
        }
        if (configFile == null) {
            if (this.debug) {
                this.log.warn("configuration file not set");
            }
        } else if (!this.fileExists(configFile)) {
            this.log.error("configuration file not found: " + configFile);
        } else {
            if (configFile.endsWith(".jnlp")) {
                try {
                    JnlpSupport jnlp = new JnlpSupport(configFile);
                    this._fileConfiguration = jnlp.toConfiguration((String)this.getProperty("wrapperx.default.config"));
                    this._fileConfiguration.setFileName(configFile);
                    this.addConfiguration((Configuration)this._fileConfiguration);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    return;
                }
            }
            if (this._fileConfiguration == null) {
                try {
                    VFSFileSystem fs = new VFSFileSystem();
                    fs.setLogger((Log)new CommonsLoggingAdapter(this.log));
                    fs.setFileOptionsProvider(new FileOptionsProvider(){

                        public Map getOptions() {
                            HashMap<String, Object> result = new HashMap<String, Object>();
                            String httpProxy = System.getProperty("http.proxyHost");
                            String httpPort = System.getProperty("http.proxyPort");
                            if (httpProxy != null) {
                                int port = 8080;
                                if (httpPort != null) {
                                    try {
                                        port = Integer.parseInt(httpPort);
                                    }
                                    catch (Exception ex) {
                                        ex.printStackTrace();
                                    }
                                }
                                result.put("proxyHost", httpProxy);
                                result.put("proxyPort", port);
                            }
                            return result;
                        }
                    });
                    FileSystem.setDefaultFileSystem((FileSystem)fs);
                    this._fileConfiguration = new PropertiesConfiguration();
                    this._fileConfiguration.setFileName(configFile);
                    this._fileConfiguration.append((Configuration)this._systemConfiguration);
                    if (this._interpolator != null) {
                        try {
                            this._fileConfiguration.setInterpolator(this.createGInterpolatornew((Configuration)this._fileConfiguration, true, null, this._scriptUtils));
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    this._fileConfiguration.load();
                    String encoding = this._fileConfiguration.getString("wrapper.conf.encoding");
                    if (encoding != null) {
                        this._fileConfiguration = new PropertiesConfiguration();
                        this._fileConfiguration.setEncoding(encoding);
                        this._fileConfiguration.setFileName(configFile);
                        this._fileConfiguration.append((Configuration)this._systemConfiguration);
                        if (this._interpolator != null) {
                            try {
                                this._fileConfiguration.setInterpolator(this.createGInterpolatornew((Configuration)this._fileConfiguration, true, null, this._scriptUtils));
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                        this._fileConfiguration.load();
                    }
                    this.addConfiguration((Configuration)this._fileConfiguration);
                }
                catch (ConfigurationException e) {
                    this.log.error("error loading configuration file <init>AsjwConfiguration", (Throwable)e);
                }
            }
            if (!this.isLocalFile()) {
                if (this._fileConfiguration.getProperty("wrapper.working.dir") == null) {
                    try {
                        this._fileConfiguration.setProperty("wrapper.working.dir", (Object)new File(this.getCache()).getCanonicalPath().replaceAll("\\\\", "/"));
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                if (this._fileConfiguration.containsKey("wrapper.cache")) {
                    this._fileConfiguration.setProperty("wrapper.cache", (Object)this.getCache());
                }
            }
        }
        this._isStopper = this.getBoolean("wrapper.stopper", false);
        try {
            this._isJavaDebug = this.getInt("wrapper.java.debug.port", -1) != -1;
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        Iterator it = this.getKeys("wrapper.config.script");
        while (it.hasNext()) {
            try {
                String key = (String)it.next();
                String script = this.getString(key);
                String bind = key.substring(key.lastIndexOf(".") + 1);
                this._scriptUtils.put(bind, new GroovyScript(script, "", null, null, 0, this.log, null, false, 1));
            }
            catch (Exception e) {
                this.log.error("error reading script", (Throwable)e);
            }
        }
        this._init = true;
    }

    private Interpolator createGInterpolatornew(Configuration conf, boolean b, String[] object, Map utils) {
        Interpolator result = null;
        try {
            Class<?> clazz = conf.getClass().getClassLoader().loadClass("org.apache.commons.configuration.GInterpolator");
            Constructor<?> rc = clazz.getDeclaredConstructor(Configuration.class, Boolean.TYPE, String[].class, Map.class);
            result = (Interpolator)rc.newInstance(conf, b, object, utils);
        }
        catch (Exception e) {
            this.log.warn("WARNING: could not load configuration groovy interpolator");
        }
        return result;
    }

    private boolean fileExists(String file) {
        try {
            DefaultFileSystemManager fsManager = (DefaultFileSystemManager)VFS.getManager();
            FileObject f = VFSUtils.resolveFile(".", file);
            return f.exists();
        }
        catch (FileSystemException e) {
            e.printStackTrace();
            return false;
        }
    }

    boolean isDebug() {
        return this.debug;
    }

    @Override
    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    protected Object resolveContainerStore(String key) {
        Object result = null;
        if (key == null) {
            result = null;
        }
        if (this._isJavaDebug) {
            if (key.equals("wrapper.startup.timeout")) {
                result = 2147483;
            } else if (key.equals("wrapper.shutdown.timeout")) {
                result = 2147483;
            } else if (key.equals("wrapper.ping.timeout")) {
                result = 2147483;
            }
        }
        if (result != null) {
            return result;
        }
        if (!this._isStopper) {
            result = super.resolveContainerStore(key);
        } else {
            if (key.startsWith("wrapper.on_exit")) {
                return null;
            }
            result = key.startsWith("wrapper.exit_on_main_terminate") ? "0" : (key.startsWith("wrapper.daemon") ? null : (key.contains(".script") ? null : (key.contains(".filter") ? null : (key.contains(".pidfile") ? null : (key.contains(".ntservice") ? null : (key.contains(".jmx") ? null : (key.contains(".lockfile") ? null : (key.contains(".stop.conf") ? null : (key.equals("wrapper.tray") ? null : super.resolveContainerStore(key))))))))));
        }
        if (this._interpolator != null && result != null && !result.equals(this._interpolator.interpolate(result))) {
            this._interpolated.add(key);
        }
        return result;
    }

    public Set getLookupSet() {
        return this._interpolated;
    }

    public Map<String, String> getEnvLookupSet() {
        if (this._interpolator != null) {
            Map<String, String> result = this._interpolator.getUsedEnvVars();
            result.putAll(this._interpolator.getFromBinding());
            return result;
        }
        return new HashMap<String, String>();
    }

    public static void main(String[] args) {
        YajswConfigurationImpl c = new YajswConfigurationImpl();
        c.setProperty("t1", "x");
        c.setProperty("t2", "${t1}");
        System.out.println(c.getString("t2"));
        Iterator it = c.getInterpolator().prefixSet().iterator();
        while (it.hasNext()) {
            System.out.println(it.next());
        }
    }

    public CompositeConfiguration getSystemConfiguration() {
        return this._systemConfiguration;
    }

    public void reload() {
        if (this._fileConfiguration != null) {
            this._fileConfiguration.reload();
        }
    }

    public boolean isLocalFile() {
        if (this._fileConfiguration == null) {
            return true;
        }
        try {
            String name = this._fileConfiguration.getFileName();
            if (name.endsWith(".jnlp")) {
                return false;
            }
            FileObject f = VFSUtils.resolveFile(".", name);
            return VFSUtils.isLocal(f);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return true;
        }
    }

    public String getCache() {
        return this.getString("wrapper.cache", "yajsw_cache");
    }

    @Override
    public String getCachedPath() {
        return this.getCachedPath(true);
    }

    public String getCachedPath(boolean save) {
        if (this._fileConfiguration == null) {
            return null;
        }
        if (this.isLocalFile()) {
            try {
                return new File(this._fileConfiguration.getURL().toURI()).getCanonicalPath();
            }
            catch (IOException e) {
                e.printStackTrace();
                return this._fileConfiguration.getFileName();
            }
            catch (URISyntaxException e) {
                e.printStackTrace();
            }
        }
        try {
            String cache = this.getCache() + "/conf";
            String fileName = this._fileConfiguration.getFileSystem().getFileName(this._fileConfiguration.getFileName());
            File cf = new File(cache);
            if (!cf.exists()) {
                cf.mkdirs();
            }
            if (fileName.endsWith(".jnlp")) {
                fileName = fileName + ".conf";
            }
            File cn = new File(cf, fileName);
            if (save) {
                PropertiesConfiguration c2 = (PropertiesConfiguration)this._fileConfiguration.interpolatedConfiguration();
                c2.save(cn);
            }
            return cn.getCanonicalPath();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return this._fileConfiguration.getFileName();
        }
    }

    public Configuration getFileConfiguration() {
        return this._fileConfiguration;
    }

    @Override
    public String getString(String key) {
        String value = super.getString(key);
        return value;
    }

    public long getConfigFileTime() {
        return -1L;
    }

    public boolean isStopper() {
        return this._isStopper;
    }
}

