/*
 * Decompiled with CFR 0.152.
 */
package org.rzo.yajsw.wrapper;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.MapConfiguration;
import org.rzo.yajsw.config.YajswConfiguration;
import org.rzo.yajsw.config.YajswConfigurationImpl;
import org.rzo.yajsw.wrapper.WrappedGroovyProcess;
import org.rzo.yajsw.wrapper.WrappedJavaProcess;
import org.rzo.yajsw.wrapper.WrappedProcess;
import org.rzo.yajsw.wrapper.WrappedProcessList;
import org.rzo.yajsw.wrapper.WrappedRuntimeJavaProcess;
import org.rzo.yajsw.wrapper.WrappedRuntimeProcess;

public class WrappedProcessFactory {
    public static WrappedProcess createProcess(YajswConfiguration config) {
        if (config.getString("wrapper.image") != null) {
            if ("true".equals(config.getString("wrapper.image.javawrapper"))) {
                return new WrappedRuntimeJavaProcess();
            }
            return new WrappedRuntimeProcess();
        }
        if (config.getString("wrapper.groovy") != null) {
            return new WrappedGroovyProcess();
        }
        return new WrappedJavaProcess();
    }

    public static WrappedProcess createProcess(Map map, boolean useSystemProperties) {
        MapConfiguration localConf = new MapConfiguration(map);
        YajswConfigurationImpl conf = new YajswConfigurationImpl((Configuration)localConf, true);
        WrappedProcess process = WrappedProcessFactory.createProcess(conf);
        process.setLocalConfiguration((Configuration)localConf);
        process.setUseSystemProperties(useSystemProperties);
        process.init();
        return process;
    }

    public static WrappedProcessList createProcessList(Map map, List<Object> confFiles, boolean useSystemProperties) {
        WrappedProcessList list = new WrappedProcessList();
        for (Object conf : confFiles) {
            HashMap<String, Object> sConf = new HashMap<String, Object>(map);
            sConf.put("wrapper.config", conf);
            list.add(WrappedProcessFactory.createProcess(sConf, useSystemProperties));
        }
        return list;
    }
}

