from parser.performance import performance_test_result_parser

from com.xebialabs.xlt.plugin.api.resultparser.performance import SamplingPerformanceResultsSummary
from parser.xunit import open_file

class JMeterCsvParser(object):

    def __init__(self):
        self.start_time = None

    def filter_readable(self, blob):
        result = []
        for file in blob:
            if str(file).endswith("csv"):
                with open_file(file) as f:
                    try:
                        first_line = f.readline().split(',')
                        second_line = f.readline().split(',')
                        if first_line[0] == "timestamp" and int(second_line[0]) >0:
                            result.append(file)
                        elif int(first_line[0] >0):
                            result.append(file)
                    except:
                        pass

        return result

    def construct_performance_results_summary(self, file):
        result = SamplingPerformanceResultsSummary()

        lines = [line.rstrip('\n') for line in open(file.getPath())]
        if lines[0].startswith("timeStamp"):
            del lines[0]

        for currLine in lines:
            splitted_line = str.split(currLine, ',')

            result.updateWithSample(int(splitted_line[0]), int(splitted_line[1]), splitted_line[7])

        return result

    def enrich_import_started_event(self, importStartedEvent):
        pass



result_holder.result = performance_test_result_parser(files, test_run_historian=test_run_historian, parser=JMeterCsvParser())
