#!/bin/sh
VARIANT=unknown

if type systemctl > /dev/null 2>&1; then
    echo "Init appears to be systemd"
    VARIANT=systemd
elif type initctl > /dev/null 2>&1; then
    echo "Init appears to be upstart"
    VARIANT=upstart
fi

case $VARIANT in
upstart)
  initctl stop xl-testview
  rm /etc/init/xl-testview.conf
  echo "Removed upstart script: /etc/init/xl-testview.conf"
  ;;
systemd)
  systemctl stop xl-testview.service
  systemctl disable xl-testview.service
  rm /lib/systemd/system/xl-testview.service
  systemctl daemon-reload
  echo "Removed systemd script: /lib/systemd/system/xl-testview.service"
  ;;
*)
  echo "Did not detect systemd or upstart. Aborting."
  exit 1
  ;;
esac
