/*
 * Decompiled with CFR 0.152.
 */
package org.mapdb;

import java.io.DataInput;
import java.io.EOFException;
import java.io.File;
import java.io.IOError;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.Arrays;
import java.util.concurrent.locks.ReentrantLock;
import org.mapdb.DataInput2;
import org.mapdb.SerializerPojo;

public abstract class Volume {
    public void ensureAvailable(long offset) {
        if (!this.tryAvailable(offset)) {
            throw new IOError(new IOException("no free space to expand Volume"));
        }
    }

    public abstract boolean tryAvailable(long var1);

    public abstract void truncate(long var1);

    public abstract void putLong(long var1, long var3);

    public abstract void putInt(long var1, int var3);

    public abstract void putByte(long var1, byte var3);

    public abstract void putData(long var1, byte[] var3, int var4, int var5);

    public abstract void putData(long var1, ByteBuffer var3);

    public abstract long getLong(long var1);

    public abstract int getInt(long var1);

    public abstract byte getByte(long var1);

    public abstract DataInput getDataInput(long var1, int var3);

    public abstract void close();

    public abstract void sync();

    public abstract boolean isEmpty();

    public abstract void deleteFile();

    public abstract boolean isSliced();

    public void putUnsignedShort(long offset, int value) {
        this.putByte(offset, (byte)(value >> 8));
        this.putByte(offset + 1L, (byte)value);
    }

    public int getUnsignedShort(long offset) {
        return (this.getByte(offset) & 0xFF) << 8 | this.getByte(offset + 1L) & 0xFF;
    }

    public int getUnsignedByte(long offset) {
        return this.getByte(offset) & 0xFF;
    }

    public void putUnsignedByte(long offset, int b) {
        this.putByte(offset, (byte)(b & 0xFF));
    }

    public long getSixLong(long pos) {
        return (long)(this.getByte(pos + 0L) & 0xFF) << 40 | (long)(this.getByte(pos + 1L) & 0xFF) << 32 | (long)(this.getByte(pos + 2L) & 0xFF) << 24 | (long)(this.getByte(pos + 3L) & 0xFF) << 16 | (long)(this.getByte(pos + 4L) & 0xFF) << 8 | (long)(this.getByte(pos + 5L) & 0xFF) << 0;
    }

    public void putSixLong(long pos, long value) {
        assert (value >= 0L && value >>> 48 == 0L) : "value does not fit";
        this.putByte(pos + 0L, (byte)(0xFFL & value >> 40));
        this.putByte(pos + 1L, (byte)(0xFFL & value >> 32));
        this.putByte(pos + 2L, (byte)(0xFFL & value >> 24));
        this.putByte(pos + 3L, (byte)(0xFFL & value >> 16));
        this.putByte(pos + 4L, (byte)(0xFFL & value >> 8));
        this.putByte(pos + 5L, (byte)(0xFFL & value >> 0));
    }

    public int putPackedLong(long pos, long value) {
        assert (value >= 0L) : "negative value";
        int ret = 0;
        while ((value & 0xFFFFFFFFFFFFFF80L) != 0L) {
            this.putUnsignedByte(pos + (long)ret++, (int)value & 0x7F | 0x80);
            value >>>= 7;
        }
        this.putUnsignedByte(pos + (long)ret++, (byte)value);
        return ret;
    }

    public abstract File getFile();

    public long getPackedLong(long pos) {
        long result = 0L;
        for (int offset = 0; offset < 64; offset += 7) {
            long b = this.getUnsignedByte(pos++);
            result |= (b & 0x7FL) << offset;
            if ((b & 0x80L) != 0L) continue;
            return result;
        }
        throw new AssertionError((Object)"Malformed long.");
    }

    public static Volume volumeForFile(File f, boolean useRandomAccessFile, boolean readOnly, long sizeLimit, int chunkShift, int sizeIncrement) {
        return useRandomAccessFile ? new FileChannelVol(f, readOnly, sizeLimit, chunkShift, sizeIncrement) : new MappedFileVol(f, readOnly, sizeLimit, chunkShift, sizeIncrement);
    }

    public static Factory fileFactory(File indexFile, int rafMode, boolean readOnly, long sizeLimit, int chunkShift, int sizeIncrement) {
        return Volume.fileFactory(indexFile, rafMode, readOnly, sizeLimit, chunkShift, sizeIncrement, new File(indexFile.getPath() + ".p"), new File(indexFile.getPath() + ".t"));
    }

    public static Factory fileFactory(final File indexFile, final int rafMode, final boolean readOnly, final long sizeLimit, final int chunkShift, final int sizeIncrement, final File physFile, final File transLogFile) {
        return new Factory(){

            @Override
            public Volume createIndexVolume() {
                return Volume.volumeForFile(indexFile, rafMode > 1, readOnly, sizeLimit, chunkShift, sizeIncrement);
            }

            @Override
            public Volume createPhysVolume() {
                return Volume.volumeForFile(physFile, rafMode > 0, readOnly, sizeLimit, chunkShift, sizeIncrement);
            }

            @Override
            public Volume createTransLogVolume() {
                return Volume.volumeForFile(transLogFile, rafMode > 0, readOnly, sizeLimit, chunkShift, sizeIncrement);
            }
        };
    }

    public static Factory memoryFactory(final boolean useDirectBuffer, final long sizeLimit, final int chunkShift) {
        return new Factory(){

            @Override
            public synchronized Volume createIndexVolume() {
                return new MemoryVol(useDirectBuffer, sizeLimit, chunkShift);
            }

            @Override
            public synchronized Volume createPhysVolume() {
                return new MemoryVol(useDirectBuffer, sizeLimit, chunkShift);
            }

            @Override
            public synchronized Volume createTransLogVolume() {
                return new MemoryVol(useDirectBuffer, sizeLimit, chunkShift);
            }
        };
    }

    public static void volumeTransfer(long size, Volume from, Volume to) {
        int bufSize = 65536;
        for (long offset = 0L; offset < size; offset += (long)bufSize) {
            int bb = (int)Math.min((long)bufSize, size - offset);
            DataInput2 input = (DataInput2)from.getDataInput(offset, bb);
            ByteBuffer buf = input.buf.duplicate();
            buf.position(input.pos);
            buf.limit(input.pos + bb);
            to.ensureAvailable(offset + (long)bb);
            to.putData(offset, buf);
        }
    }

    public static final class FileChannelVol
    extends Volume {
        protected final File file;
        protected final int chunkSize;
        protected RandomAccessFile raf;
        protected FileChannel channel;
        protected final boolean readOnly;
        protected final long sizeLimit;
        protected final boolean hasLimit;
        protected volatile long size;
        protected final Object growLock = new Object();

        public FileChannelVol(File file, boolean readOnly, long sizeLimit, int chunkShift, int sizeIncrement) {
            this.file = file;
            this.readOnly = readOnly;
            this.sizeLimit = sizeLimit;
            this.hasLimit = sizeLimit > 0L;
            this.chunkSize = 1 << chunkShift;
            try {
                FileChannelVol.checkFolder(file, readOnly);
                if (readOnly && !file.exists()) {
                    this.raf = null;
                    this.channel = null;
                    this.size = 0L;
                } else {
                    this.raf = new RandomAccessFile(file, readOnly ? "r" : "rw");
                    this.channel = this.raf.getChannel();
                    this.size = this.channel.size();
                }
            }
            catch (IOException e) {
                throw new IOError(e);
            }
        }

        protected static void checkFolder(File file, boolean readOnly) throws IOException {
            File parent = file.getParentFile();
            if (parent == null) {
                parent = file.getCanonicalFile().getParentFile();
            }
            if (parent == null) {
                throw new IOException("Parent folder could not be determined for: " + file);
            }
            if (!parent.exists() || !parent.isDirectory()) {
                throw new IOException("Parent folder does not exist: " + file);
            }
            if (!parent.canRead()) {
                throw new IOException("Parent folder is not readable: " + file);
            }
            if (!readOnly && !parent.canWrite()) {
                throw new IOException("Parent folder is not writable: " + file);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean tryAvailable(long offset) {
            if (this.hasLimit && offset > this.sizeLimit) {
                return false;
            }
            if (offset % (long)this.chunkSize != 0L) {
                offset += (long)this.chunkSize - offset % (long)this.chunkSize;
            }
            if (offset > this.size) {
                Object object = this.growLock;
                synchronized (object) {
                    try {
                        this.channel.truncate(offset);
                        this.size = offset;
                    }
                    catch (IOException e) {
                        throw new IOError(e);
                    }
                }
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void truncate(long size) {
            Object object = this.growLock;
            synchronized (object) {
                try {
                    this.size = size;
                    this.channel.truncate(size);
                }
                catch (IOException e) {
                    throw new IOError(e);
                }
            }
        }

        protected void writeFully(long offset, ByteBuffer buf) throws IOException {
            int write;
            for (int remaining = buf.limit() - buf.position(); remaining > 0; remaining -= write) {
                write = this.channel.write(buf, offset);
                if (write >= 0) continue;
                throw new EOFException();
            }
        }

        @Override
        public final void putSixLong(long offset, long value) {
            assert (value >= 0L && value >>> 48 == 0L) : "value does not fit";
            try {
                ByteBuffer buf = ByteBuffer.allocate(6);
                buf.put(0, (byte)(0xFFL & value >> 40));
                buf.put(1, (byte)(0xFFL & value >> 32));
                buf.put(2, (byte)(0xFFL & value >> 24));
                buf.put(3, (byte)(0xFFL & value >> 16));
                buf.put(4, (byte)(0xFFL & value >> 8));
                buf.put(5, (byte)(0xFFL & value >> 0));
                this.writeFully(offset, buf);
            }
            catch (IOException e) {
                throw new IOError(e);
            }
        }

        @Override
        public void putLong(long offset, long value) {
            try {
                ByteBuffer buf = ByteBuffer.allocate(8);
                buf.putLong(0, value);
                this.writeFully(offset, buf);
            }
            catch (IOException e) {
                throw new IOError(e);
            }
        }

        @Override
        public void putInt(long offset, int value) {
            try {
                ByteBuffer buf = ByteBuffer.allocate(4);
                buf.putInt(0, value);
                this.writeFully(offset, buf);
            }
            catch (IOException e) {
                throw new IOError(e);
            }
        }

        @Override
        public void putByte(long offset, byte value) {
            try {
                ByteBuffer buf = ByteBuffer.allocate(1);
                buf.put(0, value);
                this.writeFully(offset, buf);
            }
            catch (IOException e) {
                throw new IOError(e);
            }
        }

        @Override
        public void putData(long offset, byte[] src, int srcPos, int srcSize) {
            try {
                ByteBuffer buf = ByteBuffer.wrap(src, srcPos, srcSize);
                this.writeFully(offset, buf);
            }
            catch (IOException e) {
                throw new IOError(e);
            }
        }

        @Override
        public void putData(long offset, ByteBuffer buf) {
            try {
                this.writeFully(offset, buf);
            }
            catch (IOException e) {
                throw new IOError(e);
            }
        }

        protected void readFully(long offset, ByteBuffer buf) throws IOException {
            int read;
            for (int remaining = buf.limit() - buf.position(); remaining > 0; remaining -= read) {
                read = this.channel.read(buf, offset);
                if (read >= 0) continue;
                throw new EOFException();
            }
        }

        @Override
        public final long getSixLong(long offset) {
            try {
                ByteBuffer buf = ByteBuffer.allocate(6);
                this.readFully(offset, buf);
                return (long)(buf.get(0) & 0xFF) << 40 | (long)(buf.get(1) & 0xFF) << 32 | (long)(buf.get(2) & 0xFF) << 24 | (long)(buf.get(3) & 0xFF) << 16 | (long)(buf.get(4) & 0xFF) << 8 | (long)(buf.get(5) & 0xFF) << 0;
            }
            catch (IOException e) {
                throw new IOError(e);
            }
        }

        @Override
        public long getLong(long offset) {
            try {
                ByteBuffer buf = ByteBuffer.allocate(8);
                this.readFully(offset, buf);
                return buf.getLong(0);
            }
            catch (IOException e) {
                throw new IOError(e);
            }
        }

        @Override
        public int getInt(long offset) {
            try {
                ByteBuffer buf = ByteBuffer.allocate(4);
                this.readFully(offset, buf);
                return buf.getInt(0);
            }
            catch (IOException e) {
                throw new IOError(e);
            }
        }

        @Override
        public byte getByte(long offset) {
            try {
                ByteBuffer buf = ByteBuffer.allocate(1);
                this.readFully(offset, buf);
                return buf.get(0);
            }
            catch (IOException e) {
                throw new IOError(e);
            }
        }

        @Override
        public DataInput2 getDataInput(long offset, int size) {
            try {
                ByteBuffer buf = ByteBuffer.allocate(size);
                this.readFully(offset, buf);
                return new DataInput2(buf, 0);
            }
            catch (IOException e) {
                throw new IOError(e);
            }
        }

        @Override
        public void close() {
            try {
                if (this.channel != null) {
                    this.channel.close();
                }
                this.channel = null;
                if (this.raf != null) {
                    this.raf.close();
                }
                this.raf = null;
            }
            catch (IOException e) {
                throw new IOError(e);
            }
        }

        @Override
        public void sync() {
            try {
                this.channel.force(true);
            }
            catch (IOException e) {
                throw new IOError(e);
            }
        }

        @Override
        public boolean isEmpty() {
            try {
                return this.channel == null || this.channel.size() == 0L;
            }
            catch (IOException e) {
                throw new IOError(e);
            }
        }

        @Override
        public void deleteFile() {
            this.file.delete();
        }

        @Override
        public boolean isSliced() {
            return false;
        }

        @Override
        public File getFile() {
            return this.file;
        }
    }

    public static final class MemoryVol
    extends ByteBufferVol {
        protected final boolean useDirectBuffer;

        public String toString() {
            return super.toString() + ",direct=" + this.useDirectBuffer;
        }

        public MemoryVol(boolean useDirectBuffer, long sizeLimit, int chunkShift) {
            super(false, sizeLimit, chunkShift);
            this.useDirectBuffer = useDirectBuffer;
        }

        @Override
        protected ByteBuffer makeNewBuffer(long offset) {
            return this.useDirectBuffer ? ByteBuffer.allocateDirect(this.chunkSize) : ByteBuffer.allocate(this.chunkSize);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void truncate(long size) {
            int maxSize = 1 + (int)(size >>> this.chunkShift);
            if (maxSize == this.chunks.length) {
                return;
            }
            if (maxSize > this.chunks.length) {
                this.ensureAvailable(size);
                return;
            }
            this.growLock.lock();
            try {
                if (maxSize >= this.chunks.length) {
                    return;
                }
                ByteBuffer[] old = this.chunks;
                this.chunks = Arrays.copyOf(this.chunks, maxSize);
                for (int i = maxSize; i < old.length; ++i) {
                    if (old[i] instanceof MappedByteBuffer) {
                        this.unmap((MappedByteBuffer)old[i]);
                    }
                    old[i] = null;
                }
            }
            finally {
                this.growLock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() {
            this.growLock.lock();
            try {
                for (ByteBuffer b : this.chunks) {
                    if (b == null || !(b instanceof MappedByteBuffer)) continue;
                    this.unmap((MappedByteBuffer)b);
                }
                this.chunks = null;
            }
            finally {
                this.growLock.unlock();
            }
        }

        @Override
        public void sync() {
        }

        @Override
        public void deleteFile() {
        }

        @Override
        public File getFile() {
            return null;
        }
    }

    public static final class MappedFileVol
    extends ByteBufferVol {
        protected final File file;
        protected final FileChannel fileChannel;
        protected final FileChannel.MapMode mapMode;
        protected final RandomAccessFile raf;

        public MappedFileVol(File file, boolean readOnly, long sizeLimit, int chunkShift, int sizeIncrement) {
            super(readOnly, sizeLimit, chunkShift);
            this.file = file;
            this.mapMode = readOnly ? FileChannel.MapMode.READ_ONLY : FileChannel.MapMode.READ_WRITE;
            try {
                FileChannelVol.checkFolder(file, readOnly);
                this.raf = new RandomAccessFile(file, readOnly ? "r" : "rw");
                this.fileChannel = this.raf.getChannel();
                long fileSize = this.fileChannel.size();
                if (fileSize > 0L) {
                    this.chunks = new ByteBuffer[(int)(fileSize >>> chunkShift)];
                    for (int i = 0; i < this.chunks.length; ++i) {
                        this.chunks[i] = this.makeNewBuffer(1L * (long)i * (long)this.chunkSize);
                    }
                } else {
                    this.chunks = new ByteBuffer[0];
                }
            }
            catch (IOException e) {
                throw new IOError(e);
            }
        }

        @Override
        public void close() {
            this.growLock.lock();
            try {
                this.fileChannel.close();
                this.raf.close();
                for (ByteBuffer b : this.chunks) {
                    if (b == null || !(b instanceof MappedByteBuffer)) continue;
                    this.unmap((MappedByteBuffer)b);
                }
                this.chunks = null;
            }
            catch (IOException e) {
                throw new IOError(e);
            }
            finally {
                this.growLock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void sync() {
            if (this.readOnly) {
                return;
            }
            this.growLock.lock();
            try {
                for (ByteBuffer b : this.chunks) {
                    if (b == null || !(b instanceof MappedByteBuffer)) continue;
                    MappedByteBuffer bb = (MappedByteBuffer)b;
                    bb.force();
                }
            }
            finally {
                this.growLock.unlock();
            }
        }

        @Override
        protected ByteBuffer makeNewBuffer(long offset) {
            try {
                assert ((offset & (long)this.chunkSizeModMask) == 0L);
                assert (offset >= 0L);
                ByteBuffer ret = this.fileChannel.map(this.mapMode, offset, this.chunkSize);
                if (this.mapMode == FileChannel.MapMode.READ_ONLY) {
                    ret = ret.asReadOnlyBuffer();
                }
                return ret;
            }
            catch (IOException e) {
                throw new IOError(e);
            }
        }

        @Override
        public void deleteFile() {
            this.file.delete();
        }

        @Override
        public File getFile() {
            return this.file;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void truncate(long size) {
            int maxSize = 1 + (int)(size >>> this.chunkShift);
            if (maxSize == this.chunks.length) {
                return;
            }
            if (maxSize > this.chunks.length) {
                this.ensureAvailable(size);
                return;
            }
            this.growLock.lock();
            try {
                int i;
                if (maxSize >= this.chunks.length) {
                    return;
                }
                ByteBuffer[] old = this.chunks;
                this.chunks = Arrays.copyOf(this.chunks, maxSize);
                for (i = maxSize; i < old.length; ++i) {
                    this.unmap((MappedByteBuffer)old[i]);
                    old[i] = null;
                }
                if (ByteBufferVol.windowsWorkaround) {
                    for (i = 0; i < maxSize; ++i) {
                        this.unmap((MappedByteBuffer)old[i]);
                        old[i] = null;
                    }
                }
                try {
                    this.fileChannel.truncate(1L * (long)this.chunkSize * (long)maxSize);
                }
                catch (IOException e) {
                    throw new IOError(e);
                }
                if (ByteBufferVol.windowsWorkaround) {
                    for (int pos = 0; pos < maxSize; ++pos) {
                        this.chunks[pos] = this.makeNewBuffer(1L * (long)this.chunkSize * (long)pos);
                    }
                }
            }
            finally {
                this.growLock.unlock();
            }
        }
    }

    public static abstract class ByteBufferVol
    extends Volume {
        protected final ReentrantLock growLock = new ReentrantLock(false);
        protected final long sizeLimit;
        protected final boolean hasLimit;
        protected final int chunkShift;
        protected final int chunkSizeModMask;
        protected final int chunkSize;
        protected volatile ByteBuffer[] chunks = new ByteBuffer[0];
        protected final boolean readOnly;
        private static boolean unmapHackSupported = true;
        private static boolean windowsWorkaround;

        protected ByteBufferVol(boolean readOnly, long sizeLimit, int chunkShift) {
            this.readOnly = readOnly;
            this.sizeLimit = sizeLimit;
            this.chunkShift = chunkShift;
            this.chunkSize = 1 << chunkShift;
            this.chunkSizeModMask = this.chunkSize - 1;
            this.hasLimit = sizeLimit > 0L;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final boolean tryAvailable(long offset) {
            if (this.hasLimit && offset > this.sizeLimit) {
                return false;
            }
            int chunkPos = (int)(offset >>> this.chunkShift);
            if (chunkPos < this.chunks.length) {
                return true;
            }
            this.growLock.lock();
            try {
                if (chunkPos < this.chunks.length) {
                    boolean bl = true;
                    return bl;
                }
                int oldSize = this.chunks.length;
                ByteBuffer[] chunks2 = this.chunks;
                chunks2 = Arrays.copyOf(chunks2, Math.max(chunkPos + 1, chunks2.length + chunks2.length / 1000));
                for (int pos = oldSize; pos < chunks2.length; ++pos) {
                    chunks2[pos] = this.makeNewBuffer(1L * (long)this.chunkSize * (long)pos);
                }
                this.chunks = chunks2;
            }
            finally {
                this.growLock.unlock();
            }
            return true;
        }

        protected abstract ByteBuffer makeNewBuffer(long var1);

        @Override
        public final void putLong(long offset, long value) {
            this.chunks[(int)(offset >>> this.chunkShift)].putLong((int)(offset & (long)this.chunkSizeModMask), value);
        }

        @Override
        public final void putInt(long offset, int value) {
            this.chunks[(int)(offset >>> this.chunkShift)].putInt((int)(offset & (long)this.chunkSizeModMask), value);
        }

        @Override
        public final void putByte(long offset, byte value) {
            this.chunks[(int)(offset >>> this.chunkShift)].put((int)(offset & (long)this.chunkSizeModMask), value);
        }

        @Override
        public void putData(long offset, byte[] src, int srcPos, int srcSize) {
            ByteBuffer b1 = this.chunks[(int)(offset >>> this.chunkShift)].duplicate();
            int bufPos = (int)(offset & (long)this.chunkSizeModMask);
            b1.position(bufPos);
            b1.put(src, srcPos, srcSize);
        }

        @Override
        public final void putData(long offset, ByteBuffer buf) {
            ByteBuffer b1 = this.chunks[(int)(offset >>> this.chunkShift)].duplicate();
            int bufPos = (int)(offset & (long)this.chunkSizeModMask);
            b1.position(bufPos);
            b1.put(buf);
        }

        @Override
        public final long getLong(long offset) {
            return this.chunks[(int)(offset >>> this.chunkShift)].getLong((int)(offset & (long)this.chunkSizeModMask));
        }

        @Override
        public final int getInt(long offset) {
            return this.chunks[(int)(offset >>> this.chunkShift)].getInt((int)(offset & (long)this.chunkSizeModMask));
        }

        @Override
        public final byte getByte(long offset) {
            return this.chunks[(int)(offset >>> this.chunkShift)].get((int)(offset & (long)this.chunkSizeModMask));
        }

        @Override
        public final DataInput2 getDataInput(long offset, int size) {
            return new DataInput2(this.chunks[(int)(offset >>> this.chunkShift)], (int)(offset & (long)this.chunkSizeModMask));
        }

        @Override
        public boolean isEmpty() {
            return this.chunks.length == 0;
        }

        @Override
        public boolean isSliced() {
            return true;
        }

        protected void unmap(MappedByteBuffer b) {
            try {
                Method cleanerMethod;
                if (unmapHackSupported && (cleanerMethod = b.getClass().getMethod("cleaner", new Class[0])) != null) {
                    Method clearMethod;
                    cleanerMethod.setAccessible(true);
                    Object cleaner = cleanerMethod.invoke((Object)b, new Object[0]);
                    if (cleaner != null && (clearMethod = cleaner.getClass().getMethod("clean", new Class[0])) != null) {
                        clearMethod.invoke(cleaner, new Object[0]);
                    }
                }
            }
            catch (Exception e) {
                unmapHackSupported = false;
            }
        }

        static {
            try {
                unmapHackSupported = SerializerPojo.classForName("sun.nio.ch.DirectBuffer") != null;
            }
            catch (Exception e) {
                unmapHackSupported = false;
            }
            windowsWorkaround = System.getProperty("os.name").toLowerCase().startsWith("win");
        }
    }

    public static interface Factory {
        public Volume createIndexVolume();

        public Volume createPhysVolume();

        public Volume createTransLogVolume();
    }
}

