/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ldap.repository.support;

import com.mysema.query.DefaultQueryMetadata;
import com.mysema.query.FilteredClause;
import com.mysema.query.QueryMetadata;
import com.mysema.query.support.QueryMixin;
import com.mysema.query.types.EntityPath;
import com.mysema.query.types.Expression;
import com.mysema.query.types.Predicate;
import java.util.List;
import org.springframework.ldap.core.LdapOperations;
import org.springframework.ldap.query.LdapQuery;
import org.springframework.ldap.query.LdapQueryBuilder;
import org.springframework.ldap.repository.support.LdapSerializer;

public class QueryDslLdapQuery<K>
implements FilteredClause<QueryDslLdapQuery<K>> {
    private final LdapOperations ldapOperations;
    private final Class<? extends K> clazz;
    private QueryMixin<QueryDslLdapQuery<K>> queryMixin = new QueryMixin((Object)this, (QueryMetadata)new DefaultQueryMetadata().noValidate());
    private final LdapSerializer filterGenerator;

    public QueryDslLdapQuery(LdapOperations ldapOperations, EntityPath<K> entityPath) {
        this(ldapOperations, entityPath.getType());
    }

    public QueryDslLdapQuery(LdapOperations ldapOperations, Class<K> clazz) {
        this.ldapOperations = ldapOperations;
        this.clazz = clazz;
        this.filterGenerator = new LdapSerializer(ldapOperations.getObjectDirectoryMapper(), clazz);
    }

    public QueryDslLdapQuery<K> where(Predicate ... o) {
        return (QueryDslLdapQuery)this.queryMixin.where(o);
    }

    public List<K> list() {
        return this.ldapOperations.find(this.buildQuery(), this.clazz);
    }

    public K uniqueResult() {
        return this.ldapOperations.findOne(this.buildQuery(), this.clazz);
    }

    LdapQuery buildQuery() {
        return LdapQueryBuilder.query().filter(this.filterGenerator.handle((Expression<?>)this.queryMixin.getMetadata().getWhere()));
    }
}

