/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xltype.serialization.json;

import com.xebialabs.deployit.engine.api.dto.ConfigurationItemId;
import com.xebialabs.deployit.engine.api.dto.Deployment;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.xltype.serialization.ConfigurationItemConverter;
import com.xebialabs.xltype.serialization.json.CiJsonReader;
import com.xebialabs.xltype.serialization.json.CiJsonWriter;
import com.xebialabs.xltype.serialization.json.CiListJsonReader;
import com.xebialabs.xltype.serialization.json.Converters;
import com.xebialabs.xltype.serialization.json.JsonWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;

public class DeploymentJsonConverter {
    private final ConfigurationItemConverter ciConverter;

    public DeploymentJsonConverter(ConfigurationItemConverter converter) {
        this.ciConverter = converter;
    }

    public ConfigurationItemConverter getCiConverter() {
        return this.ciConverter;
    }

    public String toJson(Deployment deployment) {
        JsonWriter writer = new JsonWriter();
        this.toJson(deployment, writer);
        return writer.toString();
    }

    public void toJson(Deployment deployment, JsonWriter writer) {
        CiJsonWriter ciWriter = new CiJsonWriter(writer);
        writer.object();
        if (deployment.getId() != null) {
            writer.key("id").value(deployment.getId());
        }
        writer.key("type").value(deployment.getDeploymentType());
        writer.key("missingPlaceholders").value(deployment.getMissingPlaceholders());
        writer.key("application");
        this.ciConverter.writeCi(deployment.getDeployedApplication(), ciWriter);
        writer.key("deployeds");
        this.ciConverter.writeCis(deployment.getDeployeds(), ciWriter);
        writer.key("deployables");
        ciWriter.typedCiReferences(deployment.getDeployables());
        writer.key("containers");
        ciWriter.typedCiReferences(deployment.getContainers());
        writer.endObject();
    }

    public Deployment toDeployment(String jsonString) {
        try {
            JSONObject json = new JSONObject(jsonString);
            return this.toDeployment(json);
        }
        catch (JSONException e) {
            throw new IllegalArgumentException("Can't parse JSON:\n" + jsonString, e);
        }
    }

    public Deployment toDeployment(JSONObject json) throws JSONException {
        String jsonString = json.toString();
        Converters.checkArgument(json.has("type"), "Missing 'type' property in JSON:\n%s", jsonString);
        Converters.checkArgument(json.has("application"), "Missing 'application' property in JSON:\n%s", jsonString);
        Converters.checkArgument(json.has("deployeds"), "Missing 'deployeds' property in JSON:\n%s", jsonString);
        Deployment deployment = new Deployment();
        if (json.has("id")) {
            deployment.setId(json.getString("id"));
        }
        Deployment.DeploymentType type = Deployment.DeploymentType.valueOf((String)json.getString("type"));
        deployment.setDeploymentType(type);
        ConfigurationItem application = this.ciConverter.readCi(new CiJsonReader(json.getJSONObject("application")));
        deployment.setDeployedApplication(application);
        List<ConfigurationItem> deployeds = this.ciConverter.readCis(new CiListJsonReader(json.getJSONArray("deployeds")));
        deployment.setDeployeds(deployeds);
        deployment.setDeployables(DeploymentJsonConverter.toConfigurationItemIds(json.getJSONArray("deployables")));
        deployment.setContainers(DeploymentJsonConverter.toConfigurationItemIds(json.getJSONArray("containers")));
        if (json.has("missingPlaceholders")) {
            HashMap<String, String> missingPlaceholders = this.jsonObjectToMap(json.getJSONObject("missingPlaceholders"));
            deployment.setMissingPlaceholders(missingPlaceholders);
        }
        return deployment;
    }

    private HashMap<String, String> jsonObjectToMap(JSONObject missingPlaceholders) throws JSONException {
        HashMap<String, String> map = new HashMap<String, String>();
        Iterator it = missingPlaceholders.keys();
        while (it.hasNext()) {
            String key = (String)it.next();
            map.put(key, (String)missingPlaceholders.get(key));
        }
        return map;
    }

    private static List<ConfigurationItemId> toConfigurationItemIds(JSONArray jsonArray) throws JSONException {
        ArrayList<ConfigurationItemId> ids = new ArrayList<ConfigurationItemId>();
        for (int i = 0; i < jsonArray.length(); ++i) {
            ids.add(DeploymentJsonConverter.toConfigurationItemId(jsonArray.getJSONObject(i)));
        }
        return ids;
    }

    private static ConfigurationItemId toConfigurationItemId(JSONObject jsonObject) throws JSONException {
        return new ConfigurationItemId(jsonObject.getString("ci"), Type.valueOf((String)jsonObject.getString("type")));
    }
}

