/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.common.collection.ring;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.modeshape.common.collection.ring.Cursor;
import org.modeshape.common.collection.ring.DependentOnPointers;
import org.modeshape.common.collection.ring.Pointer;
import org.modeshape.common.collection.ring.PointerBarrier;
import org.modeshape.common.collection.ring.TrailingPointer;
import org.modeshape.common.collection.ring.WaitStrategy;

public class GarbageCollectingConsumer
implements Runnable,
AutoCloseable,
DependentOnPointers {
    private final Cursor cursor;
    private final PointerBarrier gcBarrier;
    private final Pointer pointer;
    protected final TrailingPointer trailingPointer;
    private final AtomicBoolean runThread = new AtomicBoolean(true);
    private final CountDownLatch stopLatch = new CountDownLatch(1);
    private final Collectable collectable;

    public GarbageCollectingConsumer(final Cursor cursor, Pointer cursorPointer, final WaitStrategy waitStrategy, Collectable collectable) {
        this.cursor = cursor;
        this.pointer = new Pointer();
        this.trailingPointer = new TrailingPointer(cursorPointer);
        this.cursor.stayBehind(this.pointer);
        this.collectable = collectable;
        this.gcBarrier = new PointerBarrier(){
            private volatile boolean closed = false;

            @Override
            public long waitFor(long position) throws InterruptedException, TimeoutException {
                if (cursor.isComplete()) {
                    return -1L;
                }
                long availableSequence = waitStrategy.waitFor(position, GarbageCollectingConsumer.this.trailingPointer, GarbageCollectingConsumer.this.trailingPointer, this);
                if (availableSequence < position) {
                    return availableSequence;
                }
                return cursor.getHighestPublishedPosition(position, availableSequence);
            }

            @Override
            public boolean isComplete() {
                return this.closed || cursor.isComplete();
            }

            @Override
            public void close() {
                this.closed = true;
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        block25: {
            block20: while (true) {
                block24: {
                    try {
                        while (this.runThread.get()) {
                            next = this.pointer.get() + 1L;
                            try {
                                maxPosition = this.gcBarrier.waitFor(next);
lbl7:
                                // 2 sources

                                while (next <= maxPosition) {
                                    this.collectable.collect(next);
                                    if (!this.runThread.get()) {
                                        break block24;
                                    }
                                    ** GOTO lbl-1000
                                }
                                continue block20;
                            }
                            catch (TimeoutException e) {
                            }
                            catch (InterruptedException e) {
                                Thread.interrupted();
                                break block25;
                            }
                            catch (RuntimeException e) {
                                this.pointer.incrementAndGet();
                            }
                        }
                        break block25;
                    }
                    catch (Throwable var8_9) {
                        try {
                            this.cursor.ignore(this.pointer);
                            throw var8_9;
                        }
                        finally {
                            this.stopLatch.countDown();
                        }
                    }
                }
                try {
                    this.cursor.ignore(this.pointer);
                    return;
                }
                finally {
                    this.stopLatch.countDown();
                }
lbl-1000:
                // 1 sources

                {
                    next = this.pointer.incrementAndGet() + 1L;
                    ** GOTO lbl7
                    if (maxPosition >= 0L) continue;
                }
                break;
            }
            try {
                this.cursor.ignore(this.pointer);
                return;
            }
            finally {
                this.stopLatch.countDown();
            }
        }
        try {
            this.cursor.ignore(this.pointer);
            return;
        }
        finally {
            this.stopLatch.countDown();
        }
    }

    @Override
    public void close() {
        if (this.runThread.compareAndSet(true, false)) {
            try {
                this.stopLatch.await();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    @Override
    public boolean ignore(Pointer pointer) {
        return this.trailingPointer.ignore(pointer);
    }

    @Override
    public void stayBehind(Pointer ... pointers) {
        this.trailingPointer.stayBehind(pointers);
    }

    public static interface Collectable {
        public void collect(long var1);
    }
}

