/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.common.util;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.modeshape.common.SystemFailureException;
import org.modeshape.common.annotation.Immutable;
import org.modeshape.common.util.CheckArg;
import org.modeshape.common.util.StringUtil;

@Immutable
public class SecureHash {
    public static byte[] getHash(Algorithm algorithm, byte[] content) throws NoSuchAlgorithmException {
        CheckArg.isNotNull((Object)algorithm, "algorithm");
        return SecureHash.getHash(algorithm.digestName(), content);
    }

    public static byte[] getHash(Algorithm algorithm, File file) throws NoSuchAlgorithmException, IOException {
        CheckArg.isNotNull((Object)algorithm, "algorithm");
        return SecureHash.getHash(algorithm.digestName(), file);
    }

    public static byte[] getHash(Algorithm algorithm, InputStream stream) throws NoSuchAlgorithmException, IOException {
        CheckArg.isNotNull((Object)algorithm, "algorithm");
        return SecureHash.getHash(algorithm.digestName(), stream);
    }

    public static byte[] getHash(String digestName, byte[] content) throws NoSuchAlgorithmException {
        MessageDigest digest = MessageDigest.getInstance(digestName);
        assert (digest != null);
        return digest.digest(content);
    }

    public static byte[] getHash(String digestName, File file) throws NoSuchAlgorithmException, IOException {
        CheckArg.isNotNull(file, "file");
        MessageDigest digest = MessageDigest.getInstance(digestName);
        assert (digest != null);
        BufferedInputStream in = new BufferedInputStream(new FileInputStream(file));
        boolean error = false;
        try {
            int bufSize = 1024;
            byte[] buffer = new byte[bufSize];
            int n = ((InputStream)in).read(buffer, 0, bufSize);
            while (n != -1) {
                digest.update(buffer, 0, n);
                n = ((InputStream)in).read(buffer, 0, bufSize);
            }
        }
        catch (IOException e) {
            error = true;
            throw e;
        }
        finally {
            block12: {
                try {
                    ((InputStream)in).close();
                }
                catch (IOException e) {
                    if (error) break block12;
                    throw e;
                }
            }
        }
        return digest.digest();
    }

    public static byte[] getHash(String digestName, InputStream stream) throws NoSuchAlgorithmException, IOException {
        CheckArg.isNotNull(stream, "stream");
        MessageDigest digest = MessageDigest.getInstance(digestName);
        assert (digest != null);
        int bufSize = 1024;
        byte[] buffer = new byte[bufSize];
        int n = stream.read(buffer, 0, bufSize);
        while (n != -1) {
            digest.update(buffer, 0, n);
            n = stream.read(buffer, 0, bufSize);
        }
        return digest.digest();
    }

    public static HashingInputStream createHashingStream(Algorithm algorithm, InputStream inputStream) throws NoSuchAlgorithmException {
        return SecureHash.createHashingStream(algorithm.digestName(), inputStream);
    }

    public static HashingInputStream createHashingStream(String digestName, InputStream inputStream) throws NoSuchAlgorithmException {
        MessageDigest digest = MessageDigest.getInstance(digestName);
        return new HashingInputStream(digest, inputStream);
    }

    public static HashingReader createHashingReader(Algorithm algorithm, Reader reader, Charset charset) throws NoSuchAlgorithmException {
        return SecureHash.createHashingReader(algorithm.digestName(), reader, charset);
    }

    public static HashingReader createHashingReader(String digestName, Reader reader, Charset charset) throws NoSuchAlgorithmException {
        MessageDigest digest = MessageDigest.getInstance(digestName);
        return new HashingReader(digest, reader, charset);
    }

    public static String asHexString(byte[] hash) {
        return hash != null ? StringUtil.getHexString(hash) : null;
    }

    public static String sha1(String string) {
        try {
            byte[] sha1 = SecureHash.getHash(Algorithm.SHA_1, string.getBytes());
            return SecureHash.asHexString(sha1);
        }
        catch (NoSuchAlgorithmException e) {
            throw new SystemFailureException(e);
        }
    }

    private SecureHash() {
    }

    public static class HashingReader
    extends Reader {
        private final MessageDigest digest;
        private final Reader stream;
        private byte[] hash;
        private final CharsetEncoder encoder;

        protected HashingReader(MessageDigest digest, Reader input, Charset charset) {
            this.digest = digest;
            this.stream = input;
            this.encoder = charset.newEncoder();
        }

        @Override
        public int read() throws IOException {
            int result = this.stream.read();
            if (result != -1) {
                this.digest.update((byte)result);
            }
            return result;
        }

        @Override
        public int read(char[] b, int off, int len) throws IOException {
            int n = this.stream.read(b, off, len);
            if (n != -1) {
                byte[] bytes = this.encoder.encode(CharBuffer.wrap(b)).array();
                this.digest.update(bytes, off, n);
            }
            return n;
        }

        @Override
        public int read(char[] b) throws IOException {
            int n = this.stream.read(b);
            if (n != -1) {
                byte[] bytes = this.encoder.encode(CharBuffer.wrap(b)).array();
                this.digest.update(bytes, 0, n);
            }
            return n;
        }

        @Override
        public void close() throws IOException {
            this.stream.close();
            if (this.hash == null) {
                this.hash = this.digest.digest();
            }
        }

        public byte[] getHash() {
            return this.hash;
        }

        public String getHashAsHexString() {
            return SecureHash.asHexString(this.hash);
        }
    }

    public static class HashingInputStream
    extends InputStream {
        private final MessageDigest digest;
        private final InputStream stream;
        private byte[] hash;

        protected HashingInputStream(MessageDigest digest, InputStream input) {
            this.digest = digest;
            this.stream = input;
        }

        @Override
        public int read() throws IOException {
            int result = this.stream.read();
            if (result != -1) {
                this.digest.update((byte)result);
            }
            return result;
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            int n = this.stream.read(b, off, len);
            if (n != -1) {
                this.digest.update(b, off, n);
            }
            return n;
        }

        @Override
        public int read(byte[] b) throws IOException {
            int n = this.stream.read(b);
            if (n != -1) {
                this.digest.update(b, 0, n);
            }
            return n;
        }

        @Override
        public void close() throws IOException {
            this.stream.close();
            if (this.hash == null) {
                this.hash = this.digest.digest();
            }
        }

        public byte[] getHash() {
            return this.hash;
        }

        public String getHashAsHexString() {
            return SecureHash.asHexString(this.hash);
        }
    }

    @Immutable
    public static final class Algorithm
    extends Enum<Algorithm> {
        public static final /* enum */ Algorithm MD2 = new Algorithm("MD2", 128, "The MD2 message digest algorithm as defined in RFC 1319");
        public static final /* enum */ Algorithm MD5 = new Algorithm("MD5", 128, "The MD5 message digest algorithm as defined in RFC 1321");
        public static final /* enum */ Algorithm SHA_1 = new Algorithm("SHA-1", 160, "The Secure Hash Algorithm, as defined in Secure Hash Standard, NIST FIPS 180-1");
        public static final /* enum */ Algorithm SHA_256 = new Algorithm("SHA-256", 256, "New hash algorithms for which the draft Federal Information Processing Standard 180-2, Secure Hash Standard (SHS) is now available.  SHA-256 is a 256-bit hash function intended to provide 128 bits of security against collision attacks.");
        public static final /* enum */ Algorithm SHA_384 = new Algorithm("SHA-384", 384, "New hash algorithms for which the draft Federal Information Processing Standard 180-2, Secure Hash Standard (SHS) is now available.  A 384-bit hash may be obtained by truncating the SHA-512 output.");
        public static final /* enum */ Algorithm SHA_512 = new Algorithm("SHA-512", 512, "New hash algorithms for which the draft Federal Information Processing Standard 180-2, Secure Hash Standard (SHS) is now available.  SHA-512 is a 512-bit hash function intended to provide 256 bits of security.");
        private final String name;
        private final String description;
        private final int numberOfBits;
        private final int numberOfBytes;
        private final int numberOfHexChars;
        private static final /* synthetic */ Algorithm[] $VALUES;

        public static Algorithm[] values() {
            return (Algorithm[])$VALUES.clone();
        }

        public static Algorithm valueOf(String name) {
            return Enum.valueOf(Algorithm.class, name);
        }

        private Algorithm(String name, int numberOfBits, String description) {
            assert (numberOfBits % 8 == 0);
            this.name = name;
            this.description = description;
            this.numberOfBits = numberOfBits;
            this.numberOfBytes = this.numberOfBits / 8;
            this.numberOfHexChars = this.numberOfBits / 4;
        }

        public String digestName() {
            return this.name;
        }

        public String description() {
            return this.description;
        }

        public int getHexadecimalStringLength() {
            return this.numberOfHexChars;
        }

        public boolean isHexadecimal(String string) {
            return string.length() == this.getHexadecimalStringLength() && StringUtil.isHexString(string);
        }

        public int getNumberOfBytes() {
            return this.numberOfBytes;
        }

        public int getNumberOfBits() {
            return this.numberOfBits;
        }

        public String toString() {
            return this.digestName();
        }

        static {
            $VALUES = new Algorithm[]{MD2, MD5, SHA_1, SHA_256, SHA_384, SHA_512};
        }
    }
}

