/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.cluster.node.info;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.elasticsearch.action.admin.cluster.node.info.PluginInfo;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Streamable;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentBuilderString;

public class PluginsInfo
implements Streamable,
Serializable,
ToXContent {
    private List<PluginInfo> infos;

    public PluginsInfo() {
        this.infos = new ArrayList<PluginInfo>();
    }

    public PluginsInfo(int size) {
        this.infos = new ArrayList<PluginInfo>(size);
    }

    public List<PluginInfo> getInfos() {
        return this.infos;
    }

    public void add(PluginInfo info) {
        this.infos.add(info);
    }

    public static PluginsInfo readPluginsInfo(StreamInput in) throws IOException {
        PluginsInfo infos = new PluginsInfo();
        infos.readFrom(in);
        return infos;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        int plugins_size = in.readInt();
        for (int i = 0; i < plugins_size; ++i) {
            this.infos.add(PluginInfo.readPluginInfo(in));
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeInt(this.infos.size());
        for (PluginInfo plugin : this.infos) {
            plugin.writeTo(out);
        }
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startArray(Fields.PLUGINS);
        for (PluginInfo pluginInfo : this.infos) {
            pluginInfo.toXContent(builder, params);
        }
        builder.endArray();
        return builder;
    }

    static final class Fields {
        static final XContentBuilderString PLUGINS = new XContentBuilderString("plugins");

        Fields() {
        }
    }
}

