/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.cluster.snapshots.status;

import java.io.IOException;
import org.elasticsearch.ElasticsearchIllegalArgumentException;
import org.elasticsearch.action.admin.cluster.snapshots.status.SnapshotIndexShardStage;
import org.elasticsearch.action.admin.cluster.snapshots.status.SnapshotStats;
import org.elasticsearch.action.support.broadcast.BroadcastShardOperationResponse;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentBuilderString;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.index.snapshots.IndexShardSnapshotStatus;

public class SnapshotIndexShardStatus
extends BroadcastShardOperationResponse
implements ToXContent {
    private SnapshotIndexShardStage stage = SnapshotIndexShardStage.INIT;
    private SnapshotStats stats;
    private String nodeId;
    private String failure;

    private SnapshotIndexShardStatus() {
    }

    SnapshotIndexShardStatus(ShardId shardId, SnapshotIndexShardStage stage) {
        super(shardId);
        this.stage = stage;
        this.stats = new SnapshotStats();
    }

    SnapshotIndexShardStatus(ShardId shardId, IndexShardSnapshotStatus indexShardStatus) {
        this(shardId, indexShardStatus, null);
    }

    SnapshotIndexShardStatus(ShardId shardId, IndexShardSnapshotStatus indexShardStatus, String nodeId) {
        super(shardId);
        switch (indexShardStatus.stage()) {
            case INIT: {
                this.stage = SnapshotIndexShardStage.INIT;
                break;
            }
            case STARTED: {
                this.stage = SnapshotIndexShardStage.STARTED;
                break;
            }
            case FINALIZE: {
                this.stage = SnapshotIndexShardStage.FINALIZE;
                break;
            }
            case DONE: {
                this.stage = SnapshotIndexShardStage.DONE;
                break;
            }
            case FAILURE: {
                this.stage = SnapshotIndexShardStage.FAILURE;
                break;
            }
            default: {
                throw new ElasticsearchIllegalArgumentException("Unknown stage type " + (Object)((Object)indexShardStatus.stage()));
            }
        }
        this.stats = new SnapshotStats(indexShardStatus);
        this.failure = indexShardStatus.failure();
        this.nodeId = nodeId;
    }

    public SnapshotIndexShardStage getStage() {
        return this.stage;
    }

    public SnapshotStats getStats() {
        return this.stats;
    }

    public String getNodeId() {
        return this.nodeId;
    }

    public String getFailure() {
        return this.failure;
    }

    public static SnapshotIndexShardStatus readShardSnapshotStatus(StreamInput in) throws IOException {
        SnapshotIndexShardStatus shardStatus = new SnapshotIndexShardStatus();
        shardStatus.readFrom(in);
        return shardStatus;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeByte(this.stage.value());
        this.stats.writeTo(out);
        out.writeOptionalString(this.nodeId);
        out.writeOptionalString(this.failure);
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.stage = SnapshotIndexShardStage.fromValue(in.readByte());
        this.stats = SnapshotStats.readSnapshotStats(in);
        this.nodeId = in.readOptionalString();
        this.failure = in.readOptionalString();
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(Integer.toString(this.getShardId()));
        builder.field(Fields.STAGE, (Object)this.getStage());
        this.stats.toXContent(builder, params);
        if (this.getNodeId() != null) {
            builder.field(Fields.NODE, this.getNodeId());
        }
        if (this.getFailure() != null) {
            builder.field(Fields.REASON, this.getFailure());
        }
        builder.endObject();
        return builder;
    }

    static final class Fields {
        static final XContentBuilderString STAGE = new XContentBuilderString("stage");
        static final XContentBuilderString REASON = new XContentBuilderString("reason");
        static final XContentBuilderString NODE = new XContentBuilderString("node");

        Fields() {
        }
    }
}

