/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.optimize;

import java.io.IOException;
import org.elasticsearch.Version;
import org.elasticsearch.action.admin.indices.optimize.OptimizeRequest;
import org.elasticsearch.action.support.broadcast.BroadcastShardOperationRequest;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.index.shard.ShardId;

class ShardOptimizeRequest
extends BroadcastShardOperationRequest {
    private int maxNumSegments = -1;
    private boolean onlyExpungeDeletes = false;
    private boolean flush = true;
    private boolean force = false;

    ShardOptimizeRequest() {
    }

    ShardOptimizeRequest(ShardId shardId, OptimizeRequest request) {
        super(shardId, request);
        this.maxNumSegments = request.maxNumSegments();
        this.onlyExpungeDeletes = request.onlyExpungeDeletes();
        this.flush = request.flush();
        this.force = request.force();
    }

    int maxNumSegments() {
        return this.maxNumSegments;
    }

    public boolean onlyExpungeDeletes() {
        return this.onlyExpungeDeletes;
    }

    public boolean flush() {
        return this.flush;
    }

    public boolean force() {
        return this.force;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        if (in.getVersion().before(Version.V_1_5_0)) {
            in.readBoolean();
        }
        this.maxNumSegments = in.readInt();
        this.onlyExpungeDeletes = in.readBoolean();
        this.flush = in.readBoolean();
        if (in.getVersion().onOrAfter(Version.V_1_1_0)) {
            this.force = in.readBoolean();
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        if (out.getVersion().before(Version.V_1_5_0)) {
            out.writeBoolean(true);
        }
        out.writeInt(this.maxNumSegments);
        out.writeBoolean(this.onlyExpungeDeletes);
        out.writeBoolean(this.flush);
        if (out.getVersion().onOrAfter(Version.V_1_1_0)) {
            out.writeBoolean(this.force);
        }
    }
}

