/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.count;

import java.io.IOException;
import org.elasticsearch.Version;
import org.elasticsearch.action.support.broadcast.BroadcastShardOperationResponse;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.index.shard.ShardId;

class ShardCountResponse
extends BroadcastShardOperationResponse {
    private long count;
    private boolean terminatedEarly;

    ShardCountResponse() {
    }

    ShardCountResponse(ShardId shardId, long count, boolean terminatedEarly) {
        super(shardId);
        this.count = count;
        this.terminatedEarly = terminatedEarly;
    }

    public long getCount() {
        return this.count;
    }

    public boolean terminatedEarly() {
        return this.terminatedEarly;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.count = in.readVLong();
        if (in.getVersion().onOrAfter(Version.V_1_4_0_Beta1)) {
            this.terminatedEarly = in.readBoolean();
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeVLong(this.count);
        if (out.getVersion().onOrAfter(Version.V_1_4_0_Beta1)) {
            out.writeBoolean(this.terminatedEarly);
        }
    }
}

