/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.node;

import java.util.Map;
import org.elasticsearch.action.Action;
import org.elasticsearch.action.ActionFuture;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestBuilder;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.ClientAction;
import org.elasticsearch.action.GenericAction;
import org.elasticsearch.action.support.TransportAction;
import org.elasticsearch.client.AdminClient;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.node.NodeAdminClient;
import org.elasticsearch.client.support.AbstractClient;
import org.elasticsearch.client.support.Headers;
import org.elasticsearch.common.collect.ImmutableMap;
import org.elasticsearch.common.collect.MapBuilder;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.threadpool.ThreadPool;

public class NodeClient
extends AbstractClient {
    private final Settings settings;
    private final ThreadPool threadPool;
    private final NodeAdminClient admin;
    private final ImmutableMap<ClientAction, TransportAction> actions;
    private final Headers headers;

    @Inject
    public NodeClient(Settings settings, ThreadPool threadPool, NodeAdminClient admin, Map<GenericAction, TransportAction> actions, Headers headers) {
        this.settings = settings;
        this.threadPool = threadPool;
        this.admin = admin;
        this.headers = headers;
        MapBuilder<ClientAction, TransportAction> actionsBuilder = new MapBuilder<ClientAction, TransportAction>();
        for (Map.Entry<GenericAction, TransportAction> entry : actions.entrySet()) {
            if (!(entry.getKey() instanceof ClientAction)) continue;
            actionsBuilder.put((ClientAction)entry.getKey(), entry.getValue());
        }
        this.actions = actionsBuilder.immutableMap();
    }

    @Override
    public Settings settings() {
        return this.settings;
    }

    @Override
    public ThreadPool threadPool() {
        return this.threadPool;
    }

    @Override
    public void close() {
    }

    @Override
    public AdminClient admin() {
        return this.admin;
    }

    @Override
    public <Request extends ActionRequest, Response extends ActionResponse, RequestBuilder extends ActionRequestBuilder<Request, Response, RequestBuilder, Client>> ActionFuture<Response> execute(Action<Request, Response, RequestBuilder, Client> action, Request request) {
        this.headers.applyTo(request);
        TransportAction transportAction = this.actions.get((ClientAction)action);
        return transportAction.execute(request);
    }

    @Override
    public <Request extends ActionRequest, Response extends ActionResponse, RequestBuilder extends ActionRequestBuilder<Request, Response, RequestBuilder, Client>> void execute(Action<Request, Response, RequestBuilder, Client> action, Request request, ActionListener<Response> listener) {
        this.headers.applyTo(request);
        TransportAction transportAction = this.actions.get((ClientAction)action);
        transportAction.execute(request, listener);
    }
}

