/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.routing.allocation.command;

import java.io.IOException;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ElasticsearchIllegalArgumentException;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.routing.MutableShardRouting;
import org.elasticsearch.cluster.routing.RoutingNode;
import org.elasticsearch.cluster.routing.RoutingNodes;
import org.elasticsearch.cluster.routing.ShardRoutingState;
import org.elasticsearch.cluster.routing.UnassignedInfo;
import org.elasticsearch.cluster.routing.allocation.RerouteExplanation;
import org.elasticsearch.cluster.routing.allocation.RoutingAllocation;
import org.elasticsearch.cluster.routing.allocation.command.AllocationCommand;
import org.elasticsearch.cluster.routing.allocation.decider.Decision;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.shard.ShardId;

public class CancelAllocationCommand
implements AllocationCommand {
    public static final String NAME = "cancel";
    private final ShardId shardId;
    private final String node;
    private final boolean allowPrimary;

    public CancelAllocationCommand(ShardId shardId, String node, boolean allowPrimary) {
        this.shardId = shardId;
        this.node = node;
        this.allowPrimary = allowPrimary;
    }

    @Override
    public String name() {
        return NAME;
    }

    public ShardId shardId() {
        return this.shardId;
    }

    public String node() {
        return this.node;
    }

    public boolean allowPrimary() {
        return this.allowPrimary;
    }

    @Override
    public RerouteExplanation execute(RoutingAllocation allocation, boolean explain) throws ElasticsearchException {
        DiscoveryNode discoNode = allocation.nodes().resolveNode(this.node);
        boolean found = false;
        RoutingNodes.RoutingNodeIterator it = allocation.routingNodes().routingNodeIter(discoNode.id());
        block0: while (it.hasNext()) {
            MutableShardRouting shardRouting = it.next();
            if (!shardRouting.shardId().equals(this.shardId)) continue;
            found = true;
            if (shardRouting.relocatingNodeId() != null) {
                if (shardRouting.initializing()) {
                    it.remove();
                    RoutingNode relocatingFromNode = allocation.routingNodes().node(shardRouting.relocatingNodeId());
                    if (relocatingFromNode == null) continue;
                    for (MutableShardRouting fromShardRouting : relocatingFromNode) {
                        if (!fromShardRouting.shardId().equals(shardRouting.shardId()) || fromShardRouting.state() != ShardRoutingState.RELOCATING) continue;
                        allocation.routingNodes().cancelRelocation(fromShardRouting);
                        continue block0;
                    }
                    continue;
                }
                if (!shardRouting.relocating()) continue;
                if (!this.allowPrimary && shardRouting.primary()) {
                    if (explain) {
                        return new RerouteExplanation(this, allocation.decision(Decision.NO, "cancel_allocation_command", "can't cancel " + this.shardId + " on node " + discoNode + ", shard is primary and initializing its state", new Object[0]));
                    }
                    throw new ElasticsearchIllegalArgumentException("[cancel_allocation] can't cancel " + this.shardId + " on node " + discoNode + ", shard is primary and initializing its state");
                }
                it.moveToUnassigned(new UnassignedInfo(UnassignedInfo.Reason.REROUTE_CANCELLED, null));
                RoutingNodes.RoutingNodeIterator initializingNode = allocation.routingNodes().routingNodeIter(shardRouting.relocatingNodeId());
                if (initializingNode == null) continue;
                while (initializingNode.hasNext()) {
                    MutableShardRouting initializingShardRouting = initializingNode.next();
                    if (!initializingShardRouting.shardId().equals(shardRouting.shardId()) || initializingShardRouting.state() != ShardRoutingState.INITIALIZING) continue;
                    initializingNode.remove();
                }
                continue;
            }
            if (!this.allowPrimary && shardRouting.primary()) {
                if (explain) {
                    return new RerouteExplanation(this, allocation.decision(Decision.NO, "cancel_allocation_command", "can't cancel " + this.shardId + " on node " + discoNode + ", shard is primary and started", new Object[0]));
                }
                throw new ElasticsearchIllegalArgumentException("[cancel_allocation] can't cancel " + this.shardId + " on node " + discoNode + ", shard is primary and started");
            }
            it.moveToUnassigned(new UnassignedInfo(UnassignedInfo.Reason.REROUTE_CANCELLED, null));
        }
        if (!found) {
            if (explain) {
                return new RerouteExplanation(this, allocation.decision(Decision.NO, "cancel_allocation_command", "can't cancel " + this.shardId + ", failed to find it on node " + discoNode, new Object[0]));
            }
            throw new ElasticsearchIllegalArgumentException("[cancel_allocation] can't cancel " + this.shardId + ", failed to find it on node " + discoNode);
        }
        return new RerouteExplanation(this, allocation.decision(Decision.YES, "cancel_allocation_command", "shard " + this.shardId + " on node " + discoNode + " can be cancelled", new Object[0]));
    }

    public static class Factory
    implements AllocationCommand.Factory<CancelAllocationCommand> {
        @Override
        public CancelAllocationCommand readFrom(StreamInput in) throws IOException {
            return new CancelAllocationCommand(ShardId.readShardId(in), in.readString(), in.readBoolean());
        }

        @Override
        public void writeTo(CancelAllocationCommand command, StreamOutput out) throws IOException {
            command.shardId().writeTo(out);
            out.writeString(command.node());
            out.writeBoolean(command.allowPrimary());
        }

        @Override
        public CancelAllocationCommand fromXContent(XContentParser parser) throws IOException {
            XContentParser.Token token;
            String index = null;
            int shardId = -1;
            String nodeId = null;
            boolean allowPrimary = false;
            String currentFieldName = null;
            while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                if (token == XContentParser.Token.FIELD_NAME) {
                    currentFieldName = parser.currentName();
                    continue;
                }
                if (token.isValue()) {
                    if ("index".equals(currentFieldName)) {
                        index = parser.text();
                        continue;
                    }
                    if ("shard".equals(currentFieldName)) {
                        shardId = parser.intValue();
                        continue;
                    }
                    if ("node".equals(currentFieldName)) {
                        nodeId = parser.text();
                        continue;
                    }
                    if ("allow_primary".equals(currentFieldName) || "allowPrimary".equals(currentFieldName)) {
                        allowPrimary = parser.booleanValue();
                        continue;
                    }
                    throw new ElasticsearchParseException("[cancel] command does not support field [" + currentFieldName + "]");
                }
                throw new ElasticsearchParseException("[cancel] command does not support complex json tokens [" + (Object)((Object)token) + "]");
            }
            if (index == null) {
                throw new ElasticsearchParseException("[cancel] command missing the index parameter");
            }
            if (shardId == -1) {
                throw new ElasticsearchParseException("[cancel] command missing the shard parameter");
            }
            if (nodeId == null) {
                throw new ElasticsearchParseException("[cancel] command missing the node parameter");
            }
            return new CancelAllocationCommand(new ShardId(index, shardId), nodeId, allowPrimary);
        }

        @Override
        public void toXContent(CancelAllocationCommand command, XContentBuilder builder, ToXContent.Params params, String objectName) throws IOException {
            if (objectName == null) {
                builder.startObject();
            } else {
                builder.startObject(objectName);
            }
            builder.field("index", command.shardId().index().name());
            builder.field("shard", command.shardId().id());
            builder.field("node", command.node());
            builder.field("allow_primary", command.allowPrimary());
            builder.endObject();
        }
    }
}

