/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.routing.allocation.decider;

import java.util.Locale;
import org.elasticsearch.ElasticsearchIllegalArgumentException;
import org.elasticsearch.ElasticsearchIllegalStateException;
import org.elasticsearch.cluster.routing.RoutingNode;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.routing.allocation.RoutingAllocation;
import org.elasticsearch.cluster.routing.allocation.decider.AllocationDecider;
import org.elasticsearch.cluster.routing.allocation.decider.Decision;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.node.settings.NodeSettingsService;

public class EnableAllocationDecider
extends AllocationDecider
implements NodeSettingsService.Listener {
    public static final String NAME = "enable";
    public static final String CLUSTER_ROUTING_ALLOCATION_ENABLE = "cluster.routing.allocation.enable";
    public static final String INDEX_ROUTING_ALLOCATION_ENABLE = "index.routing.allocation.enable";
    private volatile Allocation enable;

    @Inject
    public EnableAllocationDecider(Settings settings, NodeSettingsService nodeSettingsService) {
        super(settings);
        this.enable = Allocation.parse(settings.get(CLUSTER_ROUTING_ALLOCATION_ENABLE, Allocation.ALL.name()));
        nodeSettingsService.addListener(this);
    }

    @Override
    public Decision canAllocate(ShardRouting shardRouting, RoutingNode node, RoutingAllocation allocation) {
        if (allocation.ignoreDisable()) {
            return allocation.decision(Decision.YES, NAME, "allocation disabling is ignored", new Object[0]);
        }
        Settings indexSettings = allocation.routingNodes().metaData().index(shardRouting.index()).settings();
        String enableIndexValue = indexSettings.get(INDEX_ROUTING_ALLOCATION_ENABLE);
        Allocation enable = enableIndexValue != null ? Allocation.parse(enableIndexValue) : this.enable;
        switch (enable) {
            case ALL: {
                return allocation.decision(Decision.YES, NAME, "all allocations are allowed", new Object[0]);
            }
            case NONE: {
                return allocation.decision(Decision.NO, NAME, "no allocations are allowed", new Object[0]);
            }
            case NEW_PRIMARIES: {
                if (shardRouting.primary() && !allocation.routingNodes().routingTable().index(shardRouting.index()).shard(shardRouting.id()).primaryAllocatedPostApi()) {
                    return allocation.decision(Decision.YES, NAME, "new primary allocations are allowed", new Object[0]);
                }
                return allocation.decision(Decision.NO, NAME, "non-new primary allocations are disallowed", new Object[0]);
            }
            case PRIMARIES: {
                if (shardRouting.primary()) {
                    return allocation.decision(Decision.YES, NAME, "primary allocations are allowed", new Object[0]);
                }
                return allocation.decision(Decision.NO, NAME, "replica allocations are disallowed", new Object[0]);
            }
        }
        throw new ElasticsearchIllegalStateException("Unknown allocation option");
    }

    @Override
    public void onRefreshSettings(Settings settings) {
        Allocation enable = Allocation.parse(settings.get(CLUSTER_ROUTING_ALLOCATION_ENABLE, this.enable.name()));
        if (enable != this.enable) {
            this.logger.info("updating [cluster.routing.allocation.enable] from [{}] to [{}]", new Object[]{this.enable, enable});
            this.enable = enable;
        }
    }

    public static enum Allocation {
        NONE,
        NEW_PRIMARIES,
        PRIMARIES,
        ALL;


        public static Allocation parse(String strValue) {
            if (strValue == null) {
                return null;
            }
            strValue = strValue.toUpperCase(Locale.ROOT);
            try {
                return Allocation.valueOf(strValue);
            }
            catch (IllegalArgumentException e) {
                throw new ElasticsearchIllegalArgumentException("Illegal allocation.enable value [" + strValue + "]");
            }
        }
    }
}

