/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.netty.channel.local;

import java.util.concurrent.atomic.AtomicBoolean;
import org.elasticsearch.common.netty.channel.AbstractServerChannel;
import org.elasticsearch.common.netty.channel.ChannelConfig;
import org.elasticsearch.common.netty.channel.ChannelFactory;
import org.elasticsearch.common.netty.channel.ChannelPipeline;
import org.elasticsearch.common.netty.channel.ChannelSink;
import org.elasticsearch.common.netty.channel.Channels;
import org.elasticsearch.common.netty.channel.DefaultServerChannelConfig;
import org.elasticsearch.common.netty.channel.local.LocalAddress;
import org.elasticsearch.common.netty.channel.local.LocalServerChannel;

final class DefaultLocalServerChannel
extends AbstractServerChannel
implements LocalServerChannel {
    final ChannelConfig channelConfig;
    final AtomicBoolean bound = new AtomicBoolean();
    volatile LocalAddress localAddress;

    DefaultLocalServerChannel(ChannelFactory factory, ChannelPipeline pipeline, ChannelSink sink) {
        super(factory, pipeline, sink);
        this.channelConfig = new DefaultServerChannelConfig();
        Channels.fireChannelOpen(this);
    }

    public ChannelConfig getConfig() {
        return this.channelConfig;
    }

    public boolean isBound() {
        return this.isOpen() && this.bound.get();
    }

    public LocalAddress getLocalAddress() {
        return this.isBound() ? this.localAddress : null;
    }

    public LocalAddress getRemoteAddress() {
        return null;
    }

    protected boolean setClosed() {
        return super.setClosed();
    }
}

