/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.netty.handler.codec.protobuf;

import com.google.protobuf.MessageLite;
import org.elasticsearch.common.netty.channel.Channel;
import org.elasticsearch.common.netty.channel.ChannelHandler;
import org.elasticsearch.common.netty.channel.ChannelHandlerContext;
import org.elasticsearch.common.netty.handler.codec.oneone.OneToOneEncoder;

@ChannelHandler.Sharable
public class ProtobufEncoder
extends OneToOneEncoder {
    protected Object encode(ChannelHandlerContext ctx, Channel channel, Object msg) throws Exception {
        if (msg instanceof MessageLite) {
            byte[] array = ((MessageLite)msg).toByteArray();
            return ctx.getChannel().getConfig().getBufferFactory().getBuffer(array, 0, array.length);
        }
        if (msg instanceof MessageLite.Builder) {
            byte[] array = ((MessageLite.Builder)msg).build().toByteArray();
            return ctx.getChannel().getConfig().getBufferFactory().getBuffer(array, 0, array.length);
        }
        return msg;
    }
}

