/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.recycler;

import org.elasticsearch.ElasticsearchIllegalStateException;
import org.elasticsearch.common.recycler.AbstractRecycler;
import org.elasticsearch.common.recycler.Recycler;

public class NoneRecycler<T>
extends AbstractRecycler<T> {
    public NoneRecycler(Recycler.C<T> c) {
        super(c);
    }

    @Override
    public Recycler.V<T> obtain(int sizing) {
        return new NV(this.c.newInstance(sizing));
    }

    @Override
    public void close() {
    }

    public static class NV<T>
    implements Recycler.V<T> {
        T value;

        NV(T value) {
            this.value = value;
        }

        @Override
        public T v() {
            return this.value;
        }

        @Override
        public boolean isRecycled() {
            return false;
        }

        @Override
        public void close() {
            if (this.value == null) {
                throw new ElasticsearchIllegalStateException("recycler entry already released...");
            }
            this.value = null;
        }
    }
}

