/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.settings.loader;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.common.collect.Lists;
import org.elasticsearch.common.collect.Maps;
import org.elasticsearch.common.settings.loader.SettingsLoader;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.XContentType;

public abstract class XContentSettingsLoader
implements SettingsLoader {
    public abstract XContentType contentType();

    @Override
    public Map<String, String> load(String source) throws IOException {
        try (XContentParser parser = XContentFactory.xContent(this.contentType()).createParser(source);){
            Map<String, String> map = this.load(parser);
            return map;
        }
    }

    @Override
    public Map<String, String> load(byte[] source) throws IOException {
        try (XContentParser parser = XContentFactory.xContent(this.contentType()).createParser(source);){
            Map<String, String> map = this.load(parser);
            return map;
        }
    }

    public Map<String, String> load(XContentParser jp) throws IOException {
        StringBuilder sb = new StringBuilder();
        HashMap<String, String> settings = Maps.newHashMap();
        ArrayList<String> path = Lists.newArrayList();
        XContentParser.Token token = jp.nextToken();
        if (token == null) {
            return settings;
        }
        if (token != XContentParser.Token.START_OBJECT) {
            throw new ElasticsearchParseException("malformed, expected settings to start with 'object', instead was [" + (Object)((Object)token) + "]");
        }
        this.serializeObject(settings, sb, path, jp, null);
        XContentParser.Token lastToken = null;
        try {
            while (!jp.isClosed() && (lastToken = jp.nextToken()) == null) {
            }
        }
        catch (Exception e) {
            throw new ElasticsearchParseException("malformed, expected end of settings but encountered additional content", e);
        }
        if (lastToken != null) {
            throw new ElasticsearchParseException("malformed, expected end of settings but encountered additional content");
        }
        return settings;
    }

    private void serializeObject(Map<String, String> settings, StringBuilder sb, List<String> path, XContentParser parser, String objFieldName) throws IOException {
        XContentParser.Token token;
        if (objFieldName != null) {
            path.add(objFieldName);
        }
        String currentFieldName = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.START_OBJECT) {
                this.serializeObject(settings, sb, path, parser, currentFieldName);
                continue;
            }
            if (token == XContentParser.Token.START_ARRAY) {
                this.serializeArray(settings, sb, path, parser, currentFieldName);
                continue;
            }
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (token == XContentParser.Token.VALUE_NULL) continue;
            this.serializeValue(settings, sb, path, parser, currentFieldName);
        }
        if (objFieldName != null) {
            path.remove(path.size() - 1);
        }
    }

    private void serializeArray(Map<String, String> settings, StringBuilder sb, List<String> path, XContentParser parser, String fieldName) throws IOException {
        XContentParser.Token token;
        int counter = 0;
        while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
            if (token == XContentParser.Token.START_OBJECT) {
                this.serializeObject(settings, sb, path, parser, fieldName + '.' + counter++);
                continue;
            }
            if (token == XContentParser.Token.START_ARRAY) {
                this.serializeArray(settings, sb, path, parser, fieldName + '.' + counter++);
                continue;
            }
            if (token == XContentParser.Token.FIELD_NAME) {
                fieldName = parser.currentName();
                continue;
            }
            if (token == XContentParser.Token.VALUE_NULL) continue;
            this.serializeValue(settings, sb, path, parser, fieldName + '.' + counter++);
        }
    }

    private void serializeValue(Map<String, String> settings, StringBuilder sb, List<String> path, XContentParser parser, String fieldName) throws IOException {
        sb.setLength(0);
        for (String pathEle : path) {
            sb.append(pathEle).append('.');
        }
        sb.append(fieldName);
        settings.put(sb.toString(), parser.text());
    }
}

