/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.http.netty;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicReference;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.common.Booleans;
import org.elasticsearch.common.component.AbstractLifecycleComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.netty.NettyUtils;
import org.elasticsearch.common.netty.OpenChannelsHandler;
import org.elasticsearch.common.netty.bootstrap.ServerBootstrap;
import org.elasticsearch.common.netty.channel.AdaptiveReceiveBufferSizePredictorFactory;
import org.elasticsearch.common.netty.channel.Channel;
import org.elasticsearch.common.netty.channel.ChannelHandlerContext;
import org.elasticsearch.common.netty.channel.ChannelPipeline;
import org.elasticsearch.common.netty.channel.ChannelPipelineFactory;
import org.elasticsearch.common.netty.channel.Channels;
import org.elasticsearch.common.netty.channel.ExceptionEvent;
import org.elasticsearch.common.netty.channel.FixedReceiveBufferSizePredictorFactory;
import org.elasticsearch.common.netty.channel.ReceiveBufferSizePredictorFactory;
import org.elasticsearch.common.netty.channel.socket.nio.NioServerSocketChannelFactory;
import org.elasticsearch.common.netty.channel.socket.oio.OioServerSocketChannelFactory;
import org.elasticsearch.common.netty.handler.codec.http.HttpChunkAggregator;
import org.elasticsearch.common.netty.handler.codec.http.HttpContentCompressor;
import org.elasticsearch.common.netty.handler.codec.http.HttpRequestDecoder;
import org.elasticsearch.common.netty.handler.timeout.ReadTimeoutException;
import org.elasticsearch.common.network.NetworkService;
import org.elasticsearch.common.network.NetworkUtils;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.transport.BoundTransportAddress;
import org.elasticsearch.common.transport.InetSocketTransportAddress;
import org.elasticsearch.common.transport.NetworkExceptionHelper;
import org.elasticsearch.common.transport.PortsRange;
import org.elasticsearch.common.unit.ByteSizeUnit;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.http.BindHttpException;
import org.elasticsearch.http.HttpChannel;
import org.elasticsearch.http.HttpInfo;
import org.elasticsearch.http.HttpRequest;
import org.elasticsearch.http.HttpServerAdapter;
import org.elasticsearch.http.HttpServerTransport;
import org.elasticsearch.http.HttpStats;
import org.elasticsearch.http.netty.ESHttpContentDecompressor;
import org.elasticsearch.http.netty.ESHttpResponseEncoder;
import org.elasticsearch.http.netty.HttpRequestHandler;
import org.elasticsearch.http.netty.pipelining.HttpPipeliningHandler;
import org.elasticsearch.monitor.jvm.JvmInfo;
import org.elasticsearch.transport.BindTransportException;

public class NettyHttpServerTransport
extends AbstractLifecycleComponent<HttpServerTransport>
implements HttpServerTransport {
    public static final String SETTING_CORS_ENABLED = "http.cors.enabled";
    public static final String SETTING_CORS_ALLOW_ORIGIN = "http.cors.allow-origin";
    public static final String SETTING_CORS_MAX_AGE = "http.cors.max-age";
    public static final String SETTING_CORS_ALLOW_METHODS = "http.cors.allow-methods";
    public static final String SETTING_CORS_ALLOW_HEADERS = "http.cors.allow-headers";
    public static final String SETTING_CORS_ALLOW_CREDENTIALS = "http.cors.allow-credentials";
    public static final String SETTING_PIPELINING = "http.pipelining";
    public static final String SETTING_PIPELINING_MAX_EVENTS = "http.pipelining.max_events";
    public static final String SETTING_HTTP_COMPRESSION = "http.compression";
    public static final String SETTING_HTTP_COMPRESSION_LEVEL = "http.compression_level";
    public static final String SETTING_HTTP_DETAILED_ERRORS_ENABLED = "http.detailed_errors.enabled";
    public static final boolean DEFAULT_SETTING_PIPELINING = true;
    public static final int DEFAULT_SETTING_PIPELINING_MAX_EVENTS = 10000;
    protected final NetworkService networkService;
    protected final BigArrays bigArrays;
    protected final ByteSizeValue maxContentLength;
    protected final ByteSizeValue maxInitialLineLength;
    protected final ByteSizeValue maxHeaderSize;
    protected final ByteSizeValue maxChunkSize;
    protected final int workerCount;
    protected final boolean blockingServer;
    protected final boolean pipelining;
    protected final int pipeliningMaxEvents;
    protected final boolean compression;
    protected final int compressionLevel;
    protected final boolean resetCookies;
    protected final String port;
    protected final String bindHost;
    protected final String publishHost;
    protected final boolean detailedErrorsEnabled;
    protected int publishPort;
    protected final String tcpNoDelay;
    protected final String tcpKeepAlive;
    protected final boolean reuseAddress;
    protected final ByteSizeValue tcpSendBufferSize;
    protected final ByteSizeValue tcpReceiveBufferSize;
    protected final ReceiveBufferSizePredictorFactory receiveBufferSizePredictorFactory;
    protected final ByteSizeValue maxCumulationBufferCapacity;
    protected final int maxCompositeBufferComponents;
    protected volatile ServerBootstrap serverBootstrap;
    protected volatile BoundTransportAddress boundAddress;
    protected volatile Channel serverChannel;
    protected OpenChannelsHandler serverOpenChannels;
    protected volatile HttpServerAdapter httpServerAdapter;

    @Inject
    public NettyHttpServerTransport(Settings settings, NetworkService networkService, BigArrays bigArrays) {
        super(settings);
        this.networkService = networkService;
        this.bigArrays = bigArrays;
        if (settings.getAsBoolean("netty.epollBugWorkaround", (Boolean)false).booleanValue()) {
            System.setProperty("org.elasticsearch.common.netty.epollBugWorkaround", "true");
        }
        ByteSizeValue maxContentLength = this.componentSettings.getAsBytesSize("max_content_length", settings.getAsBytesSize("http.max_content_length", new ByteSizeValue(100L, ByteSizeUnit.MB)));
        this.maxChunkSize = this.componentSettings.getAsBytesSize("max_chunk_size", settings.getAsBytesSize("http.max_chunk_size", new ByteSizeValue(8L, ByteSizeUnit.KB)));
        this.maxHeaderSize = this.componentSettings.getAsBytesSize("max_header_size", settings.getAsBytesSize("http.max_header_size", new ByteSizeValue(8L, ByteSizeUnit.KB)));
        this.maxInitialLineLength = this.componentSettings.getAsBytesSize("max_initial_line_length", settings.getAsBytesSize("http.max_initial_line_length", new ByteSizeValue(4L, ByteSizeUnit.KB)));
        this.resetCookies = this.componentSettings.getAsBoolean("reset_cookies", settings.getAsBoolean("http.reset_cookies", (Boolean)false));
        this.maxCumulationBufferCapacity = this.componentSettings.getAsBytesSize("max_cumulation_buffer_capacity", null);
        this.maxCompositeBufferComponents = this.componentSettings.getAsInt("max_composite_buffer_components", (Integer)-1);
        this.workerCount = this.componentSettings.getAsInt("worker_count", (Integer)(EsExecutors.boundedNumberOfProcessors(settings) * 2));
        this.blockingServer = settings.getAsBoolean("http.blocking_server", settings.getAsBoolean("network.tcp.blocking_server", settings.getAsBoolean("network.tcp.blocking", (Boolean)false)));
        this.port = this.componentSettings.get("port", settings.get("http.port", "9200-9300"));
        this.bindHost = this.componentSettings.get("bind_host", settings.get("http.bind_host", settings.get("http.host")));
        this.publishHost = this.componentSettings.get("publish_host", settings.get("http.publish_host", settings.get("http.host")));
        this.publishPort = this.componentSettings.getAsInt("publish_port", settings.getAsInt("http.publish_port", (Integer)0));
        this.tcpNoDelay = this.componentSettings.get("tcp_no_delay", settings.get("network.tcp.no_delay", "true"));
        this.tcpKeepAlive = this.componentSettings.get("tcp_keep_alive", settings.get("network.tcp.keep_alive", "true"));
        this.reuseAddress = this.componentSettings.getAsBoolean("reuse_address", settings.getAsBoolean("network.tcp.reuse_address", (Boolean)NetworkUtils.defaultReuseAddress()));
        this.tcpSendBufferSize = this.componentSettings.getAsBytesSize("tcp_send_buffer_size", settings.getAsBytesSize("network.tcp.send_buffer_size", NetworkService.TcpSettings.TCP_DEFAULT_SEND_BUFFER_SIZE));
        this.tcpReceiveBufferSize = this.componentSettings.getAsBytesSize("tcp_receive_buffer_size", settings.getAsBytesSize("network.tcp.receive_buffer_size", NetworkService.TcpSettings.TCP_DEFAULT_RECEIVE_BUFFER_SIZE));
        this.detailedErrorsEnabled = settings.getAsBoolean(SETTING_HTTP_DETAILED_ERRORS_ENABLED, (Boolean)true);
        long defaultReceiverPredictor = 524288L;
        if (JvmInfo.jvmInfo().mem().directMemoryMax().bytes() > 0L) {
            long l = (long)(0.3 * (double)JvmInfo.jvmInfo().mem().directMemoryMax().bytes() / (double)this.workerCount);
            defaultReceiverPredictor = Math.min(defaultReceiverPredictor, Math.max(l, 65536L));
        }
        ByteSizeValue receivePredictorMin = this.componentSettings.getAsBytesSize("receive_predictor_min", this.componentSettings.getAsBytesSize("receive_predictor_size", new ByteSizeValue(defaultReceiverPredictor)));
        ByteSizeValue receivePredictorMax = this.componentSettings.getAsBytesSize("receive_predictor_max", this.componentSettings.getAsBytesSize("receive_predictor_size", new ByteSizeValue(defaultReceiverPredictor)));
        this.receiveBufferSizePredictorFactory = receivePredictorMax.bytes() == receivePredictorMin.bytes() ? new FixedReceiveBufferSizePredictorFactory((int)receivePredictorMax.bytes()) : new AdaptiveReceiveBufferSizePredictorFactory((int)receivePredictorMin.bytes(), (int)receivePredictorMin.bytes(), (int)receivePredictorMax.bytes());
        this.compression = settings.getAsBoolean(SETTING_HTTP_COMPRESSION, (Boolean)false);
        this.compressionLevel = settings.getAsInt(SETTING_HTTP_COMPRESSION_LEVEL, (Integer)6);
        this.pipelining = settings.getAsBoolean(SETTING_PIPELINING, (Boolean)true);
        this.pipeliningMaxEvents = settings.getAsInt(SETTING_PIPELINING_MAX_EVENTS, (Integer)10000);
        if (maxContentLength.bytes() > Integer.MAX_VALUE) {
            this.logger.warn("maxContentLength[" + maxContentLength + "] set to high value, resetting it to [100mb]", new Object[0]);
            maxContentLength = new ByteSizeValue(100L, ByteSizeUnit.MB);
        }
        this.maxContentLength = maxContentLength;
        this.logger.debug("using max_chunk_size[{}], max_header_size[{}], max_initial_line_length[{}], max_content_length[{}], receive_predictor[{}->{}], pipelining[{}], pipelining_max_events[{}]", this.maxChunkSize, this.maxHeaderSize, this.maxInitialLineLength, this.maxContentLength, receivePredictorMin, receivePredictorMax, this.pipelining, this.pipeliningMaxEvents);
    }

    public Settings settings() {
        return this.settings;
    }

    @Override
    public void httpServerAdapter(HttpServerAdapter httpServerAdapter) {
        this.httpServerAdapter = httpServerAdapter;
    }

    @Override
    protected void doStart() throws ElasticsearchException {
        InetSocketAddress publishAddress;
        InetAddress hostAddressX;
        this.serverOpenChannels = new OpenChannelsHandler(this.logger);
        this.serverBootstrap = this.blockingServer ? new ServerBootstrap(new OioServerSocketChannelFactory(Executors.newCachedThreadPool(EsExecutors.daemonThreadFactory(this.settings, "http_server_boss")), Executors.newCachedThreadPool(EsExecutors.daemonThreadFactory(this.settings, "http_server_worker")))) : new ServerBootstrap(new NioServerSocketChannelFactory((Executor)Executors.newCachedThreadPool(EsExecutors.daemonThreadFactory(this.settings, "http_server_boss")), Executors.newCachedThreadPool(EsExecutors.daemonThreadFactory(this.settings, "http_server_worker")), this.workerCount));
        this.serverBootstrap.setPipelineFactory(this.configureServerChannelPipelineFactory());
        if (!"default".equals(this.tcpNoDelay)) {
            this.serverBootstrap.setOption("child.tcpNoDelay", Booleans.parseBoolean(this.tcpNoDelay, null));
        }
        if (!"default".equals(this.tcpKeepAlive)) {
            this.serverBootstrap.setOption("child.keepAlive", Booleans.parseBoolean(this.tcpKeepAlive, null));
        }
        if (this.tcpSendBufferSize != null && this.tcpSendBufferSize.bytes() > 0L) {
            this.serverBootstrap.setOption("child.sendBufferSize", this.tcpSendBufferSize.bytes());
        }
        if (this.tcpReceiveBufferSize != null && this.tcpReceiveBufferSize.bytes() > 0L) {
            this.serverBootstrap.setOption("child.receiveBufferSize", this.tcpReceiveBufferSize.bytes());
        }
        this.serverBootstrap.setOption("receiveBufferSizePredictorFactory", this.receiveBufferSizePredictorFactory);
        this.serverBootstrap.setOption("child.receiveBufferSizePredictorFactory", this.receiveBufferSizePredictorFactory);
        this.serverBootstrap.setOption("reuseAddress", this.reuseAddress);
        this.serverBootstrap.setOption("child.reuseAddress", this.reuseAddress);
        try {
            hostAddressX = this.networkService.resolveBindHostAddress(this.bindHost);
        }
        catch (IOException e) {
            throw new BindHttpException("Failed to resolve host [" + this.bindHost + "]", e);
        }
        final InetAddress hostAddress = hostAddressX;
        PortsRange portsRange = new PortsRange(this.port);
        final AtomicReference lastException = new AtomicReference();
        boolean success = portsRange.iterate(new PortsRange.PortCallback(){

            @Override
            public boolean onPortNumber(int portNumber) {
                try {
                    NettyHttpServerTransport.this.serverChannel = NettyHttpServerTransport.this.serverBootstrap.bind(new InetSocketAddress(hostAddress, portNumber));
                }
                catch (Exception e) {
                    lastException.set(e);
                    return false;
                }
                return true;
            }
        });
        if (!success) {
            throw new BindHttpException("Failed to bind to [" + this.port + "]", (Throwable)lastException.get());
        }
        InetSocketAddress boundAddress = (InetSocketAddress)this.serverChannel.getLocalAddress();
        if (0 == this.publishPort) {
            this.publishPort = boundAddress.getPort();
        }
        try {
            publishAddress = new InetSocketAddress(this.networkService.resolvePublishHostAddress(this.publishHost), this.publishPort);
        }
        catch (Exception e) {
            throw new BindTransportException("Failed to resolve publish address", e);
        }
        this.boundAddress = new BoundTransportAddress(new InetSocketTransportAddress(boundAddress), new InetSocketTransportAddress(publishAddress));
    }

    @Override
    protected void doStop() throws ElasticsearchException {
        if (this.serverChannel != null) {
            this.serverChannel.close().awaitUninterruptibly();
            this.serverChannel = null;
        }
        if (this.serverOpenChannels != null) {
            this.serverOpenChannels.close();
            this.serverOpenChannels = null;
        }
        if (this.serverBootstrap != null) {
            this.serverBootstrap.releaseExternalResources();
            this.serverBootstrap = null;
        }
    }

    @Override
    protected void doClose() throws ElasticsearchException {
    }

    @Override
    public BoundTransportAddress boundAddress() {
        return this.boundAddress;
    }

    @Override
    public HttpInfo info() {
        BoundTransportAddress boundTransportAddress = this.boundAddress();
        if (boundTransportAddress == null) {
            return null;
        }
        return new HttpInfo(boundTransportAddress, this.maxContentLength.bytes());
    }

    @Override
    public HttpStats stats() {
        OpenChannelsHandler channels = this.serverOpenChannels;
        return new HttpStats(channels == null ? 0L : channels.numberOfOpenChannels(), channels == null ? 0L : channels.totalChannels());
    }

    protected void dispatchRequest(HttpRequest request, HttpChannel channel) {
        this.httpServerAdapter.dispatchRequest(request, channel);
    }

    protected void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent e) throws Exception {
        if (e.getCause() instanceof ReadTimeoutException) {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("Connection timeout [{}]", ctx.getChannel().getRemoteAddress());
            }
            ctx.getChannel().close();
        } else {
            if (!this.lifecycle.started()) {
                return;
            }
            if (!NetworkExceptionHelper.isCloseConnectionException(e.getCause())) {
                this.logger.warn("Caught exception while handling client http traffic, closing connection {}", e.getCause(), ctx.getChannel());
                ctx.getChannel().close();
            } else {
                this.logger.debug("Caught exception while handling client http traffic, closing connection {}", e.getCause(), ctx.getChannel());
                ctx.getChannel().close();
            }
        }
    }

    public ChannelPipelineFactory configureServerChannelPipelineFactory() {
        return new HttpChannelPipelineFactory(this, this.detailedErrorsEnabled);
    }

    static {
        NettyUtils.setup();
    }

    protected static class HttpChannelPipelineFactory
    implements ChannelPipelineFactory {
        protected final NettyHttpServerTransport transport;
        protected final HttpRequestHandler requestHandler;

        public HttpChannelPipelineFactory(NettyHttpServerTransport transport, boolean detailedErrorsEnabled) {
            this.transport = transport;
            this.requestHandler = new HttpRequestHandler(transport, detailedErrorsEnabled);
        }

        @Override
        public ChannelPipeline getPipeline() throws Exception {
            ChannelPipeline pipeline = Channels.pipeline();
            pipeline.addLast("openChannels", this.transport.serverOpenChannels);
            HttpRequestDecoder requestDecoder = new HttpRequestDecoder((int)this.transport.maxInitialLineLength.bytes(), (int)this.transport.maxHeaderSize.bytes(), (int)this.transport.maxChunkSize.bytes());
            if (this.transport.maxCumulationBufferCapacity != null) {
                if (this.transport.maxCumulationBufferCapacity.bytes() > Integer.MAX_VALUE) {
                    requestDecoder.setMaxCumulationBufferCapacity(Integer.MAX_VALUE);
                } else {
                    requestDecoder.setMaxCumulationBufferCapacity((int)this.transport.maxCumulationBufferCapacity.bytes());
                }
            }
            if (this.transport.maxCompositeBufferComponents != -1) {
                requestDecoder.setMaxCumulationBufferComponents(this.transport.maxCompositeBufferComponents);
            }
            pipeline.addLast("decoder", requestDecoder);
            pipeline.addLast("decoder_compress", new ESHttpContentDecompressor(this.transport.compression));
            HttpChunkAggregator httpChunkAggregator = new HttpChunkAggregator((int)this.transport.maxContentLength.bytes());
            if (this.transport.maxCompositeBufferComponents != -1) {
                httpChunkAggregator.setMaxCumulationBufferComponents(this.transport.maxCompositeBufferComponents);
            }
            pipeline.addLast("aggregator", httpChunkAggregator);
            pipeline.addLast("encoder", new ESHttpResponseEncoder());
            if (this.transport.compression) {
                pipeline.addLast("encoder_compress", new HttpContentCompressor(this.transport.compressionLevel));
            }
            if (this.transport.pipelining) {
                pipeline.addLast("pipelining", new HttpPipeliningHandler(this.transport.pipeliningMaxEvents));
            }
            pipeline.addLast("handler", this.requestHandler);
            return pipeline;
        }
    }
}

