/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.fielddata.plain;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import org.apache.lucene.index.AtomicReader;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.index.DocsEnum;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.MultiDocValues;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.LongValues;
import org.apache.lucene.util.PagedBytes;
import org.apache.lucene.util.packed.PackedLongValues;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ElasticsearchIllegalStateException;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.breaker.CircuitBreaker;
import org.elasticsearch.common.collect.ImmutableOpenMap;
import org.elasticsearch.common.collect.ImmutableSortedSet;
import org.elasticsearch.common.hppc.ObjectObjectOpenHashMap;
import org.elasticsearch.common.hppc.cursors.ObjectObjectCursor;
import org.elasticsearch.common.lease.Releasables;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.fielddata.AtomicParentChildFieldData;
import org.elasticsearch.index.fielddata.FieldDataType;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.fielddata.IndexFieldDataCache;
import org.elasticsearch.index.fielddata.IndexParentChildFieldData;
import org.elasticsearch.index.fielddata.RamAccountingTermsEnum;
import org.elasticsearch.index.fielddata.fieldcomparator.BytesRefFieldComparatorSource;
import org.elasticsearch.index.fielddata.ordinals.Ordinals;
import org.elasticsearch.index.fielddata.ordinals.OrdinalsBuilder;
import org.elasticsearch.index.fielddata.plain.AbstractAtomicParentChildFieldData;
import org.elasticsearch.index.fielddata.plain.AbstractIndexFieldData;
import org.elasticsearch.index.fielddata.plain.PagedBytesAtomicFieldData;
import org.elasticsearch.index.fielddata.plain.ParentChildAtomicFieldData;
import org.elasticsearch.index.fielddata.plain.ParentChildFilteredTermsEnum;
import org.elasticsearch.index.fielddata.plain.ParentChildIntersectTermsEnum;
import org.elasticsearch.index.mapper.DocumentMapper;
import org.elasticsearch.index.mapper.DocumentTypeListener;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.mapper.internal.ParentFieldMapper;
import org.elasticsearch.index.settings.IndexSettings;
import org.elasticsearch.indices.breaker.CircuitBreakerService;
import org.elasticsearch.search.MultiValueMode;

public class ParentChildIndexFieldData
extends AbstractIndexFieldData<AtomicParentChildFieldData>
implements IndexParentChildFieldData,
DocumentTypeListener {
    private final NavigableSet<BytesRef> parentTypes;
    private final CircuitBreakerService breakerService;
    private final Object lock = new Object();

    public ParentChildIndexFieldData(Index index, @IndexSettings Settings indexSettings, FieldMapper.Names fieldNames, FieldDataType fieldDataType, IndexFieldDataCache cache, MapperService mapperService, CircuitBreakerService breakerService) {
        super(index, indexSettings, fieldNames, fieldDataType, cache);
        this.parentTypes = new TreeSet<BytesRef>(BytesRef.getUTF8SortedAsUnicodeComparator());
        this.breakerService = breakerService;
        for (DocumentMapper documentMapper : mapperService.docMappers(false)) {
            this.beforeCreate(documentMapper);
        }
        mapperService.addTypeListener(this);
    }

    @Override
    public IndexFieldData.XFieldComparatorSource comparatorSource(@Nullable Object missingValue, MultiValueMode sortMode, IndexFieldData.XFieldComparatorSource.Nested nested) {
        return new BytesRefFieldComparatorSource(this, missingValue, sortMode, nested);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ParentChildAtomicFieldData loadDirect(AtomicReaderContext context) throws Exception {
        ImmutableSortedSet<BytesRef> parentTypes;
        AtomicReader reader = context.reader();
        float acceptableTransientOverheadRatio = this.fieldDataType.getSettings().getAsFloat("acceptable_transient_overhead_ratio", Float.valueOf(0.5f)).floatValue();
        Object object = this.lock;
        synchronized (object) {
            parentTypes = ImmutableSortedSet.copyOf(BytesRef.getUTF8SortedAsUnicodeComparator(), this.parentTypes);
        }
        boolean success = false;
        ParentChildAtomicFieldData data = null;
        ParentChildFilteredTermsEnum termsEnum = new ParentChildFilteredTermsEnum(new ParentChildIntersectTermsEnum(reader, "_uid", "_parent"), parentTypes);
        ParentChildEstimator estimator = new ParentChildEstimator(this.breakerService.getBreaker(CircuitBreaker.Name.FIELDDATA), (TermsEnum)termsEnum);
        TermsEnum estimatedTermsEnum = estimator.beforeLoad(null);
        ObjectObjectOpenHashMap<String, TypeBuilder> typeBuilders = ObjectObjectOpenHashMap.newInstance();
        try {
            try {
                DocsEnum docsEnum = null;
                BytesRef term = estimatedTermsEnum.next();
                while (term != null) {
                    String type = termsEnum.type();
                    TypeBuilder typeBuilder = (TypeBuilder)typeBuilders.get(type);
                    if (typeBuilder == null) {
                        typeBuilder = new TypeBuilder(acceptableTransientOverheadRatio, reader);
                        typeBuilders.put(type, typeBuilder);
                    }
                    BytesRef id = termsEnum.id();
                    long termOrd = typeBuilder.builder.nextOrdinal();
                    assert (termOrd == typeBuilder.termOrdToBytesOffset.size());
                    typeBuilder.termOrdToBytesOffset.add(typeBuilder.bytes.copyUsingLengthPrefix(id));
                    docsEnum = estimatedTermsEnum.docs(null, docsEnum, 0);
                    int docId = docsEnum.nextDoc();
                    while (docId != Integer.MAX_VALUE) {
                        typeBuilder.builder.addDoc(docId);
                        docId = docsEnum.nextDoc();
                    }
                    term = estimatedTermsEnum.next();
                }
                ImmutableOpenMap.Builder typeToAtomicFieldData = ImmutableOpenMap.builder(typeBuilders.size());
                for (ObjectObjectCursor cursor : typeBuilders) {
                    PagedBytes.Reader bytesReader = ((TypeBuilder)cursor.value).bytes.freeze(true);
                    Ordinals ordinals = ((TypeBuilder)cursor.value).builder.build(this.fieldDataType.getSettings());
                    typeToAtomicFieldData.put(cursor.key, new PagedBytesAtomicFieldData(bytesReader, ((TypeBuilder)cursor.value).termOrdToBytesOffset.build(), ordinals));
                }
                data = new ParentChildAtomicFieldData(typeToAtomicFieldData.build());
            }
            catch (Throwable throwable) {
                for (ObjectObjectCursor cursor : typeBuilders) {
                    ((TypeBuilder)cursor.value).builder.close();
                }
                throw throwable;
            }
            for (ObjectObjectCursor cursor : typeBuilders) {
                ((TypeBuilder)cursor.value).builder.close();
            }
            success = true;
            ParentChildAtomicFieldData parentChildAtomicFieldData = data;
            return parentChildAtomicFieldData;
        }
        finally {
            if (success) {
                estimator.afterLoad(estimatedTermsEnum, data.ramBytesUsed());
            } else {
                estimator.afterLoad(estimatedTermsEnum, 0L);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void beforeCreate(DocumentMapper mapper) {
        Object object = this.lock;
        synchronized (object) {
            ParentFieldMapper parentFieldMapper = mapper.parentFieldMapper();
            if (parentFieldMapper.active() && this.parentTypes.add(new BytesRef((CharSequence)parentFieldMapper.type()))) {
                this.clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void afterRemove(DocumentMapper mapper) {
        Object object = this.lock;
        synchronized (object) {
            ParentFieldMapper parentFieldMapper = mapper.parentFieldMapper();
            if (parentFieldMapper.active()) {
                this.parentTypes.remove(new BytesRef((CharSequence)parentFieldMapper.type()));
            }
        }
    }

    @Override
    public IndexParentChildFieldData loadGlobal(IndexReader indexReader) {
        if (indexReader.leaves().size() <= 1) {
            return this;
        }
        try {
            return this.cache.load(indexReader, this);
        }
        catch (Throwable e) {
            if (e instanceof ElasticsearchException) {
                throw (ElasticsearchException)e;
            }
            throw new ElasticsearchException(e.getMessage(), e);
        }
    }

    private static MultiDocValues.OrdinalMap buildOrdinalMap(AtomicParentChildFieldData[] atomicFD, String parentType) throws IOException {
        SortedDocValues[] ordinals = new SortedDocValues[atomicFD.length];
        for (int i = 0; i < ordinals.length; ++i) {
            ordinals[i] = atomicFD[i].getOrdinalsValues(parentType);
        }
        return MultiDocValues.OrdinalMap.build(null, (SortedDocValues[])ordinals, (float)0.25f);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IndexParentChildFieldData localGlobalDirect(IndexReader indexReader) throws Exception {
        long startTime = System.nanoTime();
        HashSet<String> parentTypes = new HashSet<String>();
        Object object = this.lock;
        synchronized (object) {
            for (BytesRef type : this.parentTypes) {
                parentTypes.add(type.utf8ToString());
            }
        }
        long ramBytesUsed = 0L;
        HashMap<String, OrdinalMapAndAtomicFieldData> perType = new HashMap<String, OrdinalMapAndAtomicFieldData>();
        for (String type : parentTypes) {
            AtomicParentChildFieldData[] fieldData = new AtomicParentChildFieldData[indexReader.leaves().size()];
            for (AtomicReaderContext context : indexReader.leaves()) {
                fieldData[context.ord] = (AtomicParentChildFieldData)this.load(context);
            }
            MultiDocValues.OrdinalMap ordMap = ParentChildIndexFieldData.buildOrdinalMap(fieldData, type);
            ramBytesUsed += ordMap.ramBytesUsed();
            perType.put(type, new OrdinalMapAndAtomicFieldData(ordMap, fieldData));
        }
        AtomicParentChildFieldData[] fielddata = new AtomicParentChildFieldData[indexReader.leaves().size()];
        for (int i = 0; i < fielddata.length; ++i) {
            fielddata[i] = new GlobalAtomicFieldData(parentTypes, perType, i);
        }
        this.breakerService.getBreaker(CircuitBreaker.Name.FIELDDATA).addWithoutBreaking(ramBytesUsed);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Global-ordinals[_parent] took {}", new TimeValue(System.nanoTime() - startTime, TimeUnit.NANOSECONDS));
        }
        return new GlobalFieldData(indexReader, fielddata, ramBytesUsed);
    }

    private class GlobalFieldData
    implements IndexParentChildFieldData,
    Accountable {
        private final AtomicParentChildFieldData[] fielddata;
        private final IndexReader reader;
        private final long ramBytesUsed;

        GlobalFieldData(IndexReader reader, AtomicParentChildFieldData[] fielddata, long ramBytesUsed) {
            this.reader = reader;
            this.ramBytesUsed = ramBytesUsed;
            this.fielddata = fielddata;
        }

        @Override
        public FieldMapper.Names getFieldNames() {
            return ParentChildIndexFieldData.this.getFieldNames();
        }

        @Override
        public FieldDataType getFieldDataType() {
            return ParentChildIndexFieldData.this.getFieldDataType();
        }

        @Override
        public AtomicParentChildFieldData load(AtomicReaderContext context) {
            assert (context.reader().getCoreCacheKey() == ((AtomicReaderContext)this.reader.leaves().get(context.ord)).reader().getCoreCacheKey());
            return this.fielddata[context.ord];
        }

        @Override
        public AtomicParentChildFieldData loadDirect(AtomicReaderContext context) throws Exception {
            return this.load(context);
        }

        @Override
        public IndexFieldData.XFieldComparatorSource comparatorSource(Object missingValue, MultiValueMode sortMode, IndexFieldData.XFieldComparatorSource.Nested nested) {
            throw new UnsupportedOperationException("No sorting on global ords");
        }

        @Override
        public void clear() {
            ParentChildIndexFieldData.this.clear();
        }

        @Override
        public void clear(IndexReader reader) {
            ParentChildIndexFieldData.this.clear(reader);
        }

        @Override
        public Index index() {
            return ParentChildIndexFieldData.this.index();
        }

        public long ramBytesUsed() {
            return this.ramBytesUsed;
        }

        @Override
        public IndexParentChildFieldData loadGlobal(IndexReader indexReader) {
            if (indexReader.getCoreCacheKey() == this.reader.getCoreCacheKey()) {
                return this;
            }
            throw new ElasticsearchIllegalStateException();
        }

        @Override
        public IndexParentChildFieldData localGlobalDirect(IndexReader indexReader) throws Exception {
            return this.loadGlobal(indexReader);
        }
    }

    private static class GlobalAtomicFieldData
    extends AbstractAtomicParentChildFieldData {
        private final Set<String> types;
        private final Map<String, OrdinalMapAndAtomicFieldData> atomicFD;
        private final int segmentIndex;

        public GlobalAtomicFieldData(Set<String> types, Map<String, OrdinalMapAndAtomicFieldData> atomicFD, int segmentIndex) {
            this.types = types;
            this.atomicFD = atomicFD;
            this.segmentIndex = segmentIndex;
        }

        @Override
        public Set<String> types() {
            return this.types;
        }

        @Override
        public SortedDocValues getOrdinalsValues(String type) {
            OrdinalMapAndAtomicFieldData atomicFD = this.atomicFD.get(type);
            final MultiDocValues.OrdinalMap ordMap = atomicFD.ordMap;
            final SortedDocValues[] allSegmentValues = new SortedDocValues[atomicFD.fieldData.length];
            for (int i = 0; i < allSegmentValues.length; ++i) {
                allSegmentValues[i] = atomicFD.fieldData[i].getOrdinalsValues(type);
            }
            final SortedDocValues segmentValues = allSegmentValues[this.segmentIndex];
            if ((long)segmentValues.getValueCount() == ordMap.getValueCount()) {
                return segmentValues;
            }
            final LongValues globalOrds = ordMap.getGlobalOrds(this.segmentIndex);
            return new SortedDocValues(){

                public BytesRef lookupOrd(int ord) {
                    int segmentIndex = ordMap.getFirstSegmentNumber((long)ord);
                    int segmentOrd = (int)ordMap.getFirstSegmentOrd((long)ord);
                    return allSegmentValues[segmentIndex].lookupOrd(segmentOrd);
                }

                public int getValueCount() {
                    return (int)ordMap.getValueCount();
                }

                public int getOrd(int docID) {
                    int segmentOrd = segmentValues.getOrd(docID);
                    if (segmentOrd >= 0) {
                        return (int)globalOrds.get(segmentOrd);
                    }
                    return segmentOrd;
                }
            };
        }

        public long ramBytesUsed() {
            return 0L;
        }

        @Override
        public void close() throws ElasticsearchException {
            ArrayList<AtomicParentChildFieldData> closeables = new ArrayList<AtomicParentChildFieldData>();
            for (OrdinalMapAndAtomicFieldData fds : this.atomicFD.values()) {
                closeables.addAll(Arrays.asList(fds.fieldData));
            }
            Releasables.close(closeables);
        }
    }

    private static class OrdinalMapAndAtomicFieldData {
        final MultiDocValues.OrdinalMap ordMap;
        final AtomicParentChildFieldData[] fieldData;

        public OrdinalMapAndAtomicFieldData(MultiDocValues.OrdinalMap ordMap, AtomicParentChildFieldData[] fieldData) {
            this.ordMap = ordMap;
            this.fieldData = fieldData;
        }
    }

    public class ParentChildEstimator
    implements AbstractIndexFieldData.PerValueEstimator {
        private final CircuitBreaker breaker;
        private final TermsEnum filteredEnum;

        public ParentChildEstimator(CircuitBreaker breaker, TermsEnum filteredEnum) {
            this.breaker = breaker;
            this.filteredEnum = filteredEnum;
        }

        @Override
        public long bytesPerValue(BytesRef term) {
            if (term == null) {
                return 0L;
            }
            return 2 * term.length;
        }

        @Override
        public TermsEnum beforeLoad(Terms terms) throws IOException {
            return new RamAccountingTermsEnum(this.filteredEnum, this.breaker, this, "parent/child id cache");
        }

        @Override
        public void afterLoad(TermsEnum termsEnum, long actualUsed) {
            assert (termsEnum instanceof RamAccountingTermsEnum);
            long estimatedBytes = ((RamAccountingTermsEnum)termsEnum).getTotalBytes();
            this.breaker.addWithoutBreaking(-(estimatedBytes - actualUsed));
        }
    }

    public static class Builder
    implements IndexFieldData.Builder {
        @Override
        public IndexFieldData<?> build(Index index, @IndexSettings Settings indexSettings, FieldMapper<?> mapper, IndexFieldDataCache cache, CircuitBreakerService breakerService, MapperService mapperService) {
            return new ParentChildIndexFieldData(index, indexSettings, mapper.names(), mapper.fieldDataType(), cache, mapperService, breakerService);
        }
    }

    class TypeBuilder {
        final PagedBytes bytes = new PagedBytes(15);
        final PackedLongValues.Builder termOrdToBytesOffset = PackedLongValues.monotonicBuilder((float)0.0f);
        final OrdinalsBuilder builder;

        TypeBuilder(float acceptableTransientOverheadRatio, AtomicReader reader) throws IOException {
            this.builder = new OrdinalsBuilder(-1L, reader.maxDoc(), acceptableTransientOverheadRatio);
        }
    }
}

