/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query;

import java.io.IOException;
import java.util.Collection;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.index.query.BaseQueryBuilder;
import org.elasticsearch.index.query.BoostableQueryBuilder;

public class TermsQueryBuilder
extends BaseQueryBuilder
implements BoostableQueryBuilder<TermsQueryBuilder> {
    private final String name;
    private final Object[] values;
    private String minimumShouldMatch;
    private Boolean disableCoord;
    private float boost = -1.0f;
    private String queryName;

    public TermsQueryBuilder(String name, String ... values) {
        this(name, (Object[])values);
    }

    public TermsQueryBuilder(String name, int ... values) {
        this.name = name;
        this.values = new Integer[values.length];
        for (int i = 0; i < values.length; ++i) {
            this.values[i] = values[i];
        }
    }

    public TermsQueryBuilder(String name, long ... values) {
        this.name = name;
        this.values = new Long[values.length];
        for (int i = 0; i < values.length; ++i) {
            this.values[i] = values[i];
        }
    }

    public TermsQueryBuilder(String name, float ... values) {
        this.name = name;
        this.values = new Float[values.length];
        for (int i = 0; i < values.length; ++i) {
            this.values[i] = Float.valueOf(values[i]);
        }
    }

    public TermsQueryBuilder(String name, double ... values) {
        this.name = name;
        this.values = new Double[values.length];
        for (int i = 0; i < values.length; ++i) {
            this.values[i] = values[i];
        }
    }

    public TermsQueryBuilder(String name, Object ... values) {
        this.name = name;
        this.values = values;
    }

    public TermsQueryBuilder(String name, Collection values) {
        this(name, values.toArray());
    }

    public TermsQueryBuilder minimumMatch(int minimumMatch) {
        this.minimumShouldMatch = Integer.toString(minimumMatch);
        return this;
    }

    public TermsQueryBuilder minimumShouldMatch(String minimumShouldMatch) {
        this.minimumShouldMatch = minimumShouldMatch;
        return this;
    }

    @Override
    public TermsQueryBuilder boost(float boost) {
        this.boost = boost;
        return this;
    }

    public TermsQueryBuilder disableCoord(boolean disableCoord) {
        this.disableCoord = disableCoord;
        return this;
    }

    public TermsQueryBuilder queryName(String queryName) {
        this.queryName = queryName;
        return this;
    }

    @Override
    protected void doXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject("terms");
        builder.startArray(this.name);
        for (Object value : this.values) {
            builder.value(value);
        }
        builder.endArray();
        if (this.minimumShouldMatch != null) {
            builder.field("minimum_should_match", this.minimumShouldMatch);
        }
        if (this.disableCoord != null) {
            builder.field("disable_coord", (Object)this.disableCoord);
        }
        if (this.boost != -1.0f) {
            builder.field("boost", this.boost);
        }
        if (this.queryName != null) {
            builder.field("_name", this.queryName);
        }
        builder.endObject();
    }
}

