/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.translog.fs;

import java.io.File;
import java.io.IOException;
import java.nio.channels.ClosedChannelException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.ReleasableBytesReference;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.FileSystemUtils;
import org.elasticsearch.common.io.stream.BytesStreamInput;
import org.elasticsearch.common.io.stream.ReleasableBytesStreamOutput;
import org.elasticsearch.common.lease.Releasables;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.index.settings.IndexSettings;
import org.elasticsearch.index.settings.IndexSettingsService;
import org.elasticsearch.index.shard.AbstractIndexShardComponent;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.index.store.IndexStore;
import org.elasticsearch.index.translog.Translog;
import org.elasticsearch.index.translog.TranslogException;
import org.elasticsearch.index.translog.TranslogStats;
import org.elasticsearch.index.translog.TranslogStreams;
import org.elasticsearch.index.translog.fs.FsChannelSnapshot;
import org.elasticsearch.index.translog.fs.FsTranslogFile;
import org.elasticsearch.index.translog.fs.RafReference;

public class FsTranslog
extends AbstractIndexShardComponent
implements Translog {
    public static final String INDEX_TRANSLOG_FS_TYPE = "index.translog.fs.type";
    private final IndexSettingsService indexSettingsService;
    private final BigArrays bigArrays;
    private final ReadWriteLock rwl = new ReentrantReadWriteLock();
    private final File[] locations;
    private volatile FsTranslogFile current;
    private volatile FsTranslogFile trans;
    private FsTranslogFile.Type type;
    private boolean syncOnEachOperation = false;
    private volatile int bufferSize;
    private volatile int transientBufferSize;
    private final ApplySettings applySettings = new ApplySettings();

    @Inject
    public FsTranslog(ShardId shardId, @IndexSettings Settings indexSettings, IndexSettingsService indexSettingsService, BigArrays bigArrays, IndexStore indexStore) throws IOException {
        super(shardId, indexSettings);
        this.indexSettingsService = indexSettingsService;
        this.bigArrays = bigArrays;
        Path[] translogLocations = indexStore.shardTranslogLocations(shardId);
        this.locations = new File[translogLocations.length];
        for (int i = 0; i < translogLocations.length; ++i) {
            Files.createDirectories(translogLocations[i], new FileAttribute[0]);
            this.locations[i] = translogLocations[i].toFile();
        }
        this.type = FsTranslogFile.Type.fromString(this.componentSettings.get("type", FsTranslogFile.Type.BUFFERED.name()));
        this.bufferSize = (int)this.componentSettings.getAsBytesSize("buffer_size", ByteSizeValue.parseBytesSizeValue("64k")).bytes();
        this.transientBufferSize = (int)this.componentSettings.getAsBytesSize("transient_buffer_size", ByteSizeValue.parseBytesSizeValue("8k")).bytes();
        indexSettingsService.addListener(this.applySettings);
    }

    public FsTranslog(ShardId shardId, @IndexSettings Settings indexSettings, File location) {
        super(shardId, indexSettings);
        this.indexSettingsService = null;
        this.locations = new File[]{location};
        FileSystemUtils.mkdirs(location);
        this.bigArrays = BigArrays.NON_RECYCLING_INSTANCE;
        this.type = FsTranslogFile.Type.fromString(this.componentSettings.get("type", FsTranslogFile.Type.BUFFERED.name()));
        this.bufferSize = (int)this.componentSettings.getAsBytesSize("buffer_size", ByteSizeValue.parseBytesSizeValue("64k")).bytes();
    }

    @Override
    public void closeWithDelete() {
        this.close(true);
    }

    @Override
    public void close() throws ElasticsearchException {
        this.close(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateBuffer(ByteSizeValue bufferSize) {
        this.bufferSize = bufferSize.bytesAsInt();
        this.rwl.writeLock().lock();
        try {
            FsTranslogFile current1 = this.current;
            if (current1 != null) {
                current1.updateBufferSize(this.bufferSize);
            }
            if ((current1 = this.trans) != null) {
                current1.updateBufferSize(this.bufferSize);
            }
        }
        finally {
            this.rwl.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void close(boolean delete) {
        if (this.indexSettingsService != null) {
            this.indexSettingsService.removeListener(this.applySettings);
        }
        this.rwl.writeLock().lock();
        try {
            FsTranslogFile current1 = this.current;
            if (current1 != null) {
                current1.close(delete);
            }
            if ((current1 = this.trans) != null) {
                current1.close(delete);
            }
        }
        finally {
            this.rwl.writeLock().unlock();
        }
    }

    public File[] locations() {
        return this.locations;
    }

    @Override
    public long currentId() {
        FsTranslogFile current1 = this.current;
        if (current1 == null) {
            return -1L;
        }
        return current1.id();
    }

    @Override
    public int estimatedNumberOfOperations() {
        FsTranslogFile current1 = this.current;
        if (current1 == null) {
            return 0;
        }
        return current1.estimatedNumberOfOperations();
    }

    public long ramBytesUsed() {
        return 0L;
    }

    @Override
    public long translogSizeInBytes() {
        FsTranslogFile current1 = this.current;
        if (current1 == null) {
            return 0L;
        }
        return current1.translogSizeInBytes();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int clearUnreferenced() {
        this.rwl.writeLock().lock();
        int deleted = 0;
        try {
            if (this.current == null) {
                int n = 0;
                return n;
            }
            for (File location : this.locations) {
                File[] files = location.listFiles();
                if (files == null) continue;
                for (File file : files) {
                    if (file.getName().equals("translog-" + this.current.id()) || this.trans != null && file.getName().equals("translog-" + this.trans.id())) continue;
                    try {
                        this.logger.trace("clearing unreferenced translog {}", file);
                        file.delete();
                        ++deleted;
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
            }
        }
        finally {
            this.rwl.writeLock().unlock();
        }
        return deleted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void newTranslog(long id) throws TranslogException {
        this.rwl.writeLock().lock();
        try {
            FsTranslogFile newFile;
            long size = Long.MAX_VALUE;
            File location = null;
            for (File file : this.locations) {
                long currentFree = file.getFreeSpace();
                if (currentFree >= size) continue;
                size = currentFree;
                location = file;
            }
            try {
                newFile = this.type.create(this.shardId, id, new RafReference(new File(location, "translog-" + id), this.logger), this.bufferSize);
            }
            catch (IOException e) {
                throw new TranslogException(this.shardId, "failed to create new translog file", (Throwable)e);
            }
            FsTranslogFile old = this.current;
            this.current = newFile;
            if (old != null) {
                boolean delete = true;
                if (old.id() == id) {
                    delete = false;
                }
                old.close(delete);
            }
        }
        finally {
            this.rwl.writeLock().unlock();
        }
        this.logger.trace("created new translog id: {}", id);
    }

    @Override
    public void newTransientTranslog(long id) throws TranslogException {
        this.rwl.writeLock().lock();
        try {
            assert (this.trans == null);
            long size = Long.MAX_VALUE;
            File location = null;
            for (File file : this.locations) {
                long currentFree = file.getFreeSpace();
                if (currentFree >= size) continue;
                size = currentFree;
                location = file;
            }
            this.trans = this.type.create(this.shardId, id, new RafReference(new File(location, "translog-" + id), this.logger), this.transientBufferSize);
        }
        catch (IOException e) {
            throw new TranslogException(this.shardId, "failed to create new translog file", (Throwable)e);
        }
        finally {
            this.rwl.writeLock().unlock();
        }
        this.logger.trace("created new transient translog id: {}", id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void makeTransientCurrent() {
        FsTranslogFile old;
        this.rwl.writeLock().lock();
        try {
            assert (this.trans != null);
            old = this.current;
            this.current = this.trans;
            this.trans = null;
        }
        finally {
            this.rwl.writeLock().unlock();
        }
        this.logger.trace("make transient current {}", old);
        old.close(true);
        this.current.reuse(old);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void revertTransient() {
        FsTranslogFile tmpTransient;
        this.rwl.writeLock().lock();
        try {
            tmpTransient = this.trans;
            this.trans = null;
        }
        finally {
            this.rwl.writeLock().unlock();
        }
        this.logger.trace("revert transient {}", tmpTransient);
        if (tmpTransient != null) {
            tmpTransient.close(true);
        }
    }

    private FsTranslogFile translogForLocation(Translog.Location location) {
        if (this.trans != null && this.trans.id() == location.translogId) {
            return this.trans;
        }
        if (this.current.id() == location.translogId) {
            return this.current;
        }
        return null;
    }

    @Override
    public Translog.Operation read(Translog.Location location) {
        this.rwl.readLock().lock();
        try {
            FsTranslogFile translog = this.translogForLocation(location);
            if (translog != null) {
                byte[] data = translog.read(location);
                try (BytesStreamInput in = new BytesStreamInput(data);){
                    Translog.Operation operation = translog.getStream().read(in);
                    return operation;
                }
            }
            Translog.Operation operation = null;
            return operation;
        }
        catch (IOException e) {
            throw new ElasticsearchException("failed to read source from traslog location " + location, e);
        }
        finally {
            this.rwl.readLock().unlock();
        }
    }

    @Override
    public Translog.Location add(Translog.Operation operation) throws TranslogException {
        Translog.Location location;
        block10: {
            this.rwl.readLock().lock();
            boolean released = false;
            ReleasableBytesStreamOutput out = null;
            try {
                out = new ReleasableBytesStreamOutput(this.bigArrays);
                TranslogStreams.writeTranslogOperation(out, operation);
                ReleasableBytesReference bytes = out.bytes();
                Translog.Location location2 = this.current.add(bytes);
                if (this.syncOnEachOperation) {
                    this.current.sync();
                }
                assert (new BytesArray(this.current.read(location2)).equals(bytes));
                FsTranslogFile trans = this.trans;
                if (trans != null) {
                    try {
                        location2 = trans.add(bytes);
                    }
                    catch (ClosedChannelException e) {
                        // empty catch block
                    }
                }
                Releasables.close(bytes);
                released = true;
                location = location2;
                this.rwl.readLock().unlock();
                if (released || out == null) break block10;
            }
            catch (Throwable e) {
                try {
                    throw new TranslogException(this.shardId, "Failed to write operation [" + operation + "]", e);
                }
                catch (Throwable throwable) {
                    this.rwl.readLock().unlock();
                    if (!released && out != null) {
                        Releasables.close(out.bytes());
                    }
                    throw throwable;
                }
            }
            Releasables.close(out.bytes());
        }
        return location;
    }

    @Override
    public FsChannelSnapshot snapshot() throws TranslogException {
        FsTranslogFile current;
        FsChannelSnapshot snapshot;
        while ((snapshot = (current = this.current).snapshot()) == null) {
            if (current.closed() && this.current == current) {
                throw new TranslogException(this.shardId, "current translog is already closed");
            }
            Thread.yield();
        }
        return snapshot;
    }

    @Override
    public Translog.Snapshot snapshot(Translog.Snapshot snapshot) {
        FsChannelSnapshot snap = this.snapshot();
        if (snap.translogId() == snapshot.translogId()) {
            snap.seekTo(snapshot.position());
        }
        return snap;
    }

    @Override
    public void sync() throws IOException {
        block3: {
            FsTranslogFile current1 = this.current;
            if (current1 == null) {
                return;
            }
            this.logger.trace("sync translog {}", current1);
            try {
                current1.sync();
            }
            catch (IOException e) {
                this.logger.trace("sync failed for {}", current1, e);
                if (this.current != current1) break block3;
                throw e;
            }
        }
    }

    @Override
    public boolean syncNeeded() {
        FsTranslogFile current1 = this.current;
        return current1 != null && current1.syncNeeded();
    }

    @Override
    public void syncOnEachOperation(boolean syncOnEachOperation) {
        this.syncOnEachOperation = syncOnEachOperation;
    }

    @Override
    public TranslogStats stats() {
        FsTranslogFile current = this.current;
        if (current == null) {
            return new TranslogStats(0, 0L);
        }
        return new TranslogStats(current.estimatedNumberOfOperations(), current.translogSizeInBytes());
    }

    class ApplySettings
    implements IndexSettingsService.Listener {
        ApplySettings() {
        }

        @Override
        public void onRefreshSettings(Settings settings) {
            FsTranslogFile.Type type = FsTranslogFile.Type.fromString(settings.get(FsTranslog.INDEX_TRANSLOG_FS_TYPE, FsTranslog.this.type.name()));
            if (type != FsTranslog.this.type) {
                FsTranslog.this.logger.info("updating type from [{}] to [{}]", new Object[]{FsTranslog.this.type, type});
                FsTranslog.this.type = type;
            }
        }
    }
}

