/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.indices.query;

import java.util.Set;
import org.elasticsearch.common.collect.Sets;
import org.elasticsearch.common.geo.ShapesAvailability;
import org.elasticsearch.common.inject.AbstractModule;
import org.elasticsearch.common.inject.multibindings.Multibinder;
import org.elasticsearch.index.query.AndFilterParser;
import org.elasticsearch.index.query.BoolFilterParser;
import org.elasticsearch.index.query.BoolQueryParser;
import org.elasticsearch.index.query.BoostingQueryParser;
import org.elasticsearch.index.query.CommonTermsQueryParser;
import org.elasticsearch.index.query.ConstantScoreQueryParser;
import org.elasticsearch.index.query.DisMaxQueryParser;
import org.elasticsearch.index.query.ExistsFilterParser;
import org.elasticsearch.index.query.FQueryFilterParser;
import org.elasticsearch.index.query.FieldMaskingSpanQueryParser;
import org.elasticsearch.index.query.FilterParser;
import org.elasticsearch.index.query.FilteredQueryParser;
import org.elasticsearch.index.query.FuzzyLikeThisFieldQueryParser;
import org.elasticsearch.index.query.FuzzyLikeThisQueryParser;
import org.elasticsearch.index.query.FuzzyQueryParser;
import org.elasticsearch.index.query.GeoBoundingBoxFilterParser;
import org.elasticsearch.index.query.GeoDistanceFilterParser;
import org.elasticsearch.index.query.GeoDistanceRangeFilterParser;
import org.elasticsearch.index.query.GeoPolygonFilterParser;
import org.elasticsearch.index.query.GeoShapeFilterParser;
import org.elasticsearch.index.query.GeoShapeQueryParser;
import org.elasticsearch.index.query.GeohashCellFilter;
import org.elasticsearch.index.query.HasChildFilterParser;
import org.elasticsearch.index.query.HasChildQueryParser;
import org.elasticsearch.index.query.HasParentFilterParser;
import org.elasticsearch.index.query.HasParentQueryParser;
import org.elasticsearch.index.query.IdsFilterParser;
import org.elasticsearch.index.query.IdsQueryParser;
import org.elasticsearch.index.query.IndicesFilterParser;
import org.elasticsearch.index.query.IndicesQueryParser;
import org.elasticsearch.index.query.LimitFilterParser;
import org.elasticsearch.index.query.MatchAllFilterParser;
import org.elasticsearch.index.query.MatchAllQueryParser;
import org.elasticsearch.index.query.MatchQueryParser;
import org.elasticsearch.index.query.MissingFilterParser;
import org.elasticsearch.index.query.MoreLikeThisFieldQueryParser;
import org.elasticsearch.index.query.MoreLikeThisQueryParser;
import org.elasticsearch.index.query.MultiMatchQueryParser;
import org.elasticsearch.index.query.NestedFilterParser;
import org.elasticsearch.index.query.NestedQueryParser;
import org.elasticsearch.index.query.NotFilterParser;
import org.elasticsearch.index.query.NumericRangeFilterParser;
import org.elasticsearch.index.query.OrFilterParser;
import org.elasticsearch.index.query.PrefixFilterParser;
import org.elasticsearch.index.query.PrefixQueryParser;
import org.elasticsearch.index.query.QueryFilterParser;
import org.elasticsearch.index.query.QueryParser;
import org.elasticsearch.index.query.QueryStringQueryParser;
import org.elasticsearch.index.query.RangeFilterParser;
import org.elasticsearch.index.query.RangeQueryParser;
import org.elasticsearch.index.query.RegexpFilterParser;
import org.elasticsearch.index.query.RegexpQueryParser;
import org.elasticsearch.index.query.ScriptFilterParser;
import org.elasticsearch.index.query.SimpleQueryStringParser;
import org.elasticsearch.index.query.SpanFirstQueryParser;
import org.elasticsearch.index.query.SpanMultiTermQueryParser;
import org.elasticsearch.index.query.SpanNearQueryParser;
import org.elasticsearch.index.query.SpanNotQueryParser;
import org.elasticsearch.index.query.SpanOrQueryParser;
import org.elasticsearch.index.query.SpanTermQueryParser;
import org.elasticsearch.index.query.TemplateQueryParser;
import org.elasticsearch.index.query.TermFilterParser;
import org.elasticsearch.index.query.TermQueryParser;
import org.elasticsearch.index.query.TermsFilterParser;
import org.elasticsearch.index.query.TermsQueryParser;
import org.elasticsearch.index.query.TopChildrenQueryParser;
import org.elasticsearch.index.query.TypeFilterParser;
import org.elasticsearch.index.query.WildcardQueryParser;
import org.elasticsearch.index.query.WrapperFilterParser;
import org.elasticsearch.index.query.WrapperQueryParser;
import org.elasticsearch.index.query.functionscore.FunctionScoreQueryParser;
import org.elasticsearch.indices.query.IndicesQueriesRegistry;

public class IndicesQueriesModule
extends AbstractModule {
    private Set<Class<? extends QueryParser>> queryParsersClasses = Sets.newHashSet();
    private Set<QueryParser> queryParsers = Sets.newHashSet();
    private Set<Class<? extends FilterParser>> filterParsersClasses = Sets.newHashSet();
    private Set<FilterParser> filterParsers = Sets.newHashSet();

    public synchronized IndicesQueriesModule addQuery(Class<? extends QueryParser> queryParser) {
        this.queryParsersClasses.add(queryParser);
        return this;
    }

    @Deprecated
    public synchronized IndicesQueriesModule addQuery(QueryParser queryParser) {
        this.queryParsers.add(queryParser);
        return this;
    }

    public synchronized IndicesQueriesModule addFilter(Class<? extends FilterParser> filterParser) {
        this.filterParsersClasses.add(filterParser);
        return this;
    }

    @Deprecated
    public synchronized IndicesQueriesModule addFilter(FilterParser filterParser) {
        this.filterParsers.add(filterParser);
        return this;
    }

    @Override
    protected void configure() {
        this.bind(IndicesQueriesRegistry.class).asEagerSingleton();
        Multibinder<QueryParser> qpBinders = Multibinder.newSetBinder(this.binder(), QueryParser.class);
        for (Class<? extends QueryParser> clazz : this.queryParsersClasses) {
            qpBinders.addBinding().to(clazz).asEagerSingleton();
        }
        for (QueryParser queryParser : this.queryParsers) {
            qpBinders.addBinding().toInstance(queryParser);
        }
        qpBinders.addBinding().to(MatchQueryParser.class).asEagerSingleton();
        qpBinders.addBinding().to(MultiMatchQueryParser.class).asEagerSingleton();
        qpBinders.addBinding().to(NestedQueryParser.class).asEagerSingleton();
        qpBinders.addBinding().to(HasChildQueryParser.class).asEagerSingleton();
        qpBinders.addBinding().to(HasParentQueryParser.class).asEagerSingleton();
        qpBinders.addBinding().to(TopChildrenQueryParser.class).asEagerSingleton();
        qpBinders.addBinding().to(DisMaxQueryParser.class).asEagerSingleton();
        qpBinders.addBinding().to(IdsQueryParser.class).asEagerSingleton();
        qpBinders.addBinding().to(MatchAllQueryParser.class).asEagerSingleton();
        qpBinders.addBinding().to(QueryStringQueryParser.class).asEagerSingleton();
        qpBinders.addBinding().to(BoostingQueryParser.class).asEagerSingleton();
        qpBinders.addBinding().to(BoolQueryParser.class).asEagerSingleton();
        qpBinders.addBinding().to(TermQueryParser.class).asEagerSingleton();
        qpBinders.addBinding().to(TermsQueryParser.class).asEagerSingleton();
        qpBinders.addBinding().to(FuzzyQueryParser.class).asEagerSingleton();
        qpBinders.addBinding().to(RegexpQueryParser.class).asEagerSingleton();
        qpBinders.addBinding().to(RangeQueryParser.class).asEagerSingleton();
        qpBinders.addBinding().to(PrefixQueryParser.class).asEagerSingleton();
        qpBinders.addBinding().to(WildcardQueryParser.class).asEagerSingleton();
        qpBinders.addBinding().to(FilteredQueryParser.class).asEagerSingleton();
        qpBinders.addBinding().to(ConstantScoreQueryParser.class).asEagerSingleton();
        qpBinders.addBinding().to(SpanTermQueryParser.class).asEagerSingleton();
        qpBinders.addBinding().to(SpanNotQueryParser.class).asEagerSingleton();
        qpBinders.addBinding().to(FieldMaskingSpanQueryParser.class).asEagerSingleton();
        qpBinders.addBinding().to(SpanFirstQueryParser.class).asEagerSingleton();
        qpBinders.addBinding().to(SpanNearQueryParser.class).asEagerSingleton();
        qpBinders.addBinding().to(SpanOrQueryParser.class).asEagerSingleton();
        qpBinders.addBinding().to(MoreLikeThisQueryParser.class).asEagerSingleton();
        qpBinders.addBinding().to(MoreLikeThisFieldQueryParser.class).asEagerSingleton();
        qpBinders.addBinding().to(FuzzyLikeThisQueryParser.class).asEagerSingleton();
        qpBinders.addBinding().to(FuzzyLikeThisFieldQueryParser.class).asEagerSingleton();
        qpBinders.addBinding().to(WrapperQueryParser.class).asEagerSingleton();
        qpBinders.addBinding().to(IndicesQueryParser.class).asEagerSingleton();
        qpBinders.addBinding().to(CommonTermsQueryParser.class).asEagerSingleton();
        qpBinders.addBinding().to(SpanMultiTermQueryParser.class).asEagerSingleton();
        qpBinders.addBinding().to(FunctionScoreQueryParser.class).asEagerSingleton();
        qpBinders.addBinding().to(SimpleQueryStringParser.class).asEagerSingleton();
        qpBinders.addBinding().to(TemplateQueryParser.class).asEagerSingleton();
        if (ShapesAvailability.JTS_AVAILABLE) {
            qpBinders.addBinding().to(GeoShapeQueryParser.class).asEagerSingleton();
        }
        Multibinder<FilterParser> fpBinders = Multibinder.newSetBinder(this.binder(), FilterParser.class);
        for (Class<? extends FilterParser> clazz : this.filterParsersClasses) {
            fpBinders.addBinding().to(clazz).asEagerSingleton();
        }
        for (FilterParser filterParser : this.filterParsers) {
            fpBinders.addBinding().toInstance(filterParser);
        }
        fpBinders.addBinding().to(HasChildFilterParser.class).asEagerSingleton();
        fpBinders.addBinding().to(HasParentFilterParser.class).asEagerSingleton();
        fpBinders.addBinding().to(NestedFilterParser.class).asEagerSingleton();
        fpBinders.addBinding().to(TypeFilterParser.class).asEagerSingleton();
        fpBinders.addBinding().to(IdsFilterParser.class).asEagerSingleton();
        fpBinders.addBinding().to(LimitFilterParser.class).asEagerSingleton();
        fpBinders.addBinding().to(TermFilterParser.class).asEagerSingleton();
        fpBinders.addBinding().to(TermsFilterParser.class).asEagerSingleton();
        fpBinders.addBinding().to(RangeFilterParser.class).asEagerSingleton();
        fpBinders.addBinding().to(NumericRangeFilterParser.class).asEagerSingleton();
        fpBinders.addBinding().to(PrefixFilterParser.class).asEagerSingleton();
        fpBinders.addBinding().to(RegexpFilterParser.class).asEagerSingleton();
        fpBinders.addBinding().to(ScriptFilterParser.class).asEagerSingleton();
        fpBinders.addBinding().to(GeoDistanceFilterParser.class).asEagerSingleton();
        fpBinders.addBinding().to(GeoDistanceRangeFilterParser.class).asEagerSingleton();
        fpBinders.addBinding().to(GeoBoundingBoxFilterParser.class).asEagerSingleton();
        fpBinders.addBinding().to(GeohashCellFilter.Parser.class).asEagerSingleton();
        fpBinders.addBinding().to(GeoPolygonFilterParser.class).asEagerSingleton();
        if (ShapesAvailability.JTS_AVAILABLE) {
            fpBinders.addBinding().to(GeoShapeFilterParser.class).asEagerSingleton();
        }
        fpBinders.addBinding().to(QueryFilterParser.class).asEagerSingleton();
        fpBinders.addBinding().to(FQueryFilterParser.class).asEagerSingleton();
        fpBinders.addBinding().to(BoolFilterParser.class).asEagerSingleton();
        fpBinders.addBinding().to(AndFilterParser.class).asEagerSingleton();
        fpBinders.addBinding().to(OrFilterParser.class).asEagerSingleton();
        fpBinders.addBinding().to(NotFilterParser.class).asEagerSingleton();
        fpBinders.addBinding().to(MatchAllFilterParser.class).asEagerSingleton();
        fpBinders.addBinding().to(ExistsFilterParser.class).asEagerSingleton();
        fpBinders.addBinding().to(MissingFilterParser.class).asEagerSingleton();
        fpBinders.addBinding().to(IndicesFilterParser.class).asEagerSingleton();
        fpBinders.addBinding().to(WrapperFilterParser.class).asEagerSingleton();
    }
}

