/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.range.geodistance;

import java.io.IOException;
import java.util.List;
import java.util.Locale;
import org.elasticsearch.common.collect.Lists;
import org.elasticsearch.common.geo.GeoDistance;
import org.elasticsearch.common.geo.GeoPoint;
import org.elasticsearch.common.unit.DistanceUnit;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.bucket.range.geodistance.InternalGeoDistance;
import org.elasticsearch.search.builder.SearchSourceBuilderException;

public class GeoDistanceBuilder
extends AggregationBuilder<GeoDistanceBuilder> {
    private String field;
    private DistanceUnit unit;
    private GeoDistance distanceType;
    private GeoPoint point;
    private List<Range> ranges = Lists.newArrayList();

    public GeoDistanceBuilder(String name) {
        super(name, InternalGeoDistance.TYPE.name());
    }

    public GeoDistanceBuilder field(String field) {
        this.field = field;
        return this;
    }

    public GeoDistanceBuilder unit(DistanceUnit unit) {
        this.unit = unit;
        return this;
    }

    public GeoDistanceBuilder distanceType(GeoDistance distanceType) {
        this.distanceType = distanceType;
        return this;
    }

    public GeoDistanceBuilder point(String latLon) {
        return this.point(GeoPoint.parseFromLatLon(latLon));
    }

    public GeoDistanceBuilder point(GeoPoint point) {
        this.point = point;
        return this;
    }

    public GeoDistanceBuilder geohash(String geohash) {
        if (this.point == null) {
            this.point = new GeoPoint();
        }
        this.point.resetFromGeoHash(geohash);
        return this;
    }

    public GeoDistanceBuilder lat(double lat) {
        if (this.point == null) {
            this.point = new GeoPoint();
        }
        this.point.resetLat(lat);
        return this;
    }

    public GeoDistanceBuilder lon(double lon) {
        if (this.point == null) {
            this.point = new GeoPoint();
        }
        this.point.resetLon(lon);
        return this;
    }

    public GeoDistanceBuilder addRange(String key, double from, double to) {
        this.ranges.add(new Range(key, from, to));
        return this;
    }

    public GeoDistanceBuilder addRange(double from, double to) {
        return this.addRange(null, from, to);
    }

    public GeoDistanceBuilder addUnboundedTo(String key, double to) {
        this.ranges.add(new Range(key, null, to));
        return this;
    }

    public GeoDistanceBuilder addUnboundedTo(double to) {
        return this.addUnboundedTo(null, to);
    }

    public GeoDistanceBuilder addUnboundedFrom(String key, double from) {
        this.ranges.add(new Range(key, from, null));
        return this;
    }

    public GeoDistanceBuilder addUnboundedFrom(double from) {
        return this.addUnboundedFrom(null, from);
    }

    @Override
    protected XContentBuilder internalXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.ranges.isEmpty()) {
            throw new SearchSourceBuilderException("at least one range must be defined for geo_distance aggregation [" + this.getName() + "]");
        }
        if (this.point == null) {
            throw new SearchSourceBuilderException("center point must be defined for geo_distance aggregation [" + this.getName() + "]");
        }
        if (this.field != null) {
            builder.field("field", this.field);
        }
        if (this.unit != null) {
            builder.field("unit", (Object)this.unit);
        }
        if (this.distanceType != null) {
            builder.field("distance_type", this.distanceType.name().toLowerCase(Locale.ROOT));
        }
        builder.startObject("center").field("lat", this.point.lat()).field("lon", this.point.lon()).endObject();
        builder.startArray("ranges");
        for (Range range : this.ranges) {
            range.toXContent(builder, params);
        }
        builder.endArray();
        return builder.endObject();
    }

    public static class Range
    implements ToXContent {
        private String key;
        private Double from;
        private Double to;

        public Range(String key, Double from, Double to) {
            this.key = key;
            this.from = from;
            this.to = to;
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            if (this.from != null) {
                builder.field("from", (double)this.from);
            }
            if (this.to != null) {
                builder.field("to", (double)this.to);
            }
            if (this.key != null) {
                builder.field("key", this.key);
            }
            return builder.endObject();
        }
    }
}

