/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.significant.heuristics;

import java.io.IOException;
import org.elasticsearch.Version;
import org.elasticsearch.common.collect.ImmutableMap;
import org.elasticsearch.common.collect.MapBuilder;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.search.aggregations.bucket.significant.heuristics.JLHScore;
import org.elasticsearch.search.aggregations.bucket.significant.heuristics.SignificanceHeuristic;

public class SignificanceHeuristicStreams {
    private static ImmutableMap<String, Stream> STREAMS = ImmutableMap.of();

    public static SignificanceHeuristic read(StreamInput in) throws IOException {
        if (in.getVersion().onOrAfter(Version.V_1_3_0)) {
            return SignificanceHeuristicStreams.stream(in.readString()).readResult(in);
        }
        return JLHScore.INSTANCE;
    }

    public static synchronized void registerStream(Stream stream, String ... names) {
        MapBuilder<String, Stream> uStreams = MapBuilder.newMapBuilder(STREAMS);
        for (String name : names) {
            uStreams.put(name, stream);
        }
        STREAMS = uStreams.immutableMap();
    }

    public static Stream stream(String name) {
        return STREAMS.get(name);
    }

    public static interface Stream {
        public SignificanceHeuristic readResult(StreamInput var1) throws IOException;

        public String getName();
    }
}

