/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.facet.terms.longs;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.bytes.HashedBytesArray;
import org.elasticsearch.common.collect.BoundedTreeSet;
import org.elasticsearch.common.collect.ImmutableList;
import org.elasticsearch.common.hppc.LongIntOpenHashMap;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.recycler.Recycler;
import org.elasticsearch.common.text.StringText;
import org.elasticsearch.common.text.Text;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentBuilderString;
import org.elasticsearch.search.facet.Facet;
import org.elasticsearch.search.facet.InternalFacet;
import org.elasticsearch.search.facet.terms.InternalTermsFacet;
import org.elasticsearch.search.facet.terms.TermsFacet;

public class InternalLongTermsFacet
extends InternalTermsFacet {
    private static final BytesReference STREAM_TYPE = new HashedBytesArray(Strings.toUTF8Bytes("lTerms"));
    static InternalFacet.Stream STREAM = new InternalFacet.Stream(){

        @Override
        public Facet readFacet(StreamInput in) throws IOException {
            return InternalLongTermsFacet.readTermsFacet(in);
        }
    };
    int requiredSize;
    long missing;
    long total;
    Collection<LongEntry> entries = ImmutableList.of();
    TermsFacet.ComparatorType comparatorType;

    public static void registerStream() {
        InternalFacet.Streams.registerStream(STREAM, STREAM_TYPE);
    }

    @Override
    public BytesReference streamType() {
        return STREAM_TYPE;
    }

    InternalLongTermsFacet() {
    }

    public InternalLongTermsFacet(String name, TermsFacet.ComparatorType comparatorType, int requiredSize, Collection<LongEntry> entries, long missing, long total) {
        super(name);
        this.comparatorType = comparatorType;
        this.requiredSize = requiredSize;
        this.entries = entries;
        this.missing = missing;
        this.total = total;
    }

    public List<LongEntry> getEntries() {
        if (!(this.entries instanceof List)) {
            this.entries = ImmutableList.copyOf(this.entries);
        }
        return (List)this.entries;
    }

    @Override
    public Iterator<TermsFacet.Entry> iterator() {
        return this.entries.iterator();
    }

    @Override
    public long getMissingCount() {
        return this.missing;
    }

    @Override
    public long getTotalCount() {
        return this.total;
    }

    @Override
    public long getOtherCount() {
        long other = this.total;
        for (TermsFacet.Entry entry : this.entries) {
            other -= (long)entry.getCount();
        }
        return other;
    }

    @Override
    public Facet reduce(InternalFacet.ReduceContext context) {
        List<Facet> facets = context.facets();
        if (facets.size() == 1) {
            Facet facet = facets.get(0);
            if (facet instanceof InternalLongTermsFacet) {
                ((InternalLongTermsFacet)facet).trimExcessEntries();
            }
            return facet;
        }
        InternalLongTermsFacet first = null;
        Recycler.V<LongIntOpenHashMap> aggregated = context.cacheRecycler().longIntMap(-1);
        long missing = 0L;
        long total = 0L;
        for (Facet facet : facets) {
            TermsFacet termsFacet = (TermsFacet)facet;
            if (first == null && termsFacet instanceof InternalLongTermsFacet) {
                first = (InternalLongTermsFacet)termsFacet;
            }
            missing += termsFacet.getMissingCount();
            total += termsFacet.getTotalCount();
            for (TermsFacet.Entry entry : termsFacet.getEntries()) {
                aggregated.v().addTo(((LongEntry)entry).term, entry.getCount());
            }
        }
        BoundedTreeSet<TermsFacet.Entry> ordered = new BoundedTreeSet<TermsFacet.Entry>(first.comparatorType.comparator(), first.requiredSize);
        LongIntOpenHashMap entries = aggregated.v();
        boolean[] states = aggregated.v().allocated;
        long[] keys = aggregated.v().keys;
        int[] nArray = aggregated.v().values;
        for (int i = 0; i < entries.allocated.length; ++i) {
            if (!states[i]) continue;
            ordered.add(new LongEntry(keys[i], nArray[i]));
        }
        first.entries = ordered;
        first.missing = missing;
        first.total = total;
        aggregated.close();
        return first;
    }

    private void trimExcessEntries() {
        if (this.requiredSize >= this.entries.size()) {
            return;
        }
        if (this.entries instanceof List) {
            this.entries = ((List)this.entries).subList(0, this.requiredSize);
            return;
        }
        int i = 0;
        Iterator<LongEntry> iter = this.entries.iterator();
        while (iter.hasNext()) {
            iter.next();
            if (i++ < this.requiredSize) continue;
            iter.remove();
        }
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(this.getName());
        builder.field(Fields._TYPE, "terms");
        builder.field(Fields.MISSING, this.missing);
        builder.field(Fields.TOTAL, this.total);
        builder.field(Fields.OTHER, this.getOtherCount());
        builder.startArray(Fields.TERMS);
        for (LongEntry entry : this.entries) {
            builder.startObject();
            builder.field(Fields.TERM, entry.term);
            builder.field(Fields.COUNT, entry.getCount());
            builder.endObject();
        }
        builder.endArray();
        builder.endObject();
        return builder;
    }

    public static InternalLongTermsFacet readTermsFacet(StreamInput in) throws IOException {
        InternalLongTermsFacet facet = new InternalLongTermsFacet();
        facet.readFrom(in);
        return facet;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.comparatorType = TermsFacet.ComparatorType.fromId(in.readByte());
        this.requiredSize = in.readVInt();
        this.missing = in.readVLong();
        this.total = in.readVLong();
        int size = in.readVInt();
        this.entries = new ArrayList<LongEntry>(size);
        for (int i = 0; i < size; ++i) {
            this.entries.add(new LongEntry(in.readLong(), in.readVInt()));
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeByte(this.comparatorType.id());
        out.writeVInt(this.requiredSize);
        out.writeVLong(this.missing);
        out.writeVLong(this.total);
        out.writeVInt(this.entries.size());
        for (LongEntry entry : this.entries) {
            out.writeLong(entry.term);
            out.writeVInt(entry.getCount());
        }
    }

    static final class Fields {
        static final XContentBuilderString _TYPE = new XContentBuilderString("_type");
        static final XContentBuilderString MISSING = new XContentBuilderString("missing");
        static final XContentBuilderString TOTAL = new XContentBuilderString("total");
        static final XContentBuilderString OTHER = new XContentBuilderString("other");
        static final XContentBuilderString TERMS = new XContentBuilderString("terms");
        static final XContentBuilderString TERM = new XContentBuilderString("term");
        static final XContentBuilderString COUNT = new XContentBuilderString("count");

        Fields() {
        }
    }

    public static class LongEntry
    implements TermsFacet.Entry {
        long term;
        int count;

        public LongEntry(long term, int count) {
            this.term = term;
            this.count = count;
        }

        @Override
        public Text getTerm() {
            return new StringText(Long.toString(this.term));
        }

        @Override
        public Number getTermAsNumber() {
            return this.term;
        }

        @Override
        public int getCount() {
            return this.count;
        }

        @Override
        public int compareTo(TermsFacet.Entry o) {
            long anotherVal = ((LongEntry)o).term;
            if (this.term < anotherVal) {
                return -1;
            }
            if (this.term == anotherVal) {
                int i = this.count - o.getCount();
                if (i == 0) {
                    i = System.identityHashCode(this) - System.identityHashCode(o);
                }
                return i;
            }
            return 1;
        }
    }
}

