/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.lookup;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.elasticsearch.index.mapper.FieldMapper;

public class FieldLookup {
    private final FieldMapper mapper;
    private Map<String, List<Object>> fields;
    private Object value;
    private boolean valueLoaded = false;
    private List<Object> values = new ArrayList<Object>();
    private boolean valuesLoaded = false;

    FieldLookup(FieldMapper mapper) {
        this.mapper = mapper;
    }

    public FieldMapper mapper() {
        return this.mapper;
    }

    public Map<String, List<Object>> fields() {
        return this.fields;
    }

    public void fields(Map<String, List<Object>> fields) {
        this.fields = fields;
    }

    public void clear() {
        this.value = null;
        this.valueLoaded = false;
        this.values.clear();
        this.valuesLoaded = false;
        this.fields = null;
    }

    public boolean isEmpty() {
        if (this.valueLoaded) {
            return this.value == null;
        }
        if (this.valuesLoaded) {
            return this.values.isEmpty();
        }
        return this.getValue() == null;
    }

    public Object getValue() {
        if (this.valueLoaded) {
            return this.value;
        }
        this.valueLoaded = true;
        this.value = null;
        List<Object> values = this.fields.get(this.mapper.names().indexName());
        return values != null ? (this.value = values.get(0)) : null;
    }

    public List<Object> getValues() {
        if (this.valuesLoaded) {
            return this.values;
        }
        this.valuesLoaded = true;
        this.values.clear();
        this.values = this.fields().get(this.mapper.names().indexName());
        return this.values;
    }
}

