/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.snapshots;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CopyOnWriteArrayList;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.cluster.ClusterChangedEvent;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateListener;
import org.elasticsearch.cluster.ProcessedClusterStateUpdateTask;
import org.elasticsearch.cluster.TimeoutClusterStateUpdateTask;
import org.elasticsearch.cluster.block.ClusterBlocks;
import org.elasticsearch.cluster.metadata.AliasMetaData;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.cluster.metadata.IndexTemplateMetaData;
import org.elasticsearch.cluster.metadata.MetaData;
import org.elasticsearch.cluster.metadata.MetaDataCreateIndexService;
import org.elasticsearch.cluster.metadata.MetaDataIndexStateService;
import org.elasticsearch.cluster.metadata.RestoreMetaData;
import org.elasticsearch.cluster.metadata.SnapshotId;
import org.elasticsearch.cluster.routing.IndexRoutingTable;
import org.elasticsearch.cluster.routing.IndexShardRoutingTable;
import org.elasticsearch.cluster.routing.RestoreSource;
import org.elasticsearch.cluster.routing.RoutingTable;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.routing.allocation.AllocationService;
import org.elasticsearch.cluster.routing.allocation.RoutingAllocation;
import org.elasticsearch.cluster.settings.ClusterDynamicSettings;
import org.elasticsearch.cluster.settings.DynamicSettings;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.collect.ImmutableList;
import org.elasticsearch.common.collect.ImmutableMap;
import org.elasticsearch.common.collect.ImmutableSet;
import org.elasticsearch.common.collect.Lists;
import org.elasticsearch.common.collect.Maps;
import org.elasticsearch.common.collect.Sets;
import org.elasticsearch.common.collect.Tuple;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.hppc.IntOpenHashSet;
import org.elasticsearch.common.hppc.IntSet;
import org.elasticsearch.common.hppc.cursors.ObjectCursor;
import org.elasticsearch.common.hppc.cursors.ObjectObjectCursor;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.regex.Regex;
import org.elasticsearch.common.settings.ImmutableSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.util.concurrent.ConcurrentCollections;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.repositories.RepositoriesService;
import org.elasticsearch.repositories.Repository;
import org.elasticsearch.snapshots.ConcurrentSnapshotExecutionException;
import org.elasticsearch.snapshots.RestoreInfo;
import org.elasticsearch.snapshots.Snapshot;
import org.elasticsearch.snapshots.SnapshotRestoreException;
import org.elasticsearch.snapshots.SnapshotShardFailure;
import org.elasticsearch.snapshots.SnapshotUtils;
import org.elasticsearch.transport.BaseTransportRequestHandler;
import org.elasticsearch.transport.EmptyTransportResponseHandler;
import org.elasticsearch.transport.TransportChannel;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.transport.TransportResponse;
import org.elasticsearch.transport.TransportService;

public class RestoreService
extends AbstractComponent
implements ClusterStateListener {
    public static final String UPDATE_RESTORE_ACTION_NAME = "internal:cluster/snapshot/update_restore";
    private static final ImmutableSet<String> UNMODIFIABLE_SETTINGS = ImmutableSet.of("index.number_of_shards", "index.version.created", "index.uuid", "index.creation_date");
    private static final ImmutableSet<String> UNREMOVABLE_SETTINGS = ((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)ImmutableSet.builder().addAll(UNMODIFIABLE_SETTINGS)).add("index.number_of_replicas")).add("index.auto_expand_replicas")).add("index.version.upgraded")).add("index.version.minimum_compatible")).build();
    private final ClusterService clusterService;
    private final RepositoriesService repositoriesService;
    private final TransportService transportService;
    private final AllocationService allocationService;
    private final MetaDataCreateIndexService createIndexService;
    private final DynamicSettings dynamicSettings;
    private final CopyOnWriteArrayList<ActionListener<RestoreCompletionResponse>> listeners = new CopyOnWriteArrayList();
    private final BlockingQueue<UpdateIndexShardRestoreStatusRequest> updatedSnapshotStateQueue = ConcurrentCollections.newBlockingQueue();

    @Inject
    public RestoreService(Settings settings, ClusterService clusterService, RepositoriesService repositoriesService, TransportService transportService, AllocationService allocationService, MetaDataCreateIndexService createIndexService, @ClusterDynamicSettings DynamicSettings dynamicSettings) {
        super(settings);
        this.clusterService = clusterService;
        this.repositoriesService = repositoriesService;
        this.transportService = transportService;
        this.allocationService = allocationService;
        this.createIndexService = createIndexService;
        this.dynamicSettings = dynamicSettings;
        transportService.registerHandler(UPDATE_RESTORE_ACTION_NAME, new UpdateRestoreStateRequestHandler());
        clusterService.add(this);
    }

    public void restoreSnapshot(final RestoreRequest request, final ActionListener<RestoreInfo> listener) {
        try {
            Repository repository = this.repositoriesService.repository(request.repository());
            final SnapshotId snapshotId = new SnapshotId(request.repository(), request.name());
            final Snapshot snapshot = repository.readSnapshot(snapshotId);
            ImmutableList<String> filteredIndices = SnapshotUtils.filterIndices(snapshot.indices(), request.indices(), request.indicesOptions());
            final MetaData metaData = repository.readSnapshotMetaData(snapshotId, filteredIndices);
            this.validateSnapshotRestorable(snapshotId, snapshot);
            final Map<String, String> renamedIndices = this.renamedIndices(request, filteredIndices);
            this.clusterService.submitStateUpdateTask(request.cause(), new TimeoutClusterStateUpdateTask(){
                RestoreInfo restoreInfo = null;

                @Override
                public ClusterState execute(ClusterState currentState) {
                    ImmutableMap<ShardId, RestoreMetaData.ShardRestoreStatus> shards;
                    RestoreMetaData restoreMetaData = (RestoreMetaData)currentState.metaData().custom("restore");
                    if (restoreMetaData != null && !restoreMetaData.entries().isEmpty()) {
                        throw new ConcurrentSnapshotExecutionException(snapshotId, "Restore process is already running in this cluster");
                    }
                    MetaData.Builder mdBuilder = MetaData.builder(currentState.metaData());
                    ClusterBlocks.Builder blocks = ClusterBlocks.builder().blocks(currentState.blocks());
                    RoutingTable.Builder rtBuilder = RoutingTable.builder(currentState.routingTable());
                    HashSet<String> aliases = Sets.newHashSet();
                    if (!renamedIndices.isEmpty()) {
                        ImmutableMap.Builder<ShardId, RestoreMetaData.ShardRestoreStatus> shardsBuilder = ImmutableMap.builder();
                        for (Map.Entry indexEntry : renamedIndices.entrySet()) {
                            IndexMetaData updatedIndexMetaData;
                            IndexMetaData.Builder indexMdBuilder;
                            String index = (String)indexEntry.getValue();
                            boolean partial = this.checkPartial(index);
                            RestoreSource restoreSource = new RestoreSource(snapshotId, index);
                            String renamedIndex = (String)indexEntry.getKey();
                            IndexMetaData snapshotIndexMetaData = metaData.index(index);
                            snapshotIndexMetaData = this.updateIndexSettings(snapshotIndexMetaData, request.indexSettings, request.ignoreIndexSettings);
                            IndexMetaData currentIndexMetaData = currentState.metaData().index(renamedIndex);
                            IntOpenHashSet ignoreShards = new IntOpenHashSet();
                            if (currentIndexMetaData == null) {
                                RestoreService.this.createIndexService.validateIndexName(renamedIndex, currentState);
                                RestoreService.this.createIndexService.validateIndexSettings(renamedIndex, snapshotIndexMetaData.settings(), currentState);
                                indexMdBuilder = IndexMetaData.builder(snapshotIndexMetaData).state(IndexMetaData.State.OPEN).index(renamedIndex);
                                indexMdBuilder.settings(ImmutableSettings.settingsBuilder().put(snapshotIndexMetaData.settings()).put("index.uuid", Strings.randomBase64UUID()));
                                if (!request.includeAliases() && !snapshotIndexMetaData.aliases().isEmpty()) {
                                    indexMdBuilder.removeAllAliases();
                                } else {
                                    for (ObjectCursor<Object> objectCursor : snapshotIndexMetaData.aliases().keys()) {
                                        aliases.add((String)objectCursor.value);
                                    }
                                }
                                updatedIndexMetaData = indexMdBuilder.build();
                                if (partial) {
                                    this.populateIgnoredShards(index, ignoreShards);
                                }
                                rtBuilder.addAsNewRestore(updatedIndexMetaData, restoreSource, ignoreShards);
                                mdBuilder.put(updatedIndexMetaData, true);
                            } else {
                                this.validateExistingIndex(currentIndexMetaData, snapshotIndexMetaData, renamedIndex, partial);
                                indexMdBuilder = IndexMetaData.builder(snapshotIndexMetaData).state(IndexMetaData.State.OPEN);
                                indexMdBuilder.version(Math.max(snapshotIndexMetaData.version(), currentIndexMetaData.version() + 1L));
                                if (!request.includeAliases()) {
                                    if (!snapshotIndexMetaData.aliases().isEmpty()) {
                                        indexMdBuilder.removeAllAliases();
                                    }
                                    for (ObjectCursor<Object> objectCursor : currentIndexMetaData.aliases().values()) {
                                        indexMdBuilder.putAlias((AliasMetaData)objectCursor.value);
                                    }
                                } else {
                                    for (ObjectCursor<Object> objectCursor : snapshotIndexMetaData.aliases().keys()) {
                                        aliases.add((String)objectCursor.value);
                                    }
                                }
                                indexMdBuilder.settings(ImmutableSettings.settingsBuilder().put(snapshotIndexMetaData.settings()).put("index.uuid", currentIndexMetaData.uuid()));
                                updatedIndexMetaData = indexMdBuilder.index(renamedIndex).build();
                                rtBuilder.addAsRestore(updatedIndexMetaData, restoreSource);
                                blocks.removeIndexBlock(renamedIndex, MetaDataIndexStateService.INDEX_CLOSED_BLOCK);
                                mdBuilder.put(updatedIndexMetaData, true);
                            }
                            for (int shard = 0; shard < snapshotIndexMetaData.getNumberOfShards(); ++shard) {
                                if (!ignoreShards.contains(shard)) {
                                    shardsBuilder.put(new ShardId(renamedIndex, shard), new RestoreMetaData.ShardRestoreStatus(RestoreService.this.clusterService.state().nodes().localNodeId()));
                                    continue;
                                }
                                shardsBuilder.put(new ShardId(renamedIndex, shard), new RestoreMetaData.ShardRestoreStatus(RestoreService.this.clusterService.state().nodes().localNodeId(), RestoreMetaData.State.FAILURE));
                            }
                        }
                        shards = shardsBuilder.build();
                        RestoreMetaData.Entry restoreEntry = new RestoreMetaData.Entry(snapshotId, RestoreMetaData.State.INIT, ImmutableList.copyOf(renamedIndices.keySet()), shards);
                        mdBuilder.putCustom("restore", new RestoreMetaData(restoreEntry));
                    } else {
                        shards = ImmutableMap.of();
                    }
                    this.checkAliasNameConflicts(renamedIndices, aliases);
                    this.restoreGlobalStateIfRequested(mdBuilder);
                    if (RestoreService.this.completed(shards)) {
                        this.restoreInfo = new RestoreInfo(request.name(), ImmutableList.copyOf(renamedIndices.keySet()), shards.size(), shards.size() - RestoreService.this.failedShards(shards));
                    }
                    ClusterState updatedState = ClusterState.builder(currentState).metaData(mdBuilder).blocks(blocks).routingTable(rtBuilder).build();
                    RoutingAllocation.Result routingResult = RestoreService.this.allocationService.reroute(ClusterState.builder(updatedState).routingTable(rtBuilder).build());
                    return ClusterState.builder(updatedState).routingResult(routingResult).build();
                }

                private void checkAliasNameConflicts(Map<String, String> renamedIndices2, Set<String> aliases) {
                    for (Map.Entry<String, String> renamedIndex : renamedIndices2.entrySet()) {
                        if (!aliases.contains(renamedIndex.getKey())) continue;
                        throw new SnapshotRestoreException(snapshotId, "cannot rename index [" + renamedIndex.getValue() + "] into [" + renamedIndex.getKey() + "] because of conflict with an alias with the same name");
                    }
                }

                private void populateIgnoredShards(String index, IntSet ignoreShards) {
                    for (SnapshotShardFailure failure : snapshot.shardFailures()) {
                        if (!index.equals(failure.index())) continue;
                        ignoreShards.add(failure.shardId());
                    }
                }

                private boolean checkPartial(String index) {
                    if (RestoreService.this.failed(snapshot, index)) {
                        if (request.partial()) {
                            return true;
                        }
                        throw new SnapshotRestoreException(snapshotId, "index [" + index + "] wasn't fully snapshotted - cannot restore");
                    }
                    return false;
                }

                private void validateExistingIndex(IndexMetaData currentIndexMetaData, IndexMetaData snapshotIndexMetaData, String renamedIndex, boolean partial) {
                    if (currentIndexMetaData.state() != IndexMetaData.State.CLOSE) {
                        throw new SnapshotRestoreException(snapshotId, "cannot restore index [" + renamedIndex + "] because it's open");
                    }
                    if (partial) {
                        throw new SnapshotRestoreException(snapshotId, "cannot restore partial index [" + renamedIndex + "] because such index already exists");
                    }
                    if (currentIndexMetaData.getNumberOfShards() != snapshotIndexMetaData.getNumberOfShards()) {
                        throw new SnapshotRestoreException(snapshotId, "cannot restore index [" + renamedIndex + "] with [" + currentIndexMetaData.getNumberOfShards() + "] shard from snapshot with [" + snapshotIndexMetaData.getNumberOfShards() + "] shards");
                    }
                }

                private IndexMetaData updateIndexSettings(IndexMetaData indexMetaData, Settings changeSettings, String[] ignoreSettings) {
                    if (changeSettings.names().isEmpty() && ignoreSettings.length == 0) {
                        return indexMetaData;
                    }
                    Settings normalizedChangeSettings = ImmutableSettings.settingsBuilder().put(changeSettings).normalizePrefix("index.").build();
                    IndexMetaData.Builder builder = IndexMetaData.builder(indexMetaData);
                    HashMap<String, String> settingsMap = Maps.newHashMap(indexMetaData.settings().getAsMap());
                    ArrayList<String> simpleMatchPatterns = Lists.newArrayList();
                    for (String ignoredSetting : ignoreSettings) {
                        if (!Regex.isSimpleMatchPattern(ignoredSetting)) {
                            if (UNREMOVABLE_SETTINGS.contains(ignoredSetting)) {
                                throw new SnapshotRestoreException(snapshotId, "cannot remove setting [" + ignoredSetting + "] on restore");
                            }
                            settingsMap.remove(ignoredSetting);
                            continue;
                        }
                        simpleMatchPatterns.add(ignoredSetting);
                    }
                    if (!simpleMatchPatterns.isEmpty()) {
                        String[] removePatterns = simpleMatchPatterns.toArray(new String[simpleMatchPatterns.size()]);
                        Iterator iterator = settingsMap.entrySet().iterator();
                        while (iterator.hasNext()) {
                            Map.Entry entry = iterator.next();
                            if (UNREMOVABLE_SETTINGS.contains(entry.getKey()) || !Regex.simpleMatch(removePatterns, (String)entry.getKey())) continue;
                            iterator.remove();
                        }
                    }
                    for (Map.Entry entry : normalizedChangeSettings.getAsMap().entrySet()) {
                        if (UNMODIFIABLE_SETTINGS.contains(entry.getKey())) {
                            throw new SnapshotRestoreException(snapshotId, "cannot modify setting [" + (String)entry.getKey() + "] on restore");
                        }
                        settingsMap.put((String)entry.getKey(), (String)entry.getValue());
                    }
                    return builder.settings(ImmutableSettings.builder().put(settingsMap)).build();
                }

                private void restoreGlobalStateIfRequested(MetaData.Builder mdBuilder) {
                    if (request.includeGlobalState()) {
                        if (metaData.persistentSettings() != null) {
                            boolean changed = false;
                            ImmutableSettings.Builder builder = ImmutableSettings.settingsBuilder().put(new Object[0]);
                            for (Map.Entry entry : metaData.persistentSettings().getAsMap().entrySet()) {
                                if (RestoreService.this.dynamicSettings.isDynamicOrLoggingSetting((String)entry.getKey())) {
                                    String error = RestoreService.this.dynamicSettings.validateDynamicSetting((String)entry.getKey(), (String)entry.getValue());
                                    if (error == null) {
                                        builder.put((String)entry.getKey(), (String)entry.getValue());
                                        changed = true;
                                        continue;
                                    }
                                    RestoreService.this.logger.warn("ignoring persistent setting [{}], [{}]", entry.getKey(), error);
                                    continue;
                                }
                                RestoreService.this.logger.warn("ignoring persistent setting [{}], not dynamically updateable", entry.getKey());
                            }
                            if (changed) {
                                mdBuilder.persistentSettings(builder.build());
                            }
                        }
                        if (metaData.templates() != null) {
                            for (ObjectCursor<IndexTemplateMetaData> objectCursor : metaData.templates().values()) {
                                mdBuilder.put((IndexTemplateMetaData)objectCursor.value);
                            }
                        }
                        if (metaData.customs() != null) {
                            for (ObjectObjectCursor<String, MetaData.Custom> objectObjectCursor : metaData.customs()) {
                                if ("repositories".equals(objectObjectCursor.key)) continue;
                                mdBuilder.putCustom((String)objectObjectCursor.key, (MetaData.Custom)objectObjectCursor.value);
                            }
                        }
                    }
                }

                @Override
                public void onFailure(String source, Throwable t) {
                    RestoreService.this.logger.warn("[{}] failed to restore snapshot", t, snapshotId);
                    listener.onFailure(t);
                }

                @Override
                public TimeValue timeout() {
                    return request.masterNodeTimeout();
                }

                @Override
                public void clusterStateProcessed(String source, ClusterState oldState, ClusterState newState) {
                    listener.onResponse(this.restoreInfo);
                }
            });
        }
        catch (Throwable e) {
            this.logger.warn("[{}][{}] failed to restore snapshot", e, request.repository(), request.name());
            listener.onFailure(e);
        }
    }

    public void indexShardRestoreCompleted(SnapshotId snapshotId, ShardId shardId) {
        this.logger.trace("[{}] successfully restored shard  [{}]", snapshotId, shardId);
        UpdateIndexShardRestoreStatusRequest request = new UpdateIndexShardRestoreStatusRequest(snapshotId, shardId, new RestoreMetaData.ShardRestoreStatus(this.clusterService.state().nodes().localNodeId(), RestoreMetaData.State.SUCCESS));
        if (this.clusterService.state().nodes().localNodeMaster()) {
            this.innerUpdateRestoreState(request);
        } else {
            this.transportService.sendRequest(this.clusterService.state().nodes().masterNode(), UPDATE_RESTORE_ACTION_NAME, request, EmptyTransportResponseHandler.INSTANCE_SAME);
        }
    }

    private void innerUpdateRestoreState(final UpdateIndexShardRestoreStatusRequest request) {
        this.logger.trace("received updated snapshot restore state [{}]", request);
        this.updatedSnapshotStateQueue.add(request);
        this.clusterService.submitStateUpdateTask("update snapshot state", new ProcessedClusterStateUpdateTask(){
            private final List<UpdateIndexShardRestoreStatusRequest> drainedRequests = new ArrayList<UpdateIndexShardRestoreStatusRequest>();
            private Map<SnapshotId, Tuple<RestoreInfo, Map<ShardId, RestoreMetaData.ShardRestoreStatus>>> batchedRestoreInfo = null;

            @Override
            public ClusterState execute(ClusterState currentState) {
                if (request.processed) {
                    return currentState;
                }
                RestoreService.this.updatedSnapshotStateQueue.drainTo(this.drainedRequests);
                int batchSize = this.drainedRequests.size();
                if (batchSize == 0) {
                    return currentState;
                }
                MetaData metaData = currentState.metaData();
                RestoreMetaData restore = (RestoreMetaData)metaData.custom("restore");
                if (restore != null) {
                    int changedCount = 0;
                    ArrayList<RestoreMetaData.Entry> entries = Lists.newArrayList();
                    for (RestoreMetaData.Entry entry : restore.entries()) {
                        HashMap<ShardId, RestoreMetaData.ShardRestoreStatus> shards = null;
                        for (int i = 0; i < batchSize; ++i) {
                            UpdateIndexShardRestoreStatusRequest updateSnapshotState = this.drainedRequests.get(i);
                            updateSnapshotState.processed = true;
                            if (!entry.snapshotId().equals(updateSnapshotState.snapshotId())) continue;
                            RestoreService.this.logger.trace("[{}] Updating shard [{}] with status [{}]", new Object[]{updateSnapshotState.snapshotId(), updateSnapshotState.shardId(), updateSnapshotState.status().state()});
                            if (shards == null) {
                                shards = Maps.newHashMap(entry.shards());
                            }
                            shards.put(updateSnapshotState.shardId(), updateSnapshotState.status());
                            ++changedCount;
                        }
                        if (shards != null) {
                            if (!RestoreService.this.completed(shards)) {
                                entries.add(new RestoreMetaData.Entry(entry.snapshotId(), RestoreMetaData.State.STARTED, entry.indices(), ImmutableMap.copyOf(shards)));
                                continue;
                            }
                            RestoreService.this.logger.info("restore [{}] is done", entry.snapshotId());
                            if (this.batchedRestoreInfo == null) {
                                this.batchedRestoreInfo = Maps.newHashMap();
                            }
                            assert (!this.batchedRestoreInfo.containsKey(entry.snapshotId()));
                            this.batchedRestoreInfo.put(entry.snapshotId(), new Tuple<RestoreInfo, HashMap<ShardId, RestoreMetaData.ShardRestoreStatus>>(new RestoreInfo(entry.snapshotId().getSnapshot(), entry.indices(), shards.size(), shards.size() - RestoreService.this.failedShards(shards)), shards));
                            continue;
                        }
                        entries.add(entry);
                    }
                    if (changedCount > 0) {
                        RestoreService.this.logger.trace("changed cluster state triggered by {} snapshot restore state updates", changedCount);
                        RestoreMetaData updatedRestore = new RestoreMetaData(entries.toArray(new RestoreMetaData.Entry[entries.size()]));
                        MetaData.Builder mdBuilder = MetaData.builder(currentState.metaData()).putCustom("restore", updatedRestore);
                        return ClusterState.builder(currentState).metaData(mdBuilder).build();
                    }
                }
                return currentState;
            }

            @Override
            public void onFailure(String source, @Nullable Throwable t) {
                for (UpdateIndexShardRestoreStatusRequest request2 : this.drainedRequests) {
                    RestoreService.this.logger.warn("[{}][{}] failed to update snapshot status to [{}]", t, request2.snapshotId(), request2.shardId(), request2.status());
                }
            }

            @Override
            public void clusterStateProcessed(String source, ClusterState oldState, ClusterState newState) {
                if (this.batchedRestoreInfo != null) {
                    for (Map.Entry<SnapshotId, Tuple<RestoreInfo, Map<ShardId, RestoreMetaData.ShardRestoreStatus>>> entry : this.batchedRestoreInfo.entrySet()) {
                        final SnapshotId snapshotId = entry.getKey();
                        final RestoreInfo restoreInfo = entry.getValue().v1();
                        Map<ShardId, RestoreMetaData.ShardRestoreStatus> shards = entry.getValue().v2();
                        RoutingTable routingTable = newState.getRoutingTable();
                        final ArrayList<ShardId> waitForStarted = Lists.newArrayList();
                        for (Map.Entry<ShardId, RestoreMetaData.ShardRestoreStatus> shard : shards.entrySet()) {
                            ShardId shardId;
                            ShardRouting shardRouting;
                            if (shard.getValue().state() != RestoreMetaData.State.SUCCESS || (shardRouting = this.findPrimaryShard(routingTable, shardId = shard.getKey())) == null || shardRouting.active()) continue;
                            RestoreService.this.logger.trace("[{}][{}] waiting for the shard to start", snapshotId, shardId);
                            waitForStarted.add(shardId);
                        }
                        if (waitForStarted.isEmpty()) {
                            this.notifyListeners(snapshotId, restoreInfo);
                            continue;
                        }
                        RestoreService.this.clusterService.addLast(new ClusterStateListener(){

                            @Override
                            public void clusterChanged(ClusterChangedEvent event) {
                                if (event.routingTableChanged()) {
                                    RoutingTable routingTable = event.state().getRoutingTable();
                                    Iterator iterator = waitForStarted.iterator();
                                    while (iterator.hasNext()) {
                                        ShardId shardId = (ShardId)iterator.next();
                                        ShardRouting shardRouting = this.findPrimaryShard(routingTable, shardId);
                                        if (shardRouting != null && !shardRouting.active()) continue;
                                        iterator.remove();
                                        RestoreService.this.logger.trace("[{}][{}] shard disappeared or started - removing", snapshotId, shardId);
                                    }
                                }
                                if (waitForStarted.isEmpty()) {
                                    this.notifyListeners(snapshotId, restoreInfo);
                                    RestoreService.this.clusterService.remove(this);
                                }
                            }
                        });
                    }
                }
            }

            private ShardRouting findPrimaryShard(RoutingTable routingTable, ShardId shardId) {
                IndexShardRoutingTable indexShardRoutingTable;
                IndexRoutingTable indexRoutingTable = routingTable.index(shardId.getIndex());
                if (indexRoutingTable != null && (indexShardRoutingTable = indexRoutingTable.shard(shardId.id())) != null) {
                    return indexShardRoutingTable.primaryShard();
                }
                return null;
            }

            private void notifyListeners(SnapshotId snapshotId, RestoreInfo restoreInfo) {
                for (ActionListener listener : RestoreService.this.listeners) {
                    try {
                        listener.onResponse(new RestoreCompletionResponse(snapshotId, restoreInfo));
                    }
                    catch (Throwable e) {
                        RestoreService.this.logger.warn("failed to update snapshot status for [{}]", e, listener);
                    }
                }
            }
        });
    }

    private boolean completed(Map<ShardId, RestoreMetaData.ShardRestoreStatus> shards) {
        for (RestoreMetaData.ShardRestoreStatus status : shards.values()) {
            if (status.state().completed()) continue;
            return false;
        }
        return true;
    }

    private int failedShards(Map<ShardId, RestoreMetaData.ShardRestoreStatus> shards) {
        int failedShards = 0;
        for (RestoreMetaData.ShardRestoreStatus status : shards.values()) {
            if (status.state() != RestoreMetaData.State.FAILURE) continue;
            ++failedShards;
        }
        return failedShards;
    }

    private Map<String, String> renamedIndices(RestoreRequest request, ImmutableList<String> filteredIndices) {
        HashMap<String, String> renamedIndices = Maps.newHashMap();
        Iterator i$ = filteredIndices.iterator();
        while (i$.hasNext()) {
            String previousIndex;
            String index;
            String renamedIndex = index = (String)i$.next();
            if (request.renameReplacement() != null && request.renamePattern() != null) {
                renamedIndex = index.replaceAll(request.renamePattern(), request.renameReplacement());
            }
            if ((previousIndex = renamedIndices.put(renamedIndex, index)) == null) continue;
            throw new SnapshotRestoreException(new SnapshotId(request.repository(), request.name()), "indices [" + index + "] and [" + previousIndex + "] are renamed into the same index [" + renamedIndex + "]");
        }
        return renamedIndices;
    }

    private void validateSnapshotRestorable(SnapshotId snapshotId, Snapshot snapshot) {
        if (!snapshot.state().restorable()) {
            throw new SnapshotRestoreException(snapshotId, "unsupported snapshot state [" + (Object)((Object)snapshot.state()) + "]");
        }
        if (Version.CURRENT.before(snapshot.version())) {
            throw new SnapshotRestoreException(snapshotId, "the snapshot was created with Elasticsearch version [" + snapshot.version() + "] which is higher than the version of this node [" + Version.CURRENT + "]");
        }
    }

    private void processDeletedIndices(ClusterChangedEvent event) {
        MetaData metaData = event.state().metaData();
        RestoreMetaData restore = (RestoreMetaData)metaData.custom("restore");
        if (restore == null) {
            return;
        }
        if (!event.indicesDeleted().isEmpty()) {
            for (RestoreMetaData.Entry entry : restore.entries()) {
                ArrayList<ShardId> shardsToFail = null;
                for (Map.Entry shard : entry.shards().entrySet()) {
                    if (((RestoreMetaData.ShardRestoreStatus)shard.getValue()).state().completed() || event.state().metaData().hasIndex(((ShardId)shard.getKey()).getIndex())) continue;
                    if (shardsToFail == null) {
                        shardsToFail = Lists.newArrayList();
                    }
                    shardsToFail.add((ShardId)shard.getKey());
                }
                if (shardsToFail == null) continue;
                for (ShardId shardId : shardsToFail) {
                    this.logger.trace("[{}] failing running shard restore [{}]", entry.snapshotId(), shardId);
                    this.innerUpdateRestoreState(new UpdateIndexShardRestoreStatusRequest(entry.snapshotId(), shardId, new RestoreMetaData.ShardRestoreStatus(null, RestoreMetaData.State.FAILURE, "index was deleted")));
                }
            }
        }
    }

    public void failRestore(SnapshotId snapshotId, ShardId shardId) {
        this.logger.debug("[{}] failed to restore shard  [{}]", snapshotId, shardId);
        UpdateIndexShardRestoreStatusRequest request = new UpdateIndexShardRestoreStatusRequest(snapshotId, shardId, new RestoreMetaData.ShardRestoreStatus(this.clusterService.state().nodes().localNodeId(), RestoreMetaData.State.FAILURE));
        if (this.clusterService.state().nodes().localNodeMaster()) {
            this.innerUpdateRestoreState(request);
        } else {
            this.transportService.sendRequest(this.clusterService.state().nodes().masterNode(), UPDATE_RESTORE_ACTION_NAME, request, EmptyTransportResponseHandler.INSTANCE_SAME);
        }
    }

    private boolean failed(Snapshot snapshot, String index) {
        for (SnapshotShardFailure failure : snapshot.shardFailures()) {
            if (!index.equals(failure.index())) continue;
            return true;
        }
        return false;
    }

    public void addListener(ActionListener<RestoreCompletionResponse> listener) {
        this.listeners.add(listener);
    }

    public void removeListener(ActionListener<RestoreCompletionResponse> listener) {
        this.listeners.remove(listener);
    }

    @Override
    public void clusterChanged(ClusterChangedEvent event) {
        try {
            if (event.localNodeMaster()) {
                this.processDeletedIndices(event);
            }
        }
        catch (Throwable t) {
            this.logger.warn("Failed to update restore state ", t, new Object[0]);
        }
    }

    public static boolean isRepositoryInUse(ClusterState clusterState, String repository) {
        MetaData metaData = clusterState.metaData();
        RestoreMetaData snapshots = (RestoreMetaData)metaData.custom("restore");
        if (snapshots != null) {
            for (RestoreMetaData.Entry snapshot : snapshots.entries()) {
                if (!repository.equals(snapshot.snapshotId().getRepository())) continue;
                return true;
            }
        }
        return false;
    }

    private class UpdateRestoreStateRequestHandler
    extends BaseTransportRequestHandler<UpdateIndexShardRestoreStatusRequest> {
        private UpdateRestoreStateRequestHandler() {
        }

        @Override
        public UpdateIndexShardRestoreStatusRequest newInstance() {
            return new UpdateIndexShardRestoreStatusRequest();
        }

        @Override
        public void messageReceived(UpdateIndexShardRestoreStatusRequest request, TransportChannel channel) throws Exception {
            RestoreService.this.innerUpdateRestoreState(request);
            channel.sendResponse(TransportResponse.Empty.INSTANCE);
        }

        @Override
        public String executor() {
            return "same";
        }
    }

    private static class UpdateIndexShardRestoreStatusRequest
    extends TransportRequest {
        private SnapshotId snapshotId;
        private ShardId shardId;
        private RestoreMetaData.ShardRestoreStatus status;
        volatile boolean processed;

        private UpdateIndexShardRestoreStatusRequest() {
        }

        private UpdateIndexShardRestoreStatusRequest(SnapshotId snapshotId, ShardId shardId, RestoreMetaData.ShardRestoreStatus status) {
            this.snapshotId = snapshotId;
            this.shardId = shardId;
            this.status = status;
        }

        @Override
        public void readFrom(StreamInput in) throws IOException {
            super.readFrom(in);
            this.snapshotId = SnapshotId.readSnapshotId(in);
            this.shardId = ShardId.readShardId(in);
            this.status = RestoreMetaData.ShardRestoreStatus.readShardRestoreStatus(in);
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            this.snapshotId.writeTo(out);
            this.shardId.writeTo(out);
            this.status.writeTo(out);
        }

        public SnapshotId snapshotId() {
            return this.snapshotId;
        }

        public ShardId shardId() {
            return this.shardId;
        }

        public RestoreMetaData.ShardRestoreStatus status() {
            return this.status;
        }

        public String toString() {
            return "" + this.snapshotId + ", shardId [" + this.shardId + "], status [" + (Object)((Object)this.status.state()) + "]";
        }
    }

    public static class RestoreRequest {
        private final String cause;
        private final String name;
        private final String repository;
        private final String[] indices;
        private final String renamePattern;
        private final String renameReplacement;
        private final IndicesOptions indicesOptions;
        private final Settings settings;
        private final TimeValue masterNodeTimeout;
        private final boolean includeGlobalState;
        private final boolean partial;
        private final boolean includeAliases;
        private final Settings indexSettings;
        private final String[] ignoreIndexSettings;

        public RestoreRequest(String cause, String repository, String name, String[] indices, IndicesOptions indicesOptions, String renamePattern, String renameReplacement, Settings settings, TimeValue masterNodeTimeout, boolean includeGlobalState, boolean partial, boolean includeAliases, Settings indexSettings, String[] ignoreIndexSettings) {
            this.cause = cause;
            this.name = name;
            this.repository = repository;
            this.indices = indices;
            this.renamePattern = renamePattern;
            this.renameReplacement = renameReplacement;
            this.indicesOptions = indicesOptions;
            this.settings = settings;
            this.masterNodeTimeout = masterNodeTimeout;
            this.includeGlobalState = includeGlobalState;
            this.partial = partial;
            this.includeAliases = includeAliases;
            this.indexSettings = indexSettings;
            this.ignoreIndexSettings = ignoreIndexSettings;
        }

        public String cause() {
            return this.cause;
        }

        public String name() {
            return this.name;
        }

        public String repository() {
            return this.repository;
        }

        public String[] indices() {
            return this.indices;
        }

        public IndicesOptions indicesOptions() {
            return this.indicesOptions;
        }

        public String renamePattern() {
            return this.renamePattern;
        }

        public String renameReplacement() {
            return this.renameReplacement;
        }

        public Settings settings() {
            return this.settings;
        }

        public boolean includeGlobalState() {
            return this.includeGlobalState;
        }

        public boolean partial() {
            return this.partial;
        }

        public boolean includeAliases() {
            return this.includeAliases;
        }

        public Settings indexSettings() {
            return this.indexSettings;
        }

        public String[] ignoreIndexSettings() {
            return this.ignoreIndexSettings;
        }

        public TimeValue masterNodeTimeout() {
            return this.masterNodeTimeout;
        }
    }

    public static final class RestoreCompletionResponse {
        private final SnapshotId snapshotId;
        private final RestoreInfo restoreInfo;

        private RestoreCompletionResponse(SnapshotId snapshotId, RestoreInfo restoreInfo) {
            this.snapshotId = snapshotId;
            this.restoreInfo = restoreInfo;
        }

        public SnapshotId getSnapshotId() {
            return this.snapshotId;
        }

        public RestoreInfo getRestoreInfo() {
            return this.restoreInfo;
        }
    }
}

