/*
 * Decompiled with CFR 0.152.
 */
package fit.decorator.util;

import fit.Parse;
import fit.decorator.exceptions.InvalidInputException;
import fit.decorator.util.Delta;
import java.text.ParseException;

public class Table {
    private final Parse table;

    public Table(Parse table) {
        this.table = table;
    }

    public Table(String html) throws ParseException {
        this.table = new Parse(html);
    }

    public Parse incrementColumnValues(int numberOfTimes, String columnName, Delta delta) throws InvalidInputException {
        int headerRowIndex = this.rowNumberContainingText(columnName);
        this.copyAndAppendLastRow(numberOfTimes - 1);
        this.incrementColumnValues(columnName, delta, headerRowIndex);
        return this.table;
    }

    public void insertAsFirstRow(Parse firstRow) {
        firstRow.more = this.table.parts;
        this.table.parts = firstRow;
    }

    public Parse stripFirstRow() {
        Parse firstRow = this.table.parts;
        this.table.parts = this.table.parts.more;
        return firstRow;
    }

    public String toString() {
        return this.toSimpleText(this.table, new StringBuffer());
    }

    int columnNumberContainingText(String columnName, int headerRowIndex) throws InvalidInputException {
        int columnNumber = -1;
        Parse columns = this.table.at(0, headerRowIndex, 0);
        while (columns != null) {
            ++columnNumber;
            if (columnName.equals(columns.text())) {
                return columnNumber;
            }
            columns = columns.more;
        }
        throw new InvalidInputException(this.errorMsg(columnName));
    }

    String columnValue(int rowIndex, int columnIndex) {
        return this.table.at(0, rowIndex, columnIndex).text();
    }

    public void copyAndAppendLastRow(int numberOfTimes) {
        if (numberOfTimes > 0 && this.tableHasMoreThanTwoRows()) {
            Parse lastRow = this.lastRow();
            Parse secondLastRow = this.secondLastRow(lastRow);
            this.copyAndAppend(lastRow, numberOfTimes);
            secondLastRow.more = lastRow;
        }
    }

    void incrementColumnValues(String columnName, Delta delta, int headerRowIndex) throws InvalidInputException {
        int columnNumber = this.columnNumberContainingText(columnName, headerRowIndex);
        int totalNumberOfRows = this.numberOfRows();
        for (int i = headerRowIndex + 2; i < totalNumberOfRows; ++i) {
            Parse columnToBeUpdated = this.table.at(0, i, columnNumber);
            String value = columnToBeUpdated.text();
            columnToBeUpdated.body = value = delta.addTo(value, i - headerRowIndex - 1);
        }
    }

    Parse lastRow() {
        return this.table.parts.last();
    }

    int numberOfRows() {
        return this.table.parts.size();
    }

    int rowNumberContainingText(String searchText) throws InvalidInputException {
        Parse rows = this.table.at(0, 0);
        int numberOfRows = rows.size();
        for (int i = 0; i < numberOfRows; ++i) {
            Parse columns = this.table.at(0, i, 0);
            int numberOfColumns = columns.size();
            for (int j = 0; j < numberOfColumns; ++j) {
                if (!searchText.equals(this.table.at(0, i, j).text())) continue;
                return i;
            }
        }
        throw new InvalidInputException(this.errorMsg(searchText));
    }

    Parse secondLastRow(Parse lastRow) {
        Parse nextRow = this.table.parts;
        Parse currentRow = null;
        while (nextRow != lastRow) {
            currentRow = nextRow;
            nextRow = nextRow.more;
        }
        currentRow.more = null;
        return currentRow;
    }

    private void copyAndAppend(Parse lastRow, int numberOfTimes) {
        for (int i = 0; i < numberOfTimes; ++i) {
            Parse newRow;
            Parse columns = lastRow.parts;
            Parse nextColumn = columns.more;
            Parse newNextColumn = this.newParse(nextColumn, nextColumn.more);
            Parse newColumn = this.newParse(columns, newNextColumn);
            lastRow.last().more = newRow = new Parse(this.stripAngularBrackets(lastRow.tag), lastRow.body, newColumn, null);
        }
    }

    private Parse newParse(Parse columns, Parse nextColumn) {
        return new Parse(this.stripAngularBrackets(columns.tag), columns.body, columns.parts, nextColumn);
    }

    private String errorMsg(String searchText) {
        return "'" + searchText + "' was not found in the table " + this.toString();
    }

    private void simpleTextOfLeave(Parse table, StringBuffer returnText) {
        returnText.append(table.tag).append(table.text()).append(table.end);
    }

    private void simpleTextOfMore(Parse table, StringBuffer returnText) {
        if (table.more != null) {
            this.toSimpleText(table.more, returnText);
        }
    }

    private void simpleTextOfParts(Parse table, StringBuffer returnText) {
        returnText.append(table.tag);
        this.toSimpleText(table.parts, returnText);
        returnText.append(table.end);
    }

    private String stripAngularBrackets(String tag) {
        return tag.substring(1, tag.length() - 1);
    }

    private String toSimpleText(Parse table, StringBuffer returnText) {
        if (table.parts == null) {
            this.simpleTextOfLeave(table, returnText);
            this.simpleTextOfMore(table, returnText);
            return returnText.toString();
        }
        this.simpleTextOfParts(table, returnText);
        this.simpleTextOfMore(table, returnText);
        return returnText.toString();
    }

    public Parse table() {
        return this.table;
    }

    public Parse incrementColumnValuesByDelta(String columnName, Delta delta) throws InvalidInputException {
        int headerRowIndex = this.rowNumberContainingText(columnName);
        this.incrementColumnValues(columnName, delta, headerRowIndex);
        return this.table;
    }

    private boolean tableHasMoreThanTwoRows() {
        return this.table.parts.size() > 2;
    }
}

