/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.authentication;

import fitnesse.authentication.HashingCipher;
import fitnesse.authentication.PasswordCipher;
import fitnesse.authentication.PasswordFile;
import java.io.BufferedReader;
import java.io.InputStreamReader;

public class Password {
    public static final String defaultFile = "passwords.txt";
    public static final String defaultCipher = "fitnesse.authentication.HashingCipher";
    private static BufferedReader input;
    private PasswordFile passwords;
    private String username;
    private String password;
    private PasswordCipher cipher = new HashingCipher();

    public static void main(String[] args) throws Exception {
        Password password = new Password();
        if (!password.args(args)) {
            Password.printUsage();
        }
        input = new BufferedReader(new InputStreamReader(System.in));
        password.interactForPassword();
        password.savePassword();
        System.out.println("password saved in " + password.passwords.getName());
    }

    public static void printUsage() {
        System.err.println("Usage: java fitnesse.authentication.Password [-f <password file>] [-c <password cipher>] <user>");
        System.err.println("\t-f <password file> {passwords.txt}");
        System.err.println("\t-c <password cipher> {fitnesse.authentication.HashingCipher}");
        System.exit(-1);
    }

    public Password(String filename) throws Exception {
        this.passwords = new PasswordFile(filename, this.cipher);
    }

    public Password() throws Exception {
        this(defaultFile);
    }

    public void savePassword() throws Exception {
        this.passwords.savePassword(this.username, this.password);
    }

    public boolean args(String[] args) {
        if (args.length < 1 || args.length > 5) {
            return false;
        }
        try {
            boolean done = false;
            int argIndex = 0;
            while (!done) {
                if (args[argIndex].startsWith("-")) {
                    if ("-f".equals(args[argIndex])) {
                        this.passwords = new PasswordFile(args[argIndex + 1], this.cipher);
                        argIndex += 2;
                        continue;
                    }
                    if ("-c".equals(args[argIndex])) {
                        this.cipher = this.passwords.instantiateCipher(args[argIndex + 1]);
                        argIndex += 2;
                        continue;
                    }
                    return false;
                }
                this.username = args[argIndex];
                done = true;
            }
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public String getUsername() {
        return this.username;
    }

    public String getFilename() {
        return this.passwords.getName();
    }

    public PasswordCipher getCipher() {
        return this.cipher;
    }

    private void interactForPassword() throws Exception {
        while (this.password == null) {
            System.out.println("Be advised, the password will be visible as it is typed.");
            System.out.print("enter password for " + this.username + ": ");
            String password1 = this.getUserEntry();
            System.out.print("confirm password: ");
            String password2 = this.getUserEntry();
            if (password1 != null && password1.equals(password2)) {
                this.password = password1;
                continue;
            }
            System.out.println("");
            System.out.println("passwords did not match");
        }
    }

    private String getUserEntry() throws Exception {
        return input.readLine();
    }
}

