/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.authentication;

import fitnesse.FitNesseContext;
import fitnesse.authentication.SecureOperation;
import fitnesse.components.TraversalListener;
import fitnesse.http.Request;
import fitnesse.wiki.MockingPageCrawler;
import fitnesse.wiki.PageCrawler;
import fitnesse.wiki.PageData;
import fitnesse.wiki.PathParser;
import fitnesse.wiki.WikiPage;
import fitnesse.wiki.WikiPagePath;

public abstract class SecurePageOperation
implements SecureOperation {
    protected abstract String getSecurityMode();

    @Override
    public boolean shouldAuthenticate(FitNesseContext context, Request request) {
        WikiPagePath path = PathParser.parse(request.getResource());
        PageCrawler crawler = context.getRootPage().getPageCrawler();
        WikiPage page = crawler.getPage(path, new MockingPageCrawler());
        if (page == null) {
            return false;
        }
        final boolean[] found = new boolean[1];
        page.getPageCrawler().traversePageAndAncestors((TraversalListener<? super WikiPage>)new TraversalListener<WikiPage>(){

            @Override
            public void process(WikiPage page) {
                if (SecurePageOperation.this.hasSecurityModeAttribute(page)) {
                    found[0] = true;
                }
            }
        });
        return found[0];
    }

    private boolean hasSecurityModeAttribute(WikiPage ancestor) {
        PageData data = ancestor.getData();
        return data.hasAttribute(this.getSecurityMode());
    }
}

