/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.fixtures;

import fit.Fixture;
import fit.Parse;
import fit.exception.FitFailureException;

public abstract class TableFixture
extends Fixture {
    protected Parse firstRow;

    @Override
    public void doRows(Parse rows) {
        this.firstRow = rows;
        if (rows == null) {
            throw new FitFailureException("There are no rows in this table");
        }
        this.doStaticTable(rows.size());
    }

    protected abstract void doStaticTable(int var1);

    protected Parse getCell(int row, int column) {
        return this.firstRow.at(row, column);
    }

    protected String getText(int row, int column) {
        return this.getCell(row, column).text();
    }

    protected boolean blank(int row, int column) {
        return this.getText(row, column).equals("");
    }

    protected void wrong(int row, int column) {
        this.wrong(this.getCell(row, column));
    }

    protected void right(int row, int column) {
        this.right(this.getCell(row, column));
    }

    protected void wrong(int row, int column, String actual) {
        this.wrong(this.getCell(row, column), actual);
    }

    protected void ignore(int row, int column) {
        this.ignore(this.getCell(row, column));
    }

    protected int getInt(int row, int column) {
        int i = 0;
        String text = this.getText(row, column);
        if (text.equals("")) {
            this.ignore(row, column);
            return 0;
        }
        try {
            i = Integer.parseInt(text);
        }
        catch (NumberFormatException e) {
            this.wrong(row, column);
        }
        return i;
    }
}

