/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.junit;

import fitnesse.testrunner.TestsRunnerListener;
import fitnesse.testsystems.Assertion;
import fitnesse.testsystems.ExceptionResult;
import fitnesse.testsystems.ExecutionResult;
import fitnesse.testsystems.TestPage;
import fitnesse.testsystems.TestResult;
import fitnesse.testsystems.TestSummary;
import fitnesse.testsystems.TestSystem;
import fitnesse.testsystems.TestSystemListener;
import java.io.Closeable;
import java.io.IOException;
import org.junit.runner.Description;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunNotifier;

public class JUnitRunNotifierResultsListener
implements TestSystemListener,
TestsRunnerListener,
Closeable {
    private final Class<?> mainClass;
    private final RunNotifier notifier;
    private int totalNumberOfTests;
    private int completedTests;
    private Throwable firstFailure;

    public JUnitRunNotifierResultsListener(RunNotifier notifier, Class<?> mainClass) {
        this.notifier = notifier;
        this.mainClass = mainClass;
    }

    @Override
    public void announceNumberTestsToRun(int testsToRun) {
        this.totalNumberOfTests = testsToRun;
    }

    @Override
    public void unableToStartTestSystem(String testSystemName, Throwable cause) throws IOException {
        this.notifyOfTestSystemException(testSystemName, cause);
    }

    @Override
    public void testStarted(TestPage test) {
        this.firstFailure = null;
        this.notifier.fireTestStarted(this.descriptionFor(test));
    }

    @Override
    public void testComplete(TestPage test, TestSummary testSummary) {
        this.increaseCompletedTests();
        if (this.firstFailure != null) {
            this.notifier.fireTestFailure(new Failure(this.descriptionFor(test), this.firstFailure));
        } else if (testSummary.getExceptions() > 0) {
            this.notifier.fireTestFailure(new Failure(this.descriptionFor(test), (Throwable)new Exception("Exception occurred on page " + test.getFullPath())));
        } else if (testSummary.getWrong() > 0) {
            this.notifier.fireTestFailure(new Failure(this.descriptionFor(test), (Throwable)((Object)new AssertionError((Object)("Test failures occurred on page " + test.getFullPath())))));
        } else {
            this.notifier.fireTestFinished(this.descriptionFor(test));
        }
    }

    @Override
    public void testOutputChunk(String output) {
    }

    @Override
    public void testAssertionVerified(Assertion assertion, TestResult testResult) {
        if (testResult != null && testResult.doesCount() && (testResult.getExecutionResult() == ExecutionResult.FAIL || testResult.getExecutionResult() == ExecutionResult.ERROR)) {
            this.firstFailure(testResult.getExecutionResult(), this.createMessage(testResult));
        }
    }

    @Override
    public void testExceptionOccurred(Assertion assertion, ExceptionResult exceptionResult) {
        this.firstFailure(exceptionResult.getExecutionResult(), exceptionResult.getMessage());
    }

    @Override
    public void testSystemStarted(TestSystem testSystem) {
    }

    @Override
    public void testSystemStopped(TestSystem testSystem, Throwable cause) {
        this.notifyOfTestSystemException(testSystem.getName(), cause);
    }

    @Override
    public void close() {
        if (this.completedTests != this.totalNumberOfTests) {
            String msg = String.format("Not all tests executed. Completed %s of %s tests.", this.completedTests, this.totalNumberOfTests);
            Exception e = new Exception(msg);
            this.notifier.fireTestFailure(new Failure(Description.createSuiteDescription(this.mainClass), (Throwable)e));
        }
    }

    protected void notifyOfTestSystemException(String testSystemName, Throwable cause) {
        if (cause != null) {
            Exception e = new Exception("Exception while executing tests using: " + testSystemName, cause);
            this.notifier.fireTestFailure(new Failure(Description.createSuiteDescription(this.mainClass), (Throwable)e));
        }
    }

    private Description descriptionFor(TestPage test) {
        return Description.createTestDescription(this.mainClass, (String)test.getFullPath());
    }

    String createMessage(TestResult testResult) {
        if (testResult.hasActual() && testResult.hasExpected()) {
            return String.format("[%s] expected [%s]", testResult.getActual(), testResult.getExpected());
        }
        if ((testResult.hasActual() || testResult.hasExpected()) && testResult.hasMessage()) {
            return String.format("[%s] %s", testResult.hasActual() ? testResult.getActual() : testResult.getExpected(), testResult.getMessage());
        }
        return testResult.getMessage();
    }

    private void firstFailure(ExecutionResult executionResult, String message) {
        if (this.firstFailure != null) {
            return;
        }
        this.firstFailure = executionResult == ExecutionResult.ERROR ? new Exception(message) : new AssertionError((Object)message);
    }

    public Class<?> getMainClass() {
        return this.mainClass;
    }

    public RunNotifier getNotifier() {
        return this.notifier;
    }

    public int getTotalNumberOfTests() {
        return this.totalNumberOfTests;
    }

    protected void increaseCompletedTests() {
        ++this.completedTests;
    }

    public int getCompletedTests() {
        return this.completedTests;
    }

    public Throwable getFirstFailure() {
        return this.firstFailure;
    }

    protected void setFirstFailure(Throwable firstFailure) {
        this.firstFailure = firstFailure;
    }
}

