/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.reporting.history;

import fitnesse.FitNesseVersion;
import fitnesse.reporting.history.ExecutionReport;
import fitnesse.testsystems.TestSummary;
import fitnesse.util.DateTimeUtil;
import fitnesse.util.XmlUtil;
import fitnesse.wiki.PathParser;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class SuiteExecutionReport
extends ExecutionReport {
    private List<PageHistoryReference> pageHistoryReferences = new ArrayList<PageHistoryReference>();

    public SuiteExecutionReport(Document xmlDocument) throws Exception {
        this.unpackXml(xmlDocument);
    }

    public SuiteExecutionReport(FitNesseVersion version, String rootPath) {
        super(version, rootPath);
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof SuiteExecutionReport) {
            SuiteExecutionReport report = (SuiteExecutionReport)o;
            if (!super.equals(report)) {
                return false;
            }
            if (this.pageHistoryReferences.size() != report.pageHistoryReferences.size()) {
                return false;
            }
            return this.allReferencesEqual(this.pageHistoryReferences, report.pageHistoryReferences);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.pageHistoryReferences.size();
    }

    private boolean allReferencesEqual(List<PageHistoryReference> r1, List<PageHistoryReference> r2) {
        for (int i = 0; i < r1.size(); ++i) {
            if (r1.get(i).equals(r2.get(i))) continue;
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        return String.format("SuiteExecutionReport({%s}{%s})", super.toString(), this.pageHistoryReferencesToString());
    }

    private String pageHistoryReferencesToString() {
        StringBuilder builder = new StringBuilder();
        if (!this.pageHistoryReferences.isEmpty()) {
            for (PageHistoryReference reference : this.pageHistoryReferences) {
                builder.append(reference.toString());
                builder.append(",");
            }
            builder.deleteCharAt(builder.length() - 1);
        }
        return builder.toString();
    }

    public void toXml(Writer writer, VelocityEngine velocityEngine) throws Exception {
        VelocityContext velocityContext = new VelocityContext();
        velocityContext.put("suiteExecutionReport", (Object)this);
        Template template = velocityEngine.getTemplate("suiteHistoryXML.vm");
        template.merge((Context)velocityContext, writer);
    }

    @Override
    protected void unpackResults(Element testResults) {
        NodeList references = testResults.getElementsByTagName("pageHistoryReference");
        for (int referenceIndex = 0; referenceIndex < references.getLength(); ++referenceIndex) {
            Element refElement = (Element)references.item(referenceIndex);
            String name = XmlUtil.getTextValue(refElement, "name");
            long time = DateTimeUtil.getTimeFromString(XmlUtil.getTextValue(refElement, "date"));
            long runTimeInMillis = this.getRunTimeInMillisOrZeroIfNotPresent(refElement);
            PageHistoryReference r1 = new PageHistoryReference(name, time, runTimeInMillis);
            Element counts = XmlUtil.getElementByTagName(refElement, "counts");
            r1.setTestSummary(new TestSummary(Integer.valueOf(XmlUtil.getTextValue(counts, "right")), Integer.valueOf(XmlUtil.getTextValue(counts, "wrong")), Integer.valueOf(XmlUtil.getTextValue(counts, "ignores")), Integer.valueOf(XmlUtil.getTextValue(counts, "exceptions"))));
            this.pageHistoryReferences.add(r1);
        }
    }

    protected long getRunTimeInMillisOrZeroIfNotPresent(Element refElement) {
        String textValue = XmlUtil.getTextValue(refElement, "runTimeInMillis");
        return textValue == null ? 0L : Long.parseLong(textValue);
    }

    public List<PageHistoryReference> getPageHistoryReferences() {
        return this.pageHistoryReferences;
    }

    public void addPageHistoryReference(PageHistoryReference reference) {
        this.pageHistoryReferences.add(reference);
    }

    public static class PageHistoryReference {
        private String pageName;
        private long time;
        private long runTimeInMillis;
        private TestSummary testSummary = new TestSummary();

        public PageHistoryReference(String pageName, long time) {
            this(pageName, time, 0L);
        }

        public PageHistoryReference(String pageName, long time, long runTimeInMillis) {
            this.pageName = pageName;
            this.time = time;
            this.runTimeInMillis = runTimeInMillis;
        }

        public String toString() {
            return String.format("[%s, %s, %s, %s]", this.pageName, DateTimeUtil.formatDate(new Date(this.time)), this.testSummary, this.runTimeInMillis);
        }

        public boolean equals(Object o) {
            if (!(o instanceof PageHistoryReference)) {
                return false;
            }
            PageHistoryReference r = (PageHistoryReference)o;
            return StringUtils.equals((String)this.pageName, (String)r.pageName) && this.time == r.time && this.testSummary.equals(r.testSummary) && this.runTimeInMillis == r.runTimeInMillis;
        }

        public int hashCode() {
            return this.pageName.hashCode();
        }

        public String getPageName() {
            return this.pageName;
        }

        public String getRelativePageName() {
            return PathParser.parse(this.pageName).last();
        }

        public long getTime() {
            return this.time;
        }

        public long getRunTimeInMillis() {
            return this.runTimeInMillis;
        }

        public void setRunTimeInMillis(long runTimeInMillis) {
            this.runTimeInMillis = runTimeInMillis;
        }

        public String getDateString() {
            return DateTimeUtil.formatDate(new Date(this.time));
        }

        public String getResultDate() {
            SimpleDateFormat pageHistoryFormatter = new SimpleDateFormat("yyyyMMddHHmmss");
            return pageHistoryFormatter.format(new Date(this.time));
        }

        public TestSummary getTestSummary() {
            return this.testSummary;
        }

        public void setTestSummary(TestSummary testSummary) {
            this.testSummary = new TestSummary(testSummary);
        }
    }
}

