/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.responders;

import fitnesse.responders.WikiImporter;
import fitnesse.wiki.PageData;
import fitnesse.wiki.WikiPage;

public class MockWikiImporter
extends WikiImporter {
    public static final String mockContent = "mock importer content";
    public boolean fail;

    @Override
    protected void importRemotePageContent(WikiPage localPage) {
        if (this.fail) {
            this.importerClient.pageImportError(localPage, new Exception("blah"));
        } else {
            this.setMockContent(localPage);
        }
    }

    private void setMockContent(WikiPage localPage) {
        PageData data = localPage.getData();
        data.setContent(mockContent);
        localPage.commit(data);
    }

    @Override
    public void importWiki(WikiPage page) {
        for (WikiPage child : page.getChildren()) {
            child.getPageCrawler().traverse(this);
        }
    }

    @Override
    public void process(WikiPage page) {
        this.setMockContent(page);
    }
}

