/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.responders.editing;

import fitnesse.FitNesseContext;
import fitnesse.authentication.SecureOperation;
import fitnesse.authentication.SecureResponder;
import fitnesse.authentication.SecureWriteOperation;
import fitnesse.http.Request;
import fitnesse.http.Response;
import fitnesse.http.SimpleResponse;
import fitnesse.responders.ErrorResponder;
import fitnesse.responders.NotFoundResponder;
import fitnesse.wiki.PageCrawler;
import fitnesse.wiki.PageData;
import fitnesse.wiki.PathParser;
import fitnesse.wiki.WikiPage;
import fitnesse.wiki.WikiPagePath;
import fitnesse.wiki.WikiPageUtil;

public class AddChildPageResponder
implements SecureResponder {
    private WikiPage currentPage;
    private String childName;
    private WikiPagePath childPath;
    private String childContent;
    private String pageType;
    private String helpText;
    private String suites;
    private WikiPage pageTemplate;
    private String user;

    @Override
    public SecureOperation getSecureOperation() {
        return new SecureWriteOperation();
    }

    @Override
    public Response makeResponse(FitNesseContext context, Request request) {
        this.parseRequest(context, request);
        if (this.currentPage == null) {
            return this.notFoundResponse(context, request);
        }
        if (this.nameIsInvalid(this.childName)) {
            return this.errorResponse(context, request);
        }
        if (this.pageAlreadyExists(this.childName)) {
            return this.alreadyExistsResponse(context, request);
        }
        return this.createChildPageAndMakeResponse(context);
    }

    private void parseRequest(FitNesseContext context, Request request) {
        this.user = request.getAuthorizationUsername();
        this.childName = request.getInput("pageName");
        this.childName = this.childName == null ? "null" : this.childName;
        this.childPath = PathParser.parse(this.childName);
        WikiPagePath currentPagePath = PathParser.parse(request.getResource());
        PageCrawler pageCrawler = context.getRootPage().getPageCrawler();
        this.currentPage = pageCrawler.getPage(currentPagePath);
        if (request.hasInput("pageTemplate")) {
            this.pageTemplate = pageCrawler.getPage(PathParser.parse(request.getInput("pageTemplate")));
        } else {
            this.pageType = request.getInput("pageType");
        }
        this.childContent = request.getInput("pageContent");
        this.helpText = request.getInput("helpText");
        this.suites = request.getInput("suites");
        if (this.childContent == null) {
            this.childContent = "!contents\n";
        }
        if (this.pageTemplate == null && this.pageType == null) {
            this.pageType = "Default";
        }
    }

    private Response createChildPageAndMakeResponse(FitNesseContext context) {
        this.createChildPage(context);
        SimpleResponse response = new SimpleResponse();
        WikiPagePath fullPathOfCurrentPage = this.currentPage.getPageCrawler().getFullPath();
        response.redirect(context.contextRoot, fullPathOfCurrentPage.toString());
        return response;
    }

    private boolean nameIsInvalid(String name) {
        if (name.equals("")) {
            return true;
        }
        return !PathParser.isSingleWikiWord(name);
    }

    private boolean pageAlreadyExists(String childName) {
        return this.currentPage.getPageCrawler().pageExists(PathParser.parse(childName));
    }

    private void createChildPage(FitNesseContext context) {
        WikiPage childPage = WikiPageUtil.addPage(this.currentPage, this.childPath, this.childContent);
        this.setAttributes(childPage);
        context.recentChanges.updateRecentChanges(childPage);
    }

    private void setAttributes(WikiPage childPage) {
        PageData childPageData = childPage.getData();
        if (this.pageTemplate != null) {
            childPageData.setProperties(this.pageTemplate.getData().getProperties());
        } else if (this.pageType.equals("Static")) {
            childPageData.getProperties().remove("Test");
            childPageData.getProperties().remove("Suite");
        } else if ("Test".equals(this.pageType) || "Suite".equals(this.pageType)) {
            childPageData.getProperties().remove("Test");
            childPageData.getProperties().remove("Suite");
            childPageData.setAttribute(this.pageType);
        }
        childPageData.setAttribute("Help", this.helpText);
        childPageData.setAttribute("Suites", this.suites);
        childPageData.setOrRemoveAttribute("LastModifyingUser", this.user);
        childPage.commit(childPageData);
    }

    private Response errorResponse(FitNesseContext context, Request request) {
        return new ErrorResponder("Invalid Child Name").makeResponse(context, request);
    }

    private Response alreadyExistsResponse(FitNesseContext context, Request request) {
        return new ErrorResponder("Child page already exists", 409).makeResponse(context, request);
    }

    private Response notFoundResponse(FitNesseContext context, Request request) {
        return new NotFoundResponder().makeResponse(context, request);
    }
}

