/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.responders.editing;

import fitnesse.FitNesseContext;
import fitnesse.authentication.SecureOperation;
import fitnesse.authentication.SecureReadOperation;
import fitnesse.authentication.SecureResponder;
import fitnesse.html.HtmlUtil;
import fitnesse.html.template.HtmlPage;
import fitnesse.html.template.PageTitle;
import fitnesse.http.Request;
import fitnesse.http.Response;
import fitnesse.http.SimpleResponse;
import fitnesse.responders.NotFoundResponder;
import fitnesse.wiki.MockingPageCrawler;
import fitnesse.wiki.PageCrawler;
import fitnesse.wiki.PageData;
import fitnesse.wiki.PageType;
import fitnesse.wiki.PathParser;
import fitnesse.wiki.WikiImportProperty;
import fitnesse.wiki.WikiPage;
import fitnesse.wiki.WikiPagePath;
import fitnesse.wiki.WikiPageProperty;
import java.util.ArrayList;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class PropertiesResponder
implements SecureResponder {
    private WikiPage page;
    public PageData pageData;
    private String resource;
    private WikiPagePath path;
    private SimpleResponse response;
    private HtmlPage html;

    @Override
    public Response makeResponse(FitNesseContext context, Request request) {
        this.response = new SimpleResponse();
        this.resource = request.getResource();
        this.path = PathParser.parse(this.resource);
        PageCrawler crawler = context.getRootPage().getPageCrawler();
        this.page = crawler.getPage(this.path, new MockingPageCrawler());
        if (this.page == null) {
            return new NotFoundResponder().makeResponse(context, request);
        }
        this.pageData = this.page.getData();
        this.makeContent(context, request);
        this.response.setMaxAge(0);
        return this.response;
    }

    private void makeContent(FitNesseContext context, Request request) {
        if ("json".equals(request.getInput("format"))) {
            JSONObject jsonObject = this.makeJson();
            try {
                this.response.setContent(jsonObject.toString(1));
            }
            catch (JSONException e) {
                throw new RuntimeException(e);
            }
        } else {
            String html = this.makeHtml(context, request);
            this.response.setContent(html);
        }
    }

    private JSONObject makeJson() {
        String[] attributes;
        this.response.setContentType(Response.Format.JSON);
        JSONObject jsonObject = new JSONObject();
        for (String attribute : attributes = new String[]{PageType.TEST.toString(), "Search", "Edit", "Properties", "Versions", "Refactor", "WhereUsed", "RecentChanges", PageType.SUITE.toString(), "Prune", "secure-read", "secure-write", "secure-test", "Files"}) {
            this.addJsonAttribute(jsonObject, attribute);
        }
        if (this.pageData.hasAttribute("Help")) {
            jsonObject.put("Help", (Object)this.pageData.getAttribute("Help"));
        }
        if (this.pageData.hasAttribute("Suites")) {
            JSONArray tags = new JSONArray();
            for (String tag : this.pageData.getAttribute("Suites").split(",")) {
                if (!StringUtils.isNotBlank((String)tag)) continue;
                tags.put((Object)tag.trim());
            }
            jsonObject.put("Suites", (Object)tags);
        }
        return jsonObject;
    }

    private void addJsonAttribute(JSONObject jsonObject, String attribute) {
        try {
            jsonObject.put(attribute, this.pageData.hasAttribute(attribute));
        }
        catch (JSONException e) {
            throw new RuntimeException(e);
        }
    }

    private String makeHtml(FitNesseContext context, Request request) {
        this.html = context.pageFactory.newPage();
        this.html.setNavTemplate("viewNav");
        this.html.put("viewLocation", request.getResource());
        this.html.setTitle("Properties: " + this.resource);
        String tags = "";
        if (this.pageData != null) {
            tags = this.pageData.getAttribute("Suites");
        }
        this.html.setPageTitle(new PageTitle("Page Properties", this.path, tags));
        this.html.put("pageData", this.pageData);
        this.html.setMainTemplate("propertiesPage");
        this.makeLastModifiedTag();
        this.makeFormSections();
        return this.html.html();
    }

    private void makeLastModifiedTag() {
        String username = this.pageData.getAttribute("LastModifyingUser");
        if (username == null || "".equals(username)) {
            this.html.put("lastModified", "Last modified anonymously");
        } else {
            this.html.put("lastModified", "Last modified by " + username);
        }
    }

    private void makeFormSections() {
        this.makePropertiesForm();
        WikiImportProperty importProperty = WikiImportProperty.createFrom(this.pageData.getProperties());
        if (importProperty != null) {
            this.makeImportUpdateForm(importProperty);
        } else {
            this.makeImportForm();
        }
        this.makeSymbolicLinkSection();
    }

    private void makePropertiesForm() {
        this.makePageTypeRadiosHtml(this.pageData);
        this.makeTestActionCheckboxesHtml();
        this.makeNavigationCheckboxesHtml();
        this.makeSecurityCheckboxesHtml();
    }

    public void makePageTypeRadiosHtml(PageData pageData) {
        this.html.put("pageTypes", PageData.PAGE_TYPE_ATTRIBUTES);
        this.html.put("selectedPageType", this.getCheckedAttribute(pageData, PageData.PAGE_TYPE_ATTRIBUTES));
    }

    private String getCheckedAttribute(PageData pageData, String[] attributes) {
        for (int i = attributes.length - 1; i > 0; --i) {
            if (!pageData.hasAttribute(attributes[i])) continue;
            return attributes[i];
        }
        return attributes[0];
    }

    private void makeImportForm() {
        this.html.put("makeImportForm", true);
        this.html.put("autoUpdate", true);
    }

    private void makeImportUpdateForm(WikiImportProperty importProps) {
        if (importProps.isRoot()) {
            this.html.put("makeImportRootForm", true);
        } else {
            this.html.put("makeImportSubpageForm", true);
        }
        if (importProps.isAutoUpdate()) {
            this.html.put("autoUpdate", true);
        }
        this.html.put("sourceUrl", importProps.getSourceUrl());
    }

    private void makeSymbolicLinkSection() {
        WikiPageProperty symLinksProperty = this.pageData.getProperties().getProperty("SymbolicLinks");
        if (symLinksProperty == null) {
            return;
        }
        ArrayList<Symlink> symlinks = new ArrayList<Symlink>();
        Set<String> symbolicLinkNames = symLinksProperty.keySet();
        for (String name : symbolicLinkNames) {
            String link = symLinksProperty.get(name);
            String path = this.makePathForSymbolicLink(link);
            symlinks.add(new Symlink(name, HtmlUtil.escapeHTML(link), path));
        }
        this.html.put("symlinks", symlinks);
    }

    private String makePathForSymbolicLink(String linkPath) {
        WikiPagePath wikiPagePath = PathParser.parse(linkPath);
        if (wikiPagePath != null) {
            WikiPagePath fullPath;
            WikiPage parent = wikiPagePath.isRelativePath() ? this.page.getParent() : this.page;
            PageCrawler crawler = parent.getPageCrawler();
            WikiPage target = crawler.getPage(wikiPagePath);
            if (target != null) {
                fullPath = target.getPageCrawler().getFullPath();
                fullPath.makeAbsolute();
            } else {
                fullPath = new WikiPagePath();
            }
            return fullPath.toString();
        }
        return null;
    }

    @Override
    public SecureOperation getSecureOperation() {
        return new SecureReadOperation();
    }

    public void makeTestActionCheckboxesHtml() {
        this.html.put("actionTypes", PageData.ACTION_ATTRIBUTES);
    }

    public void makeNavigationCheckboxesHtml() {
        this.html.put("navigationTypes", PageData.NAVIGATION_ATTRIBUTES);
    }

    public void makeSecurityCheckboxesHtml() {
        this.html.put("securityTypes", PageData.SECURITY_ATTRIBUTES);
    }

    public static class Symlink {
        private String name;
        private String link;
        private String path;

        Symlink(String name, String link, String path) {
            this.name = name;
            this.link = link;
            this.path = path;
        }

        public String getName() {
            return this.name;
        }

        public String getLink() {
            return this.link;
        }

        public String getPath() {
            return this.path;
        }
    }
}

