/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.responders.editing;

import fitnesse.components.TraversalListener;
import fitnesse.wiki.PathParser;
import fitnesse.wiki.WikiPage;
import fitnesse.wiki.WikiPagePath;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import util.GracefulNamer;

public class TemplateUtil {
    public static List<String> getTemplatesFromUncles(WikiPage page) {
        final ArrayList<String> templatePaths = new ArrayList<String>();
        page.getPageCrawler().traverseUncles("TemplateLibrary", (TraversalListener<? super WikiPage>)new TraversalListener<WikiPage>(){

            @Override
            public void process(WikiPage uncle) {
                for (WikiPage template : uncle.getChildren()) {
                    WikiPagePath templatePath = new WikiPagePath(template);
                    templatePath.makeAbsolute();
                    templatePaths.add(PathParser.render(templatePath));
                }
            }
        });
        return templatePaths;
    }

    public static Map<String, String> getTemplateMap(WikiPage page) {
        return TemplateUtil.getShortTemplateNames(TemplateUtil.getTemplatesFromUncles(page));
    }

    public static Map<String, String> getTemplatePageMap(WikiPage page) {
        return TemplateUtil.getPageNames(TemplateUtil.getTemplatesFromUncles(page));
    }

    static Map<String, String> getPageNames(List<String> templatePaths) {
        TreeMap<String, String> pathsAndNames = new TreeMap<String, String>();
        for (String path : templatePaths) {
            String pageName = TemplateUtil.getPageName(path);
            if (pathsAndNames.containsKey(pageName)) continue;
            pathsAndNames.put(pageName, path);
        }
        return pathsAndNames;
    }

    static String getPageName(String path) {
        return GracefulNamer.regrace(path.substring(path.lastIndexOf(46) + 1));
    }

    static Map<String, String> getShortTemplateNames(List<String> templatePaths) {
        TreeMap<String, String> pathsAndNames = new TreeMap<String, String>();
        for (String path : templatePaths) {
            pathsAndNames.put(TemplateUtil.getShortTemplateName(path), path);
        }
        return pathsAndNames;
    }

    static String getShortTemplateName(String path) {
        String pathCopy = path;
        String templateName = pathCopy.substring(pathCopy.lastIndexOf(46) + 1);
        pathCopy = pathCopy.substring(0, pathCopy.lastIndexOf(46));
        String templateLibraryString = pathCopy.substring(pathCopy.lastIndexOf(46) + 1);
        pathCopy = pathCopy.substring(0, pathCopy.lastIndexOf(46));
        if (templateLibraryString.equals("TemplateLibrary")) {
            templateLibraryString = "_";
        }
        String parentName = pathCopy.substring(pathCopy.lastIndexOf(46) + 1);
        return parentName + "." + templateLibraryString + "." + templateName;
    }
}

