/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.slim.converters;

import fitnesse.slim.Converter;
import fitnesse.slim.SlimError;
import fitnesse.util.StringUtils;

public class GenericEnumConverter<T extends Enum<T>>
implements Converter<T> {
    private final Class<T> enumClass;

    public GenericEnumConverter(Class<T> enumClass) {
        this.enumClass = enumClass;
    }

    @Override
    public String toString(T o) {
        return o != null ? ((Enum)o).name() : NULL_VALUE;
    }

    @Override
    public T fromString(String name) {
        if (StringUtils.isBlank(name)) {
            return null;
        }
        try {
            return Enum.valueOf(this.enumClass, name);
        }
        catch (IllegalArgumentException e) {
            for (Enum value : (Enum[])this.enumClass.getEnumConstants()) {
                if (!value.name().equalsIgnoreCase(name)) continue;
                return (T)value;
            }
            throw new SlimError(String.format("message:<<Can't convert %s to enum value of type %s.>>", name, this.enumClass.getName()), e);
        }
    }
}

