/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.slim.fixtureInteraction;

import fitnesse.slim.ConverterSupport;
import fitnesse.slim.SlimError;
import fitnesse.slim.fixtureInteraction.FixtureInteraction;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class DefaultInteraction
implements FixtureInteraction {
    @Override
    public Object createInstance(List<String> paths, String className, Object[] args) throws IllegalArgumentException, InstantiationException, IllegalAccessException, InvocationTargetException {
        Class<?> k = this.searchPathsForClass(paths, className);
        Constructor<?> constructor = this.getConstructor(k.getConstructors(), args);
        if (constructor == null) {
            throw new SlimError(String.format("message:<<%s %s>>", "NO_CONSTRUCTOR", className));
        }
        return this.newInstance(args, constructor);
    }

    private Object newInstance(Object[] args, Constructor<?> constructor) throws IllegalAccessException, InstantiationException, InvocationTargetException {
        Object[] initargs = ConverterSupport.convertArgs(args, constructor.getParameterTypes());
        return this.newInstance(constructor, initargs);
    }

    protected Class<?> searchPathsForClass(List<String> paths, String className) {
        Class<?> k = this.getClass(className);
        if (k != null) {
            return k;
        }
        ArrayList<String> reversedPaths = new ArrayList<String>(paths);
        Collections.reverse(reversedPaths);
        for (String path : reversedPaths) {
            k = this.getClass(path + "." + className);
            if (k == null) continue;
            return k;
        }
        throw new SlimError(String.format("message:<<%s %s>>", "NO_CLASS", className));
    }

    private Class<?> getClass(String className) {
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    private Constructor<?> getConstructor(Constructor<?>[] constructors, Object[] args) {
        for (Constructor<?> constructor : constructors) {
            Class<?>[] arguments = constructor.getParameterTypes();
            if (arguments.length != args.length) continue;
            return constructor;
        }
        return null;
    }

    protected Object newInstance(Constructor<?> constructor, Object ... initargs) throws InvocationTargetException, InstantiationException, IllegalAccessException {
        return constructor.newInstance(initargs);
    }

    @Override
    public Object methodInvoke(Method method, Object instance, Object ... convertedArgs) throws Throwable {
        try {
            return method.invoke(instance, convertedArgs);
        }
        catch (InvocationTargetException e) {
            if (e.getCause() != null) {
                throw e.getCause();
            }
            throw e.getTargetException();
        }
    }
}

