/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.slim.instructions;

import fitnesse.slim.SlimException;
import fitnesse.slim.instructions.Instruction;
import fitnesse.slim.instructions.InstructionExecutor;
import fitnesse.slim.instructions.InstructionResult;

public class AssignInstruction
extends Instruction {
    public static final String INSTRUCTION = "assign";
    private String symbolName;
    private Object value;

    public AssignInstruction(String id, String symbolName, Object value) {
        super(id);
        this.symbolName = symbolName;
        this.value = value;
    }

    @Override
    protected InstructionResult executeInternal(InstructionExecutor executor) throws SlimException {
        executor.assign(this.symbolName, this.value);
        return new InstructionResult.Ok(this.getId());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{id='").append(this.getId()).append('\'');
        sb.append(", instruction='").append(INSTRUCTION).append('\'');
        sb.append(", symbolName='").append(this.symbolName).append('\'');
        sb.append(", value='").append(this.value).append('\'');
        sb.append('}');
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        AssignInstruction that = (AssignInstruction)o;
        if (!this.value.equals(that.value)) {
            return false;
        }
        return this.symbolName.equals(that.symbolName);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.symbolName.hashCode();
        result = 31 * result + this.value.hashCode();
        return result;
    }
}

