/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.testsystems;

import fitnesse.testsystems.ExecutionResult;

public class TestSummary {
    private int right = 0;
    private int wrong = 0;
    private int ignores = 0;
    private int exceptions = 0;

    public TestSummary(int right, int wrong, int ignores, int exceptions) {
        this.right = right;
        this.wrong = wrong;
        this.ignores = ignores;
        this.exceptions = exceptions;
    }

    public TestSummary(TestSummary testSummary) {
        this.right = testSummary.getRight();
        this.wrong = testSummary.getWrong();
        this.ignores = testSummary.getIgnores();
        this.exceptions = testSummary.getExceptions();
    }

    public TestSummary() {
    }

    public String toString() {
        return this.getRight() + " right, " + this.getWrong() + " wrong, " + this.getIgnores() + " ignored, " + this.getExceptions() + " exceptions";
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof TestSummary)) {
            return false;
        }
        TestSummary other = (TestSummary)o;
        return this.getRight() == other.getRight() && this.getWrong() == other.getWrong() && this.getIgnores() == other.getIgnores() && this.getExceptions() == other.getExceptions();
    }

    public int hashCode() {
        assert (false) : "hashCode not designed";
        return 42;
    }

    public void add(TestSummary testSummary) {
        this.right = this.getRight() + testSummary.getRight();
        this.wrong = this.getWrong() + testSummary.getWrong();
        this.ignores = this.getIgnores() + testSummary.getIgnores();
        this.exceptions = this.getExceptions() + testSummary.getExceptions();
    }

    public void clear() {
        this.right = 0;
        this.wrong = 0;
        this.ignores = 0;
        this.exceptions = 0;
    }

    public int getRight() {
        return this.right;
    }

    public int getWrong() {
        return this.wrong;
    }

    public int getIgnores() {
        return this.ignores;
    }

    public int getExceptions() {
        return this.exceptions;
    }

    public void add(ExecutionResult executionResult) {
        if (executionResult != null) {
            switch (executionResult) {
                case PASS: {
                    ++this.right;
                    break;
                }
                case FAIL: {
                    ++this.wrong;
                    break;
                }
                case IGNORE: {
                    ++this.ignores;
                    break;
                }
                case ERROR: {
                    ++this.exceptions;
                }
            }
        }
    }
}

