/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.testsystems.slim.tables;

import fitnesse.testsystems.ExecutionResult;
import fitnesse.testsystems.TestResult;
import fitnesse.testsystems.slim.SlimTestContext;
import fitnesse.testsystems.slim.Table;
import fitnesse.testsystems.slim.results.SlimExceptionResult;
import fitnesse.testsystems.slim.results.SlimTestResult;
import fitnesse.testsystems.slim.tables.SlimAssertion;
import fitnesse.testsystems.slim.tables.SlimExpectation;
import fitnesse.testsystems.slim.tables.SlimTable;
import fitnesse.testsystems.slim.tables.SyntaxError;
import fitnesse.util.StringUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class QueryTable
extends SlimTable {
    private static final String COMMENT_COLUMN_MARKER = "#";
    protected List<String> fieldNames = new ArrayList<String>();

    public QueryTable(Table table, String id, SlimTestContext testContext) {
        super(table, id, testContext);
    }

    @Override
    protected String getTableType() {
        return "queryTable";
    }

    public boolean matches(String actual, String expected) {
        if (actual == null || expected == null) {
            return false;
        }
        if (actual.equals(this.replaceSymbols(expected))) {
            return true;
        }
        SlimTable.Comparator c = new SlimTable.Comparator(this, actual, expected);
        return c.matches();
    }

    public SlimTestResult matchMessage(String actual, String expected) {
        if (actual == null) {
            return SlimTestResult.fail("NULL");
        }
        if (actual.equals(this.replaceSymbols(expected))) {
            return SlimTestResult.pass(this.replaceSymbolsWithFullExpansion(expected));
        }
        SlimTable.Comparator c = new SlimTable.Comparator(this, actual, expected);
        return c.evaluate();
    }

    @Override
    public List<SlimAssertion> getAssertions() throws SyntaxError {
        if (this.table.getRowCount() < 2) {
            throw new SyntaxError("Query tables must have at least two rows.");
        }
        this.assignColumns();
        SlimAssertion make = this.constructFixture(this.getFixtureName());
        SlimAssertion ti = this.makeAssertion(this.callFunction(this.getTableName(), "table", this.tableAsList()), new SlimTable.SilentReturnExpectation(this, 0, 0));
        SlimAssertion qi = this.makeAssertion(this.callFunction(this.getTableName(), "query", new Object[0]), new QueryTableExpectation());
        return Arrays.asList(make, ti, qi);
    }

    private void assignColumns() {
        int cols = this.table.getColumnCountInRow(1);
        for (int col = 0; col < cols; ++col) {
            this.fieldNames.add(this.table.getCellContents(col, 1));
        }
    }

    private ExecutionResult scanRowsForMatches(List<List<List<Object>>> queryResultList) {
        QueryResults queryResults = new QueryResults(queryResultList);
        Collection<MatchedResult> potentialMatches = queryResults.scorePotentialMatches();
        ArrayList<MatchedResult> potentialMatchesByScore = new ArrayList<MatchedResult>(potentialMatches);
        Collections.sort(potentialMatchesByScore, MatchedResult.compareByScore());
        return this.markRows(queryResults, potentialMatchesByScore);
    }

    protected ExecutionResult markRows(QueryResults queryResults, Iterable<MatchedResult> potentialMatchesByScore) {
        List<Integer> unmatchedTableRows = this.unmatchedRows(this.table.getRowCount());
        unmatchedTableRows.remove((Object)0);
        unmatchedTableRows.remove((Object)1);
        List<Integer> unmatchedResultRows = this.unmatchedRows(queryResults.getRows().size());
        while (!this.isEmpty(potentialMatchesByScore)) {
            MatchedResult bestMatch = this.takeBestMatch(potentialMatchesByScore);
            this.markFieldsInMatchedRow(bestMatch.tableRow, bestMatch.resultRow, queryResults);
            unmatchedTableRows.remove(bestMatch.tableRow);
            unmatchedResultRows.remove(bestMatch.resultRow);
        }
        this.markMissingRows(unmatchedTableRows);
        this.markSurplusRows(queryResults, unmatchedResultRows);
        return !unmatchedTableRows.isEmpty() || !unmatchedResultRows.isEmpty() ? ExecutionResult.FAIL : ExecutionResult.PASS;
    }

    protected MatchedResult takeBestMatch(Iterable<MatchedResult> potentialMatchesByScore) {
        MatchedResult bestResult = potentialMatchesByScore.iterator().next();
        this.removeOtherwiseMatchedResults(potentialMatchesByScore, bestResult);
        return bestResult;
    }

    protected boolean isEmpty(Iterable<MatchedResult> iterable) {
        return !iterable.iterator().hasNext();
    }

    protected void removeOtherwiseMatchedResults(Iterable<MatchedResult> potentialMatchesByScore, MatchedResult bestResult) {
        Iterator<MatchedResult> iterator = potentialMatchesByScore.iterator();
        while (iterator.hasNext()) {
            MatchedResult otherResult = iterator.next();
            if (!otherResult.tableRow.equals(bestResult.tableRow) && !otherResult.resultRow.equals(bestResult.resultRow)) continue;
            iterator.remove();
        }
    }

    protected List<Integer> unmatchedRows(int rowCount) {
        ArrayList<Integer> result = new ArrayList<Integer>(rowCount);
        for (int i = 0; i < rowCount; ++i) {
            result.add(i);
        }
        return result;
    }

    protected void markMissingRows(List<Integer> missingRows) {
        for (int missingRow : missingRows) {
            this.markMissingRow(missingRow);
        }
    }

    protected void markMissingRow(int missingRow) {
        this.replaceAllvariablesInRow(missingRow);
        SlimTestResult testResult = SlimTestResult.fail(null, this.table.getCellContents(0, missingRow), "missing");
        this.table.updateContent(0, missingRow, testResult);
        this.getTestContext().increment(testResult.getExecutionResult());
    }

    protected void markSurplusRows(QueryResults queryResults, List<Integer> unmatchedRows) {
        for (int unmatchedRow : unmatchedRows) {
            List<String> surplusRow = queryResults.getList(this.fieldNames, unmatchedRow);
            int newTableRow = this.table.addRow(surplusRow);
            SlimTestResult testResult = SlimTestResult.fail(surplusRow.get(0), null, "surplus");
            this.table.updateContent(0, newTableRow, testResult);
            this.getTestContext().increment(ExecutionResult.FAIL);
            this.markMissingFields(surplusRow, newTableRow);
        }
    }

    private void markMissingFields(List<String> surplusRow, int newTableRow) {
        for (int col = 0; col < surplusRow.size(); ++col) {
            String surplusField = surplusRow.get(col);
            if (surplusField != null) continue;
            String fieldName = this.fieldNames.get(col);
            SlimTestResult testResult = SlimTestResult.fail(String.format("field %s not present", fieldName));
            this.table.updateContent(col, newTableRow, testResult);
            this.getTestContext().increment(testResult.getExecutionResult());
        }
    }

    protected void replaceAllvariablesInRow(int tableRow) {
        int columns = this.table.getColumnCountInRow(tableRow);
        for (int col = 0; col < columns; ++col) {
            String contents = this.table.getCellContents(col, tableRow);
            this.table.substitute(col, tableRow, this.replaceSymbolsWithFullExpansion(contents));
        }
    }

    protected void markFieldsInMatchedRow(int tableRow, int matchedRow, QueryResults queryResults) {
        int columns = this.table.getColumnCountInRow(tableRow);
        for (int col = 0; col < columns; ++col) {
            this.markField(tableRow, matchedRow, col, queryResults);
        }
    }

    protected TestResult markField(int tableRow, int matchedRow, int col, QueryResults queryResults) {
        SlimTestResult testResult;
        if (col >= this.fieldNames.size()) {
            return null;
        }
        String fieldName = this.fieldNames.get(col);
        String actualValue = queryResults.getCell(fieldName, matchedRow);
        String expectedValue = this.table.getCellContents(col, tableRow);
        if (fieldName.startsWith(COMMENT_COLUMN_MARKER)) {
            testResult = SlimTestResult.plain();
        } else if (actualValue == null) {
            testResult = SlimTestResult.fail(String.format("field %s not present", fieldName), expectedValue);
        } else if (expectedValue == null || expectedValue.isEmpty()) {
            testResult = SlimTestResult.ignore(actualValue);
        } else {
            String symbolName = this.ifSymbolAssignment(expectedValue);
            if (symbolName != null) {
                this.setSymbol(symbolName, actualValue, true);
                testResult = SlimTestResult.ignore(String.format("$%s<-[%s]", symbolName, actualValue));
            } else {
                testResult = this.matchMessage(actualValue, expectedValue);
                if (testResult == null) {
                    testResult = SlimTestResult.fail(actualValue, this.replaceSymbolsWithFullExpansion(expectedValue));
                } else if (testResult.getExecutionResult() == ExecutionResult.PASS) {
                    testResult = this.markMatch(tableRow, matchedRow, col, testResult.getMessage());
                }
            }
        }
        this.table.updateContent(col, tableRow, testResult);
        this.getTestContext().increment(testResult.getExecutionResult());
        return testResult;
    }

    protected SlimTestResult markMatch(int tableRow, int matchedRow, int col, String message) {
        return SlimTestResult.pass(message);
    }

    protected static class MatchedResult {
        final Integer tableRow;
        final Integer resultRow;
        final int score;

        public MatchedResult(int tableRow, int resultRow, int score) {
            this.tableRow = tableRow;
            this.resultRow = resultRow;
            this.score = score;
        }

        public static Comparator<MatchedResult> compareByScore() {
            return new Comparator<MatchedResult>(){

                @Override
                public int compare(MatchedResult o1, MatchedResult o2) {
                    return o2.score - o1.score;
                }
            };
        }
    }

    protected class QueryResults {
        private List<QueryResultRow> rows = new ArrayList<QueryResultRow>();

        public QueryResults(List<List<List<Object>>> queryResultTable) {
            for (int i = 0; i < queryResultTable.size(); ++i) {
                this.rows.add(new QueryResultRow(i, queryResultTable.get(i)));
            }
            this.rows = Collections.unmodifiableList(this.rows);
        }

        public Collection<MatchedResult> scorePotentialMatches() {
            ArrayList<MatchedResult> result = new ArrayList<MatchedResult>();
            int rows = QueryTable.this.table.getRowCount();
            for (int tableRow = 2; tableRow < rows; ++tableRow) {
                result.addAll(new QueryMatcher(QueryTable.this.fieldNames).scoreMatches(tableRow));
            }
            return result;
        }

        public List<String> getList(List<String> fieldNames, int row) {
            ArrayList<String> result = new ArrayList<String>();
            for (String name : fieldNames) {
                result.add(this.rows.get(row).get(name));
            }
            return result;
        }

        public String getCell(String name, int row) {
            return this.rows.get(row).get(name);
        }

        public List<QueryResultRow> getRows() {
            return this.rows;
        }

        private class QueryResultRow {
            private final int index;
            private final Map<String, String> values;

            public QueryResultRow(int index, List<List<Object>> values) {
                this.index = index;
                HashMap<String, String> rowMap = new HashMap<String, String>();
                for (List<Object> columnPair : values) {
                    String fieldName = (String)columnPair.get(0);
                    String fieldValue = (String)columnPair.get(1);
                    rowMap.put(fieldName, fieldValue);
                }
                this.values = rowMap;
            }

            public String get(String fieldName) {
                return this.values.get(fieldName);
            }
        }

        private class QueryMatcher {
            private final List<String> fields;

            private QueryMatcher(List<String> fields) {
                this.fields = fields;
            }

            public Collection<MatchedResult> scoreMatches(int tableRow) {
                ArrayList<MatchedResult> result = new ArrayList<MatchedResult>();
                for (QueryResultRow row : QueryResults.this.rows) {
                    MatchedResult match = this.scoreMatch(QueryTable.this.table, tableRow, row);
                    if (match.score <= 0) continue;
                    result.add(match);
                }
                return result;
            }

            private MatchedResult scoreMatch(Table table, int tableRow, QueryResultRow row) {
                int score = 0;
                for (int fieldIndex = 0; fieldIndex < this.fields.size(); ++fieldIndex) {
                    String expectedValue;
                    String fieldName = this.fields.get(fieldIndex);
                    if (fieldName.startsWith(QueryTable.COMMENT_COLUMN_MARKER)) continue;
                    String actualValue = row.get(fieldName);
                    if (QueryTable.this.matches(actualValue, expectedValue = table.getCellContents(fieldIndex, tableRow))) {
                        ++score;
                        continue;
                    }
                    if (!StringUtils.isBlank(expectedValue)) break;
                }
                return new MatchedResult(tableRow, row.index, score);
            }
        }
    }

    public class QueryTableExpectation
    implements SlimExpectation {
        @Override
        public TestResult evaluateExpectation(Object queryReturn) {
            SlimTestResult testResult;
            if (queryReturn == null) {
                testResult = SlimTestResult.testNotRun();
            } else if (queryReturn instanceof List) {
                testResult = new SlimTestResult(QueryTable.this.scanRowsForMatches((List)queryReturn));
                testResult.setVariables(QueryTable.this.getSymbolsToStore());
            } else {
                testResult = SlimTestResult.error(String.format("The query method returned: %s", queryReturn));
                QueryTable.this.table.updateContent(0, 0, testResult);
                QueryTable.this.getTestContext().increment(testResult.getExecutionResult());
            }
            return testResult;
        }

        @Override
        public SlimExceptionResult evaluateException(SlimExceptionResult exceptionResult) {
            QueryTable.this.table.updateContent(0, 0, exceptionResult);
            QueryTable.this.getTestContext().incrementErroredTestsCount();
            return exceptionResult;
        }
    }
}

