/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.util;

import java.io.UnsupportedEncodingException;

public class Base64 {
    private static final byte[] base64Alphabet = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/".getBytes();
    private static final byte pad = 61;
    private static final int[] base64Value = new int[256];

    public static String decode(String value) throws UnsupportedEncodingException {
        return new String(Base64.decode(value.getBytes("UTF-8")));
    }

    public static byte[] decode(byte[] bytes) {
        int lengthOfDecoding = Base64.getLengthOfDecoding(bytes);
        byte[] decoding = new byte[lengthOfDecoding];
        int decodingIndex = 0;
        for (int index = 0; index < bytes.length; index += 4) {
            int v1 = Base64.getValueFor(bytes[index]);
            int v2 = Base64.getValueFor(bytes[index + 1]);
            int v3 = Base64.getValueFor(bytes[index + 2]);
            int v4 = Base64.getValueFor(bytes[index + 3]);
            int c1 = (v1 << 2 | v2 >> 4) & 0xFF;
            int c2 = (v2 << 4 | v3 >> 2) & 0xFF;
            int c3 = (v3 << 6 | v4) & 0xFF;
            decoding[decodingIndex++] = (byte)c1;
            if (bytes[index + 2] != 61) {
                decoding[decodingIndex++] = (byte)c2;
            }
            if (bytes[index + 3] == 61) continue;
            decoding[decodingIndex++] = (byte)c3;
        }
        return decoding;
    }

    public static String encode(String value) {
        return new String(Base64.encode(value.getBytes()));
    }

    public static byte[] encode(byte[] bytes) {
        int inputLength = bytes.length;
        int lengthOfEncoding = Base64.getLengthOfEncoding(bytes);
        byte[] encoding = new byte[lengthOfEncoding];
        int encodingIndex = 0;
        for (int index = 0; index < inputLength; index += 3) {
            byte c1 = bytes[index];
            byte c2 = index + 1 >= inputLength ? (byte)0 : bytes[index + 1];
            byte c3 = index + 2 >= inputLength ? (byte)0 : bytes[index + 2];
            int v1 = (c1 & 0xFC) >> 2 & 0x3F;
            int v2 = (c1 << 4 | (c2 & 0xF0) >> 4) & 0x3F;
            int v3 = (c2 << 2 | (c3 & 0xC0) >> 6) & 0x3F;
            int v4 = c3 & 0x3F;
            encoding[encodingIndex++] = base64Alphabet[v1];
            encoding[encodingIndex++] = base64Alphabet[v2];
            encoding[encodingIndex++] = index + 1 >= inputLength ? 61 : base64Alphabet[v3];
            encoding[encodingIndex++] = index + 2 >= inputLength ? 61 : base64Alphabet[v4];
        }
        return encoding;
    }

    private static int getLengthOfDecoding(byte[] bytes) {
        if ((bytes.length & 3) != 0) {
            throw new IllegalArgumentException("Truncated BASE64 data? length=" + bytes.length);
        }
        int lengthOfOutput = (bytes.length >> 2) * 3;
        if (bytes.length > 0) {
            if (bytes[bytes.length - 1] == 61) {
                --lengthOfOutput;
            }
            if (bytes[bytes.length - 2] == 61) {
                --lengthOfOutput;
            }
        }
        return lengthOfOutput;
    }

    private static int getLengthOfEncoding(byte[] bytes) {
        return (bytes.length + 2) / 3 << 2;
    }

    public static int getValueFor(byte b) {
        int value = base64Value[b & 0xFF];
        if (value == -1) {
            throw new IllegalArgumentException("Invalid BASE64 symbol: " + (char)(b & 0xFF));
        }
        return value;
    }

    static {
        for (int i = 0; i <= 255; ++i) {
            Base64.base64Value[i] = -1;
        }
        for (int v = 0; v <= 63; ++v) {
            Base64.base64Value[Base64.base64Alphabet[v]] = v;
        }
        Base64.base64Value[61] = 0;
    }
}

