/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.wiki.refactoring;

import fitnesse.wiki.WikiPage;
import fitnesse.wiki.WikiWordReference;
import fitnesse.wiki.refactoring.ReferenceRenamer;
import fitnesse.wikitext.parser.Alias;
import fitnesse.wikitext.parser.Symbol;
import fitnesse.wikitext.parser.WikiWord;
import java.util.logging.Level;
import java.util.logging.Logger;

public class MovedPageReferenceRenamer
extends ReferenceRenamer {
    private static final Logger LOG = Logger.getLogger(MovedPageReferenceRenamer.class.getName());
    private WikiPage pageToBeMoved;
    private String newParentName;

    public MovedPageReferenceRenamer(WikiPage root, WikiPage pageToBeMoved, String newParentName) {
        super(root);
        this.pageToBeMoved = pageToBeMoved;
        this.newParentName = newParentName;
    }

    @Override
    public boolean visit(Symbol node) {
        try {
            if (node.isType(WikiWord.symbolType)) {
                new WikiWordReference(this.currentPage, node.getContent()).wikiWordRenameMovedPageIfReferenced(node, this.pageToBeMoved, this.newParentName);
            }
        }
        catch (Exception e) {
            LOG.log(Level.WARNING, "Unable to rename moved page references", e);
            throw new RuntimeException(e);
        }
        return true;
    }

    @Override
    public boolean visitChildren(Symbol node) {
        return !node.isType(Alias.symbolType);
    }
}

