/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import util.Option;

public class CommandLine
extends Option {
    private static final Pattern optionPattern = Pattern.compile("\\[-(\\w+)((?: \\w+)*)\\]");
    private Map<String, Option> possibleOptions = new ConcurrentHashMap<String, Option>();

    public CommandLine(String optionDescriptor) {
        int optionEndIndex = 0;
        Matcher matcher = optionPattern.matcher(optionDescriptor);
        while (matcher.find()) {
            Option option = new Option();
            option.parseArgumentDescriptor(matcher.group(2));
            this.possibleOptions.put(matcher.group(1), option);
            optionEndIndex = matcher.end();
        }
        String remainder = optionDescriptor.substring(optionEndIndex);
        this.parseArgumentDescriptor(remainder);
    }

    public boolean parse(String[] args) {
        boolean successfulParse = true;
        Option currentOption = this;
        for (int i = 0; successfulParse && i < args.length; ++i) {
            String arg = args[i];
            if (currentOption != this && !((Option)currentOption).needsMoreArguments()) {
                currentOption = this;
            }
            if (arg.startsWith("-")) {
                if (((Option)currentOption).needsMoreArguments() && currentOption != this) {
                    successfulParse = false;
                    continue;
                }
                String argName = arg.substring(1);
                currentOption = this.possibleOptions.get(argName);
                if (currentOption != null) {
                    currentOption.active = true;
                    continue;
                }
                successfulParse = false;
                continue;
            }
            if (((Option)currentOption).needsMoreArguments()) {
                ((Option)currentOption).addArgument(arg);
                continue;
            }
            successfulParse = false;
        }
        if (successfulParse && ((Option)currentOption).needsMoreArguments()) {
            successfulParse = false;
        }
        return successfulParse;
    }

    public boolean hasOption(String optionName) {
        Option option = this.possibleOptions.get(optionName);
        if (option == null) {
            return false;
        }
        return option.active;
    }

    public String getOptionArgument(String optionName, String argName) {
        return this.getOptionArgument(optionName, argName, null);
    }

    public String getOptionArgument(String optionName, String argName, String defaultValue) {
        Option option = this.possibleOptions.get(optionName);
        if (option == null) {
            return null;
        }
        String v = option.getArgument(argName);
        return v != null ? v : defaultValue;
    }
}

